/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.model.Locatable;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.git.cmd.GITOperationCommit;
import oracle.jdevimpl.vcs.git.cmd.GITStatusFilter;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitStatus;

public class GITOperationCommitAll
extends GITOperationCommit {
    private GITStatusFilter _filterNotVersioned = null;

    public GITOperationCommitAll() {
        super("oracle.jdeveloper.git.commit-all");
    }

    @Override
    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        if (this.isCommitConflict()) {
            return this.getRootOperand(profile);
        }
        ArrayList<Locatable> locs = new ArrayList<Locatable>();
        Locatable[] root = this.getRootOperand(profile);
        if (root.length == 0) {
            return super.getOperands(profile);
        }
        URL[] urls = new URL[]{root[0].getURL()};
        if (this.isAutoAddFiles()) {
            this.getFilteredCollectionWithProgress(locs, urls, this.getNonVersionedFilter(), Resource.get("COMMIT_PROGRESS_TITLE"), Resource.get("COMMIT_NON_VERSIONED_PROGRESS"));
        }
        this.getFilteredCollectionWithProgress(locs, urls, _filter, Resource.get("COMMIT_PROGRESS_TITLE"), Resource.get("COMMIT_PROGRESS"));
        return locs.toArray(new Locatable[0]);
    }

    @Override
    protected int doitImpl(VCSProfile profile) throws Exception {
        int stat;
        Locatable[] root = this.getRootOperand(profile);
        if (root.length > 0 && (stat = this.saveNodesIfDirty(root)) != 0) {
            return stat;
        }
        Locatable[] locatables = this.getOperands(profile);
        return this.doitImplInvoke(profile, locatables);
    }

    private GITStatusFilter getNonVersionedFilter() {
        if (this._filterNotVersioned == null) {
            this._filterNotVersioned = new GITNotVersioned();
        }
        return this._filterNotVersioned;
    }

    private static class GITNotVersioned
    implements GITStatusFilter {
        private GITNotVersioned() {
        }

        @Override
        public boolean accept(GitStatus status) {
            return !status.isTracked();
        }
    }
}

