/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITExportCommitted;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationExportCommitted
extends GITExtendedAbstractOperation {
    private static final String EXPORTNAME = "ExportCommitted";

    public GITOperationExportCommitted() {
        super("oracle.jdeveloper.git.export-committed", VCSCommandStyle.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doitImplInvoke(VCSProfile profile, Locatable[] locatables) throws Exception {
        GitClient client = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Log");
            client = GITClientAdaptor.getClient(locatables[0].getURL());
            SearchCriteria sc = new SearchCriteria();
            File[] files = new File[]{new File(locatables[0].getURL().toURI())};
            sc.setFiles(files);
            sc.setLimit(1);
            GitRevisionInfo[] revisions = client.log(sc, (ProgressMonitor)monitor);
            if (revisions.length == 0) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("INFORMATION_NO_COMMITTED"), (String)Resource.get("INFORMATION_NO_COMMITTED_TITLE"), null);
                int n = 1;
                return n;
            }
            int n = super.doitImplInvoke(profile, locatables);
            return n;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] locs = this.getRootOperand(profile);
        if (locs.length == 0) {
            return super.getOperands(profile);
        }
        return locs;
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        Locatable[] locatables;
        try {
            locatables = this.getRootOperand(this.getProfile());
        }
        catch (Exception e) {
            return null;
        }
        if (locatables.length > 0) {
            try {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("ExportFile", this.getExportFileSuggestion(EXPORTNAME));
                options.put("RootURL", locatables[0].getURL());
                options.put("Branch", this.getCurrentBranch(locatables[0].getURL()));
                GITExportCommitted customizer = new GITExportCommitted();
                customizer.setOptions(options);
                return customizer;
            }
            catch (GITProcessException e) {
                GITProfile.getQualifiedLogger(GITOperationExportCommitted.class.getName()).log(Level.SEVERE, " Failed to get branches " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        boolean rmFile = false;
        String commitid = (String)options.get("CommitId");
        String branch = (String)options.get("Branch");
        String tag = (String)options.get("Tag");
        URL rootUrl = (URL)options.get("RootURL");
        URL exportUrl = (URL)options.get("ExportFile");
        OutputStream os = null;
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("checkoutRevision");
        monitor.setLog(true);
        GitClient client = null;
        try {
            String revision = commitid;
            if (revision == null) {
                revision = branch != null ? branch : tag;
            }
            os = this.getOutputStream(exportUrl);
            client = GITClientAdaptor.getClient(rootUrl);
            client.exportCommit(revision, os, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("EXPORT_EXP_COMMIT_ERROR"), monitor.getError());
            }
            this.saveExportLocation(exportUrl);
            this.openEditor(exportUrl);
        }
        catch (GitException ex) {
            rmFile = true;
            throw new GITProcessException(Resource.get("EXPORT_EXP_COMMIT_ERROR"), ex.getMessage());
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (rmFile) {
                    URLFileSystem.delete((URL)exportUrl);
                }
            }
            catch (Exception ex) {}
            if (client != null) {
                client.release();
            }
        }
        return true;
    }
}

