/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedNodeAbstractOperation;
import oracle.jdevimpl.vcs.git.cmd.GITStatusFilter;
import oracle.jdevimpl.vcs.git.cmd.GITStatusNotCommited;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITExportUncommitted;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationExportUncommitted
extends GITExtendedNodeAbstractOperation {
    private static final String EXPORTFILE = "ExportChanges";
    protected static final GITStatusFilter _filter = new GITStatusNotCommited();

    public GITOperationExportUncommitted() {
        super("oracle.jdeveloper.git.export-uncommitted", VCSCommandStyle.NORMAL);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        GITExportUncommitted customizer = new GITExportUncommitted();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("export.file", URLFileSystem.getPlatformPathName((URL)this.getExportFileSuggestion(EXPORTFILE)));
        customizer.setOptions(options);
        return customizer;
    }

    @Override
    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer) {
        this.setGITVersionOperationPanel(VCSComponents.createSelectFileListerComponent((Collection)nodes));
        JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)this.getGITVersionOperationPanel(), (Component)customizer.getComponent(), (String)this.getHelpTopicId(), (Component)customizer.getInitialFocusComponent());
        return dialog;
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] locs = this.getRootOperand(profile);
        if (locs.length == 0) {
            return super.getOperands(profile);
        }
        ArrayList<Locatable> exports = new ArrayList<Locatable>();
        this.getFilteredCollectionWithProgress(exports, new URL[]{locs[0].getURL()}, _filter, Resource.get("EXPORT_PROGRESS_TITLE"), Resource.get("EXPORT_PROGRESS"));
        if (exports.isEmpty()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("INFO_NO_EXPORT_COMM"), (String)Resource.get("INFO_NO_EXPORT_COMM_TITLE"), null);
        }
        return exports.toArray(new Locatable[0]);
    }

    @Override
    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, Resource.get("OPERATION_EXPORT_UNCOM_PROGRESS_TITLE"), (Object)Resource.get("OPERATION_EXPORT_UNCOM_PROGRESS_MESSAGE"), "", 0, -1);
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        Locatable[] locatables = this.getGITVersionOperationPanel().getSelectedLocatables();
        if (locatables.length == 0) {
            return false;
        }
        URL exportURL = URLFactory.newURL((String)((String)options.get("export.file")));
        GitClient client = null;
        OutputStream os = null;
        try {
            client = GITClientAdaptor.getClient(locatables[0].getURL());
            os = this.getOutputStream(exportURL);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Export");
            client.exportDiff(GITUtil.convertLocatableToFile(locatables).toArray(new File[0]), GitClient.DiffMode.HEAD_VS_WORKINGTREE, os, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("EXPORT_UNCOMMITTED_ERROR"), monitor.getError());
            }
            this.saveExportLocation(exportURL);
            this.openEditor(exportURL);
        }
        catch (IOException io) {
            throw new GITProcessException(Resource.get("EXPORT_UNCOMMITTED_ERROR"), io);
        }
        catch (GitException ge) {
            throw new GITProcessException(Resource.get("EXPORT_UNCOMMITTED_ERROR"), (Exception)((Object)ge));
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {}
            if (client != null) {
                client.release();
            }
        }
        return true;
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        int stat;
        Locatable[] root = this.getRootOperand(profile);
        if (root.length > 0 && (stat = this.saveNodesIfDirty(root)) != 0) {
            return stat;
        }
        Locatable[] locatables = this.getOperands(profile);
        return this.doitImplInvoke(profile, locatables);
    }
}

