/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.git.GITIgnore;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITIgnorePanel;

public class GITOperationIgnore
extends GITAbstractOperation {
    private static final String COMMAND_ID = "oracle.jdeveloper.git.ignore";

    public GITOperationIgnore() {
        super(COMMAND_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommand(VCSProfile profile, CommandState command) throws Exception {
        URL[] urls = this.getSelectedURLs(profile);
        URL ignoreURL = URLFactory.newURL((URL)GITUtil.getRootContaining(urls[0]), (String)".gitignore");
        if (!this.saveURL(ignoreURL)) {
            return false;
        }
        if (URLFileSystem.exists((URL)ignoreURL) && !URLFileSystem.canWrite((URL)ignoreURL)) {
            throw new GITProcessException(Resource.format("ERROR_IGNORE_CAN_WRITE", URLFileSystem.getPlatformPathName((URL)ignoreURL)));
        }
        GITIgnore ignore = new GITIgnore();
        Collection<String> ignorePatterns = ignore.getIgnorePatterns(ignoreURL);
        GITIgnorePanel panel = new GITIgnorePanel(ignoreURL, urls, this.patternAsString(ignorePatterns));
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)((Object)panel), (Component)panel.getInitialFocusComponent(), (String)this.getDialogTitle(), (int)7);
        try {
            if (dialog.runDialog()) {
                String pattern = panel.getPattern();
                ignore.addPattern(ignoreURL, pattern, ignorePatterns);
                profile.getPolicyStatusCache().clear();
                VCSBufferUtils.reloadBuffer((URL)ignoreURL);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            dialog.dispose();
        }
        return false;
    }

    private URL[] getSelectedURLs(VCSProfile profile) throws Exception {
        Locatable[] locatables = this.getOperands(profile);
        return VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
    }

    private String patternAsString(Collection<String> patterns) {
        StringBuilder sb = new StringBuilder();
        for (String pattern : patterns) {
            sb.append(pattern);
            sb.append(" ");
        }
        return sb.toString();
    }
}

