/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITMergeCustomizer;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationMerge
extends GITExtendedAbstractOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.merge";
    private Collection<File> _failures;

    public GITOperationMerge() {
        this(COMMAND_ID);
    }

    public GITOperationMerge(String commandId) {
        super(commandId);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        return this.getLocatableFromNavOrProfile(profile);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        try {
            Locatable[] locatables = this.getOperands(this.getProfile());
            URL root = GITUtil.getRootContaining(locatables[0].getURL());
            String branch = null;
            String tag = null;
            if (locatables[0] instanceof GITExtendedAbstractOperation.GITNode) {
                branch = ((GITExtendedAbstractOperation.GITNode)locatables[0])._branch;
                tag = ((GITExtendedAbstractOperation.GITNode)locatables[0])._tag;
            }
            Map defaultOpts = this.getBranchRevisionOptions(root, branch);
            defaultOpts.put("Git-use-tag", tag);
            GITMergeCustomizer customizer = new GITMergeCustomizer();
            customizer.setOptions(defaultOpts);
            return customizer;
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITOperationMerge.class.getName()).log(Level.WARNING, "Merge Operation failed ", e);
            return null;
        }
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        String revision = (String)options.get("Git-use-revision");
        Collection<URL> processed = this.merge(revision, (URL)options.get("Git-local-root"));
        this.postInvoke(profile, processed);
        return true;
    }

    private void postInvoke(VCSProfile profile, final Collection<URL> processed) throws Exception {
        URL[] urls = processed.toArray(new URL[processed.size()]);
        this.fireFileStructureChanged(urls);
        profile.getStatusCacheBridge().clear(urls);
        if (processed.size() > 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VCSBufferUtils.reloadBuffer((URL[])processed.toArray(new URL[0]));
                }
            });
        }
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }

    private Collection<URL> merge(String revision, URL root) throws GITProcessException {
        Collection<URL> urls;
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("merge");
        GitClient client = null;
        monitor.setLog(true);
        try {
            client = GITClientAdaptor.getClient(root);
            GitMergeResult result = client.merge(revision, (ProgressMonitor)monitor);
            urls = this.getProcceedFiles(client, result);
            GITUtil.logMergeConflicts(result);
            GITUtil.logMergeFailures(result);
            this._failures = result.getFailures();
        }
        catch (GitException e) {
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_MERGE_ERROR"), e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return urls;
    }

    private Collection<URL> getProcceedFiles(GitClient client, GitMergeResult result) throws GitException, GitException.MissingObjectException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
        HashSet<URL> urls = new HashSet<URL>();
        monitor.setLog(false);
        for (String commit : result.getMergedCommits()) {
            GitRevisionInfo info = client.log(commit, (ProgressMonitor)monitor);
            Map files = info.getModifiedFiles();
            for (File file : files.keySet()) {
                URL url = URLFactory.newFileURL((File)file);
                if (urls.contains(url)) continue;
                urls.add(URLFactory.newFileURL((File)file));
            }
        }
        return urls;
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        super.postInvoke(profile, commandState);
        GITUtil.reportMergeFailures(this._failures);
    }
}

