/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.git.GITIgnore;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITRemovePanel;

public class GITOperationRemoveIgnore
extends GITAbstractOperation {
    private static final String COMMAND_ID = "oracle.jdeveloper.git.rmignore";
    private URL _ignoreURL;

    public GITOperationRemoveIgnore() {
        super(COMMAND_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommand(VCSProfile profile, CommandState command) throws Exception {
        Locatable[] locatables = this.getOperands(profile);
        URL[] urls = VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
        this._ignoreURL = URLFactory.newURL((URL)GITUtil.getRootContaining(urls[0]), (String)".gitignore");
        if (!this.saveURL(this._ignoreURL)) {
            return false;
        }
        GITIgnore ignore = new GITIgnore();
        String pattern = "/" + URLFileSystem.toRelativeSpec((URL)urls[0], (URL)this._ignoreURL);
        Collection<String> patterns = ignore.getIgnorePatterns(this._ignoreURL);
        if (patterns.contains(pattern)) {
            ignore.removePattern(this._ignoreURL, pattern, patterns);
            this.setProcessedUrls(command, urls);
            return true;
        }
        boolean ans = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)Resource.format("INFO_PATTERN_IGNORE", URLFileSystem.getPlatformPathName((URL)this._ignoreURL)), (String)Resource.get("INFO_IGNORE_TITLE"), null);
        if (ans) {
            GITRemovePanel panel = new GITRemovePanel(URLFileSystem.getParent((URL)urls[0]));
            JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getInitialFocusComponent(), (String)this.getDialogTitle(), (int)7);
            try {
                if (dialog.runDialog()) {
                    Map<VCSHashURL, Collection<String>> updatePatterns = panel.getUpdatedPatterns();
                    for (VCSHashURL url : updatePatterns.keySet()) {
                        ignore.writePatterns(url.getURL(), updatePatterns.get(url));
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                dialog.dispose();
            }
        }
        return false;
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        Collection<URL> processed = this.getProcessedUrlsNotifier(commandState);
        if (!processed.isEmpty()) {
            URL[] urls = processed.toArray(new URL[processed.size()]);
            this.fireFileStructureChanged(urls);
            profile.getStatusCacheBridge().clear(urls);
        } else {
            profile.getPolicyStatusCache().clear();
        }
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
        VCSBufferUtils.reloadBuffer((URL)this._ignoreURL);
    }
}

