/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.jdeveloper.vcs.annotations.Annotations;
import oracle.jdeveloper.vcs.annotations.AnnotationsCommand;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBlameResult;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitLineDetails;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationViewAnnotation
extends AnnotationsCommand {
    private static final String COMMAND_ID = "oracle.jdeveloper.git.viewannotation";

    public GITOperationViewAnnotation() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    protected boolean isUnmodifiedStatus(VCSStatus status) {
        return status == VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git").getStatusInstance("UNCHANGED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Annotations getAnnotations(URL url) throws Exception {
        File file = new File(url.getPath());
        GitClient client = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("annotate");
            client = GITClientAdaptor.getClient(url);
            GitBlameResult result = client.blame(file, null, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.format("ANNOTATE_ERROR", file.getPath()), monitor.getError());
            }
            if (result == null) {
                Annotations annotations = null;
                return annotations;
            }
            AnnotationsImpl annotationsImpl = new AnnotationsImpl(result);
            return annotationsImpl;
        }
        catch (GitException.MissingObjectException moe) {
            moe.printStackTrace();
        }
        catch (GitException ge) {
            GITProfile.getQualifiedLogger(GITOperationViewAnnotation.class.getName()).log(Level.WARNING, "Annotations error " + ge.getMessage());
            throw new GITProcessException(Resource.format("ANNOTATE_ERROR", file.getPath()), ge.getCause().getMessage());
        }
        catch (GITProcessException gitpe) {
            gitpe.printStackTrace();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return null;
    }

    private static class AnnotationsImpl
    extends Annotations {
        private GitBlameResult _delegate;
        private Map<String, String> _revNo = new HashMap<String, String>();

        private AnnotationsImpl(GitBlameResult blame) {
            this._delegate = blame;
            this.calculateRevNo();
        }

        public Date getChanged(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                GitLineDetails details = this._delegate.getLineDetails(lineNumber);
                return new Date(details.getRevisionInfo().getCommitTime());
            }
            return null;
        }

        public String getRevision(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                GitLineDetails details = this._delegate.getLineDetails(lineNumber);
                String revision = details.getRevisionInfo().getRevision();
                return this._revNo.get(revision);
            }
            return null;
        }

        public String getExtendedRevision(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                GitLineDetails details = this._delegate.getLineDetails(lineNumber);
                return details.getRevisionInfo().getRevision();
            }
            return null;
        }

        public String getAuthor(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                GitLineDetails details = this._delegate.getLineDetails(lineNumber);
                return details.getRevisionInfo().getAuthor().getName();
            }
            return null;
        }

        public String getLine(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                GitLineDetails details = this._delegate.getLineDetails(lineNumber);
                return details.getContent();
            }
            return null;
        }

        public String getComment(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                return this._delegate.getLineDetails(lineNumber).getRevisionInfo().getFullMessage();
            }
            return null;
        }

        public int getLineCount() {
            return this._delegate.getLineCount();
        }

        private void calculateRevNo() {
            for (int l = 0; l < this._delegate.getLineCount(); ++l) {
                GitLineDetails details = this._delegate.getLineDetails(l);
                if (this._revNo.containsKey(details.getRevisionInfo().getRevision())) continue;
                this._revNo.put(details.getRevisionInfo().getRevision(), Integer.toString(l));
            }
        }
    }
}

