/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.imp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.util.VCSIgnoreFilters;
import oracle.jdeveloper.vcs.util.VCSImport;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSProcessUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.generic.util.NewFilesHandler;
import oracle.jdevimpl.vcs.generic.util.PatternURLFilter;
import oracle.jdevimpl.vcs.generic.util.VCSDirectoryWatcher;
import oracle.jdevimpl.vcs.generic.util.VCSGenericUtil;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITRepositoryManager;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.imp.FiltersPanel;
import oracle.jdevimpl.vcs.git.imp.SourcePanel;
import oracle.jdevimpl.vcs.git.imp.SummaryPanel;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepository;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITImportWizard {
    static final String SOURCE_URL = "source_url";
    static final String DEST_URL = "dest_url";
    static final String COMMENTS = "comments";
    static final String FILTERS = "filters";
    private static final Object FSM_STATE_SOURCE = new Object();
    private static final Object FSM_STATE_FILTERS = new Object();
    private static final Object FSM_STATE_SUMMARY = new Object();
    private final VCSProfile _profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
    private IndeterminateProgressMonitor _progress = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runWizard(Component parent, final Context context) {
        final Namespace ns = this.populate(context);
        FSMWizard wizard = new FSMWizard(this.createFSM(), ns);
        wizard.setWelcomePageAdded(true);
        wizard.setFinishPageAdded(true);
        wizard.setWizardTitle(Resource.get("IMPORT_WIZARD_TITLE"));
        wizard.setRoadmapVisible(true);
        wizard.setLogoImage(VCSImport.getWizardImage().getImage());
        wizard.setHeaderGradientBackground(new Color[]{new Color(-1), new Color(-3219482)});
        final WizardDialog wd = this.createWizardDialog(wizard, parent);
        try {
            wizard.addCommitListener(new CommitListener(){

                public void checkCommit(ApplyEvent event) {
                }

                public void commit(ApplyEvent event) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (!GITImportWizard.this.commitWizard(ns, context)) {
                                return;
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    wd.dispose();
                                }
                            });
                        }
                    }, "git-import-wizard-thread").start();
                }

                public void rollback(ApplyEvent event) {
                }

                public void cancel(ApplyEvent event) {
                }
            });
            if (WizardLauncher.runDialog((JDialog)wd)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            wd.setVisible(false);
            wd.dispose();
        }
        return false;
    }

    private Namespace populate(Context context) {
        Namespace ns = new Namespace();
        Collection filters = VCSIgnoreFilters.getAllIgnoreFilters();
        filters.add("**/deploy/**");
        ns.put(SOURCE_URL, (Object)VCSGenericUtil.getContextDirectoryURL((Context)context, (VCSProfile)this._profile));
        ns.put(FILTERS, (Object)filters);
        return ns;
    }

    private FSM createFSM() {
        FSMBuilder builder = new FSMBuilder();
        Step step = WelcomePanel.newStep((String)Resource.get("IMPORT_WIZARD_TITLE"), (String)Resource.get("IMPORT_WIZARD_HEADER"), (String)Resource.get("IMPORT_WIZARD_WELCOME_TEXT"), (String)(this.getClass().getName() + ".skipWelcome"), (String)"f1_gitimpwelcome_html");
        builder.newStartState(step, FSM_STATE_SOURCE);
        step = new Step(Resource.get("IMPORT_WIZARD_SOURCE_TITLE"), SourcePanel.class, "f1_gitimpdestination_html");
        builder.newState(FSM_STATE_SOURCE, step, FSM_STATE_FILTERS);
        step = new Step(Resource.get("IMPORT_WIZARD_FILTERS_TITLE"), FiltersPanel.class, "f1_gitimpfilters_html");
        builder.newState(FSM_STATE_FILTERS, step, FSM_STATE_SUMMARY);
        step = new Step(Resource.get("IMPORT_WIZARD_SUMMARY_TITLE"), SummaryPanel.class, "f1_gitimpsummary_html");
        builder.newFinalState(FSM_STATE_SUMMARY, step);
        try {
            return builder.getFSM();
        }
        catch (FSMInvalidException e) {
            GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).severe("Failed to build import wizard " + e.getMessage());
            return null;
        }
    }

    private WizardDialog createWizardDialog(FSMWizard wizard, Component parent) {
        Dialog dialog = SwingUtils.getAncestorDialog((Component)parent);
        if (dialog != null) {
            return wizard.getDialog(dialog);
        }
        return wizard.getDialog(SwingUtils.getAncestorFrame((Component)parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitWizard(Namespace ns, Context context) {
        URL[] children;
        URL srcURL = (URL)ns.get(SOURCE_URL);
        URL dstURL = (URL)ns.get(DEST_URL);
        if (!URLFileSystem.exists((URL)srcURL)) {
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("IMPORT_OP_ERROR_MSG_SOURCENOTEXIST", URLFileSystem.getPlatformPathName((URL)srcURL)), (String)Resource.get("IMPORT_OP_ERROR_TITLE_IMPORTING"), null);
            return false;
        }
        if (!srcURL.sameFile(dstURL) && (children = URLFileSystem.list((URL)dstURL)) != null && children.length > 0) {
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.format("IMPORT_OP_ERROR_MSG_DESTNOTEMPTY", URLFileSystem.getPlatformPathName((URL)srcURL)), (String)Resource.get("IMPORT_OP_ERROR_TITLE_IMPORTING"), null);
            return false;
        }
        this._progress = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), Resource.get("IMPORT_OP_PROGRESS_TITLE"));
        this._progress.setCancellable(true);
        this._progress.setCloseOnFinish(true);
        this._progress.setMillisToPopup(0);
        this._progress.start();
        VCSCancellable cancellable = new VCSCancellable(){

            public boolean isCancelled() {
                return GITImportWizard.this._progress.isCancelled();
            }
        };
        try {
            Collection<URL> filteredLst = null;
            Object timestamps = null;
            String comment = (String)ns.get(COMMENTS);
            Collection filters = (Collection)ns.get(FILTERS);
            VCSDirectoryWatcher watcher = null;
            if (!srcURL.sameFile(dstURL)) {
                this.setProgressMessage(Resource.get("IMPORT_OP_PROGRESS_COPYING"));
                watcher = new VCSDirectoryWatcher(dstURL);
                watcher.beginWatch();
                this.closeAndCopy(srcURL, dstURL, filters, cancellable);
            } else {
                this.setProgressMessage(Resource.get("IMPORT_OP_PROGRESS_FILTER"));
                filteredLst = this.getFilesToVersion(dstURL, filters, cancellable);
                Node[] nodes = this.getNodes(filteredLst);
                this.saveNodes(nodes);
            }
            if (this.needToInit(dstURL)) {
                this.setProgressMessage(Resource.get("IMPORT_OP_PROGRESS_INITIALIZE"));
                this.initializeRepositoy(dstURL, cancellable);
            }
            if (filteredLst == null) {
                this.setProgressMessage(Resource.get("IMPORT_OP_PROGRESS_FILTER"));
                filteredLst = this.getFilesToVersion(dstURL, filters, cancellable);
            }
            this.setProgressMessage(Resource.get("IMPORT_OP_PROGRESS_ADD"));
            this.addToRepository(filteredLst, cancellable);
            this.setProgressMessage(Resource.get("IMPORT_OP_PROGRESS_COMMIT"));
            this.commitToRepository(filteredLst, comment, cancellable);
            if (watcher != null) {
                watcher.endWatch();
                this.openNewFiles(watcher, context);
            }
            this.postInvoke(filteredLst);
            MessageDialog.optionalInformation((String)"git-version-app", (Component)Ide.getMainWindow(), (Object)Resource.get("IMPORT_OP_SUCCESS"), (String)Resource.get("IMPORT_OP_TITLE"), null);
            boolean bl = true;
            return bl;
        }
        catch (VCSCancelException vcsce) {
            boolean bl = false;
            return bl;
        }
        catch (GITProcessException ex) {
            ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)((Object)ex), (String)Resource.get("IMPORT_ERROR_TITLE"), (String)ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.progressFinish();
        }
    }

    private void openNewFiles(final VCSDirectoryWatcher watcher, final Context context) {
        final NewFilesHandler nfh = new NewFilesHandler(watcher, "oracle.jdeveloper.git");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Element elm = context.getElement();
                    String name = "";
                    if (elm instanceof Locatable) {
                        URL url = ((Locatable)elm).getURL();
                        name = URLFileSystem.getName((URL)url);
                    }
                    if (VCSProcessUtils.productHandleNewFiles()) {
                        nfh.handleNewFiles(context, name);
                    }
                }
                catch (Exception exception) {
                    GITImportWizard.this.progressFinish();
                    GITImportWizard.this._profile.getLogger().warning(exception.getMessage());
                    ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)exception, (String)Resource.get("IMPORT_OP_ERROR_TITLE_OPENNEW"), (String)Resource.format("IMPORT_OP_ERROR_MSG_OPENNEW", URLFileSystem.getPlatformPathName((URL)watcher.getWatchedDirectory())), (String)"");
                }
            }
        });
    }

    private void setProgressMessage(String message) {
        if (this._progress != null && this._progress.getPanel() != null) {
            this._progress.getPanel().setMessage(message);
        }
    }

    private void progressFinish() {
        if (this._progress != null) {
            this._progress.finish();
        }
    }

    private void closeAndCopy(URL srcURL, URL dstURL, Collection<String> filters, VCSCancellable cancel) throws VCSCancelException, GITProcessException {
        if (cancel.isCancelled()) {
            throw new VCSCancelException();
        }
        Collection<URL> urls = this.getFilesToVersion(srcURL, filters, cancel);
        Node[] nodes = this.getNodes(urls);
        this.saveNodes(nodes);
        this.copyURLsToDestFolder(urls, srcURL, dstURL);
    }

    private void copyURLsToDestFolder(Collection urls, URL srcFldURL, URL dstFldURL) throws VCSCancelException {
        Iterator srcIt = urls.iterator();
        String srcFldPath = URLFileSystem.getPath((URL)srcFldURL);
        while (srcIt.hasNext()) {
            URL srcURL = (URL)srcIt.next();
            String path = URLFileSystem.getPath((URL)srcURL).substring(srcFldPath.length());
            URL destURL = URLFactory.newURL((URL)dstFldURL, (String)path);
            try {
                URLFileSystem.copy((URL)srcURL, (URL)destURL);
                if (!this._progress.isCancelled()) continue;
                throw new VCSCancelException();
            }
            catch (IOException e) {
                GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.WARNING, "Failed to copy contents of " + srcFldURL + " to " + dstFldURL);
            }
        }
    }

    private void saveNodes(Node[] closeNodes) {
        for (Node node : closeNodes) {
            if (!node.isDirty()) continue;
            try {
                node.save();
            }
            catch (IOException e) {
                GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.WARNING, "Failed to save " + node.getURL());
            }
        }
    }

    private Node[] getNodes(Collection<URL> urls) throws GITProcessException {
        Node[] node = VCSModelUtils.findCachedNodes((URLFilter)new URLCompareFilter(urls));
        return node;
    }

    private boolean needToInit(URL url) {
        return !GITUtil.insideWorkingCopy(url);
    }

    private void initializeRepositoy(URL url, VCSCancellable cancel) throws GITProcessException, VCSCancelException {
        File file = new File(url.getPath());
        try {
            GitClient client = GitRepository.getInstance((File)file).createClient();
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("init");
            monitor.setLog(true);
            client.init((ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, monitor.getError());
                throw new GITProcessException(Resource.format("IMPORT_ERROR_INIT", URLFileSystem.getPlatformPathName((URL)url)), monitor.getError());
            }
            GITRepositoryManager.getInstance().clear();
        }
        catch (GitException ex) {
            GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, ex.getMessage());
            throw new GITProcessException(Resource.format("IMPORT_ERROR_INIT", URLFileSystem.getPlatformPathName((URL)url)), (Exception)((Object)ex));
        }
        if (cancel.isCancelled()) {
            throw new VCSCancelException();
        }
    }

    private Collection<URL> getFilesToVersion(URL url, Collection<String> filters, VCSCancellable cancel) throws VCSCancelException {
        PatternURLFilter filterPattern = new PatternURLFilter(filters);
        ArrayList<URL> files = new ArrayList<URL>();
        URLFilterVersion filter = new URLFilterVersion(filterPattern);
        this.findAllFiles(url, filter, files, cancel);
        return files;
    }

    private void findAllFiles(URL url, URLFilter filter, Collection<URL> files, VCSCancellable cancel) throws VCSCancelException {
        if (cancel.isCancelled()) {
            throw new VCSCancelException();
        }
        URL[] urls = URLFileSystem.list((URL)url, (URLFilter)filter);
        for (int u = 0; u < urls.length; ++u) {
            if (URLFileSystem.isDirectoryPath((URL)urls[u])) {
                this.findAllFiles(urls[u], filter, files, cancel);
                continue;
            }
            files.add(urls[u]);
        }
    }

    private void addToRepository(Collection<URL> files, VCSCancellable cancel) throws GITProcessException, VCSCancelException {
        if (cancel.isCancelled()) {
            throw new VCSCancelException();
        }
        URL[] urls = files.toArray(new URL[0]);
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Add");
        monitor.setLog(true);
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(urls[0]);
            Collection<File> gfiles = GITUtil.convertURLToFile(urls);
            client.add(gfiles.toArray(new File[0]), (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, monitor.getError());
                throw new GITProcessException(Resource.get("IMPORT_ERROR_ADD"), monitor.getError());
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, e.getMessage());
            throw new GITProcessException(Resource.get("IMPORT_ERROR_ADD"), (Exception)((Object)e));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    private void commitToRepository(Collection<URL> files, String comment, VCSCancellable cancel) throws VCSCancelException, GITProcessException {
        if (cancel.isCancelled()) {
            throw new VCSCancelException();
        }
        URL[] urls = files.toArray(new URL[0]);
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Commit");
        monitor.setLog(true);
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(urls[0]);
            Collection<File> gfiles = GITUtil.convertURLToFile(urls);
            client.commit(gfiles.toArray(new File[0]), comment, client.getUser(), client.getUser(), (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, monitor.getError());
                throw new GITProcessException(Resource.get("IMPORT_ERROR_COMMIT"), monitor.getError());
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITImportWizard.class.getName()).log(Level.SEVERE, e.getMessage());
            throw new GITProcessException(Resource.get("IMPORT_ERROR_COMMIT"), (Exception)((Object)e));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    private void postInvoke(Collection<URL> urls) {
        this._profile.getPolicyStatusCache().clear(urls.toArray(new URL[0]));
        VCSFileEventSender.fireFileStructureChanged((URL[])urls.toArray(new URL[0]));
        VCSControlCache.getInstance().fireControlStateChanged(this._profile.getID());
    }

    private static class URLCompareFilter
    implements URLFilter {
        private Collection urls;

        public URLCompareFilter(Collection urls) {
            this.urls = urls;
        }

        public boolean accept(URL url) {
            return this.urls.contains(url);
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            return o instanceof URLCompareFilter;
        }

        public String toString() {
            return "URLCompareFilter";
        }
    }

    private static class URLFilterVersion
    implements URLFilter {
        final PatternURLFilter _pattern;

        private URLFilterVersion(PatternURLFilter patternURLFilter) {
            this._pattern = patternURLFilter;
        }

        public boolean accept(URL url) {
            return this._pattern.accept(url);
        }
    }
}

