/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.ide.model.DefaultContainer;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.git.GITConnectionInfo;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.nav.GITBranchLocalNode;
import oracle.jdevimpl.vcs.git.nav.GITBranchRemoteNode;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITBranchListNode
extends DefaultContainer
implements GITRemote {
    private GITConnectionInfo _info;

    GITBranchListNode(GITConnectionInfo gitConnectionInfo) {
        this._info = gitConnectionInfo;
        this.setURL(GITNavURLFileSystemHelper.toNavigatorURL(gitConnectionInfo.getRootURL()));
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return Resource.get("NAV_NODE_BRANCHES");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
            this._children.add(new GITBranchLocalNode(this._info));
            this._children.add(new GITBranchRemoteNode(this._info));
        }
    }

    public Icon getIcon() {
        return ImageIconCache.get((URL)Resource.getBundle().getClass().getResource(Resource.get("BRANCH_ICON")));
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public boolean canRefresh() {
        return true;
    }

    public String getToolTipText() {
        return URLFileSystem.toDisplayString((URL)this._info.getRootURL());
    }
}

