/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.DefaultContainer;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.git.GITConnectionInfo;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.nav.GITRemoteFetchNode;
import oracle.jdevimpl.vcs.git.nav.GITRemotePushNode;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitRemoteConfig;

public class GITRemoteConfigNode
extends DefaultContainer
implements GITRemote {
    private GITConnectionInfo _info;
    private String _name;
    private GitRemoteConfig _remote;

    public GITRemoteConfigNode(GITConnectionInfo info, String remoteName, GitRemoteConfig remote) {
        this._info = info;
        this._name = remoteName;
        this._remote = remote;
        this.setURL(GITNavURLFileSystemHelper.toNavigatorURL(this._info.getRootURL()));
    }

    public String getRemoteName() {
        return this._name;
    }

    public String getShortLabel() {
        return this._name;
    }

    public Icon getIcon() {
        return ImageIconCache.get((URL)Resource.getBundle().getClass().getResource(Resource.get("REMOTE_LOCATION_ICON")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
            List push = this._remote.getPushUris();
            Iterator it = push.iterator();
            while (it.hasNext()) {
                this._children.add(new GITRemotePushNode((String)it.next(), this._info.getRootURL()));
            }
            List fetch = this._remote.getUris();
            Iterator it2 = fetch.iterator();
            while (it2.hasNext()) {
                this._children.add(new GITRemoteFetchNode((String)it2.next(), this._info.getRootURL()));
            }
        }
    }

    public String getToolTipText() {
        return URLFileSystem.toDisplayString((URL)this._info.getRootURL());
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public boolean canRefresh() {
        return true;
    }
}

