/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.vcs.git.GITBranchComparator;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;

public class GITBranchSelector {
    private static final String F1_HELP_ID = "f1_git_select_branch_html";
    private Map<String, GitBranch> _branches;
    private JEWTDialog _dialog;

    public GITBranchSelector(Map<String, GitBranch> branches) {
        this._branches = branches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String selectBranch() throws GitException, GITProcessException {
        GITBranchPanel panel = new GITBranchPanel(this._branches);
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getDefaultComp(), (String)Resource.get("CHECKOUT_BRANCH_TITLE"), (int)7);
        this._dialog.setOKButtonEnabled(false);
        this._dialog.setName("Branch Selector");
        try {
            if (this._dialog.runDialog()) {
                String string = panel.getSelectedBranch();
                return string;
            }
        }
        finally {
            this._dialog.dispose();
        }
        return null;
    }

    private void selectionMade(BranchNode bNode) {
        if (bNode == null) {
            return;
        }
        if (bNode.isIsGitBranch()) {
            this._dialog.setOKButtonEnabled(true);
        } else {
            this._dialog.setOKButtonEnabled(false);
        }
    }

    private static class BranchNode {
        private String _name;
        private boolean _isGitBranch;

        BranchNode(String name, boolean branch) {
            this._name = name;
            this._isGitBranch = branch;
        }

        public boolean isIsGitBranch() {
            return this._isGitBranch;
        }

        public String toString() {
            return this._name;
        }
    }

    private class GITBranchPanel
    extends JPanel {
        private JTree _tree;

        GITBranchPanel(Map<String, GitBranch> branches) {
            DefaultMutableTreeNode top = new DefaultMutableTreeNode(new BranchNode(Resource.get("BRANCH_TOP_NODE"), false));
            this.createNodes(top, branches);
            this._tree = new JTree(top);
            this._tree.getSelectionModel().setSelectionMode(1);
            DefaultTreeCellRenderer render = new DefaultTreeCellRenderer();
            render.setLeafIcon(OracleIcons.getIcon((String)"branch.png"));
            this._tree.setCellRenderer(render);
            this.initLayout();
            this._tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                    BranchNode bNode = (BranchNode)tNode.getUserObject();
                    GITBranchSelector.this.selectionMade(bNode);
                }
            });
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, GITBranchSelector.F1_HELP_ID);
        }

        private Component getDefaultComp() {
            return this._tree;
        }

        private void createNodes(DefaultMutableTreeNode top, Map<String, GitBranch> branches) {
            DefaultMutableTreeNode local = new DefaultMutableTreeNode(new BranchNode(Resource.get("BRANCH_LOCAL_NODE"), false));
            DefaultMutableTreeNode remote = new DefaultMutableTreeNode(new BranchNode(Resource.get("BRANCH_REMOTE_NODE"), false));
            top.add(local);
            top.add(remote);
            ArrayList<GitBranch> sortBranchs = new ArrayList<GitBranch>(branches.values());
            Collections.sort(sortBranchs, new GITBranchComparator());
            for (GitBranch branch : sortBranchs) {
                if (branch.isRemote()) {
                    remote.add(new DefaultMutableTreeNode(new BranchNode(branch.getName(), true), false));
                    continue;
                }
                local.add(new DefaultMutableTreeNode(new BranchNode(branch.getName(), true), false));
            }
        }

        private String getSelectedBranch() {
            DefaultMutableTreeNode path = (DefaultMutableTreeNode)this._tree.getSelectionPath().getLastPathComponent();
            return path.getUserObject().toString();
        }

        private void initLayout() {
            Insets ins = new Insets(5, 5, 5, 5);
            this.setLayout(new GridBagLayout());
            this.add((Component)new JScrollPane(this._tree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        }
    }
}

