/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.net.URL;
import java.util.Map;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;

class GITBranchTagValidator {
    public VCSException validateBranchAndTag(String branch, String tag, URL root, String title, Map<String, GitBranch> branches) {
        if (branch != null && branch.isEmpty()) {
            return new VCSException(title, Resource.get("ERROR_NO_BRANCH"));
        }
        if (tag != null && tag.isEmpty()) {
            return new VCSException(title, Resource.get("ERROR_NO_TAG"));
        }
        if (branch != null && !branches.containsKey(branch)) {
            return new VCSException(title, Resource.format("ERROR_BRANCH_NOT_EXIST", branch));
        }
        if (tag != null && !GITUtil.getTags(root).containsKey(tag)) {
            return new VCSException(title, Resource.format("ERROR_TAG_NOT_EXIST", tag));
        }
        return null;
    }
}

