/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITBranchRevisionPanel;
import oracle.jdevimpl.vcs.git.ui.GITBranchTagValidator;
import org.netbeans.libs.git.GitBranch;

public class GITExportCommitted
implements VCSOptionsCustomizer {
    public static final String EXPORT_FILE = "ExportFile";
    public static final String BRANCH = "Branch";
    public static final String TAG = "Tag";
    public static final String COMMIT_ID = "CommitId";
    public static final String ROOT_URL = "RootURL";
    private final GITBranchTagValidator _validator = new GITBranchTagValidator();
    private Map<String, GitBranch> _branches;
    private GITExportCommittedPanel _panel;

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new GITExportCommittedPanel();
        }
        return this._panel;
    }

    public void setOptions(Map<?, ?> options) {
        GITExportCommittedPanel panel = (GITExportCommittedPanel)this.getComponent();
        panel.setExportFile((URL)options.get(EXPORT_FILE));
        panel.setRootURL((URL)options.get(ROOT_URL));
        panel.setBranch((String)options.get(BRANCH));
    }

    public Map<?, ?> getOptions() {
        GITExportCommittedPanel panel = (GITExportCommittedPanel)this.getComponent();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EXPORT_FILE, panel.getExportFile());
        map.put(BRANCH, panel.getBranch());
        map.put(TAG, panel.getTag());
        map.put(COMMIT_ID, panel.getCommitId());
        map.put(ROOT_URL, panel.getRootUrl());
        return map;
    }

    public void validateOptions() throws VCSException {
        Map<?, ?> opts = this.getOptions();
        URL url = (URL)opts.get(EXPORT_FILE);
        String branch = (String)opts.get(BRANCH);
        String tag = (String)opts.get(TAG);
        URL root = (URL)opts.get(ROOT_URL);
        if (url == null) {
            throw new VCSException(Resource.get("EXPORT_FILE_EXIST_TITLE"), Resource.get("ERROR_EXPORT_FILE"));
        }
        if (URLFileSystem.exists((URL)url)) {
            throw new VCSException(Resource.get("EXPORT_FILE_EXIST_TITLE"), Resource.format("EXPORT_FILE_EXIST", URLFileSystem.getPlatformPathName((URL)url)));
        }
        VCSException exception = this._validator.validateBranchAndTag(branch, tag, root, Resource.get("EXPORT_FILE_EXIST_TITLE"), this.getBranches(root));
        if (exception != null) {
            throw exception;
        }
    }

    public Component getInitialFocusComponent() {
        return ((GITExportCommittedPanel)this.getComponent()).getInitialFocusComponent();
    }

    private Map<String, GitBranch> getBranches(URL root) {
        if (this._branches == null) {
            this._branches = GITUtil.getBranches(root);
        }
        return this._branches;
    }

    private static class GITExportCommittedPanel
    extends JPanel {
        private JLabel _lblFile = new JLabel();
        private FileField _fldDest = new FileField();
        private JButton _browse = new JButton();
        private GITBranchRevisionPanel _brrevPanel = new GITBranchRevisionPanel();

        GITExportCommittedPanel() {
            this.initComponents();
            this.layoutComponenents();
            this.listeners();
        }

        Component getInitialFocusComponent() {
            return this._fldDest;
        }

        private void initComponents() {
            ResourceUtils.resLabel((JLabel)this._lblFile, (Component)this._fldDest, (String)Resource.get("EXPORT_COMM_FILE"));
            ResourceUtils.resButton((AbstractButton)this._browse, (String)Resource.get("EXPORT_COMM_BROWSE"));
        }

        private void layoutComponenents() {
            Insets is = new Insets(5, 5, 5, 5);
            Insets isn = new Insets(5, 0, 5, 0);
            this.setLayout(new GridBagLayout());
            this.add((Component)this._lblFile, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, is, 0, 0));
            this.add((Component)this._fldDest, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, is, 0, 0));
            this.add((Component)this._browse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, is, 0, 0));
            this.add((Component)this._brrevPanel, new GridBagConstraints(0, 1, 3, 4, 1.0, 0.0, 17, 1, isn, 0, 0));
        }

        private void listeners() {
            this._browse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URL current = URLFactory.newDirURL((String)GITExportCommittedPanel.this._fldDest.getText());
                    URLChooser chooser = DialogUtil.newURLChooser((URL)current);
                    chooser.setSelectionMode(0);
                    if (chooser.showOpenDialog((Component)GITExportCommittedPanel.this) == 0) {
                        GITExportCommittedPanel.this._fldDest.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
                    }
                }
            });
        }

        private void setExportFile(URL url) {
            this._fldDest.setText(URLFileSystem.getPlatformPathName((URL)url));
        }

        private URL getExportFile() {
            return URLFactory.newURL((String)this._fldDest.getText());
        }

        private void setBranch(String branch) {
            this._brrevPanel.setSelectedBranch(branch);
        }

        private String getBranch() {
            return this._brrevPanel.getSelectedBranch();
        }

        private String getTag() {
            return this._brrevPanel.getSelectedTag();
        }

        private String getCommitId() {
            return this._brrevPanel.getSelectedRevision();
        }

        private void setRootURL(URL url) {
            this._brrevPanel.setRepositoryRoot(url);
        }

        private URL getRootUrl() {
            return this._brrevPanel.getRepositoryRoot();
        }
    }
}

