/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITExportUncommitted
implements VCSOptionsCustomizer {
    public static final String EXPORT_FILE = "export.file";
    private GITExportPanel _panel;

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new GITExportPanel();
        }
        return this._panel;
    }

    public void setOptions(Map<?, ?> options) {
        String path = (String)options.get(EXPORT_FILE);
        ((GITExportPanel)this.getComponent()).setExportFile(path);
    }

    public Map<?, ?> getOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(EXPORT_FILE, ((GITExportPanel)this.getComponent()).getExportFile());
        return options;
    }

    public void validateOptions() throws VCSException {
        URL url = URLFactory.newURL((String)((GITExportPanel)this.getComponent()).getExportFile());
        if (url == null) {
            throw new VCSException(Resource.get("EXPORT_FILE_EXIST_TITLE"), Resource.get("ERROR_EXPORT_FILE"));
        }
        if (URLFileSystem.exists((URL)url)) {
            throw new VCSException(Resource.get("EXPORT_FILE_EXIST_TITLE"), Resource.format("EXPORT_FILE_EXIST", URLFileSystem.getPlatformPathName((URL)url)));
        }
    }

    public Component getInitialFocusComponent() {
        return ((GITExportPanel)this.getComponent()).getInitialFocusComponent();
    }

    private static class GITExportPanel
    extends JPanel {
        private JLabel _lblFile = new JLabel();
        private FileField _fldDest = new FileField();
        private JButton _browse = new JButton();

        GITExportPanel() {
            this.initComponents();
            this.layoutComponenents();
            this.listeners();
        }

        Component getInitialFocusComponent() {
            return this._fldDest;
        }

        private void initComponents() {
            ResourceUtils.resLabel((JLabel)this._lblFile, (Component)this._fldDest, (String)Resource.get("EXPORT_UNCOMM_FILE"));
            ResourceUtils.resButton((AbstractButton)this._browse, (String)Resource.get("EXPORT_UNCOMM_BROWSE"));
        }

        private void layoutComponenents() {
            Insets is = new Insets(5, 5, 5, 5);
            this.setLayout(new GridBagLayout());
            this.add((Component)this._lblFile, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, is, 0, 0));
            this.add((Component)this._fldDest, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, is, 0, 0));
            this.add((Component)this._browse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, is, 0, 0));
        }

        private void listeners() {
            this._browse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URL current = URLFactory.newDirURL((String)GITExportPanel.this._fldDest.getText());
                    URLChooser chooser = DialogUtil.newURLChooser((URL)current);
                    chooser.setSelectionMode(0);
                    if (chooser.showOpenDialog((Component)GITExportPanel.this) == 0) {
                        GITExportPanel.this._fldDest.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
                    }
                }
            });
        }

        private void setExportFile(String path) {
            this._fldDest.setText(path);
        }

        private String getExportFile() {
            return this._fldDest.getText();
        }
    }
}

