/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITBranchRevisionPanel;
import oracle.jdevimpl.vcs.git.ui.GITBranchTagValidator;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRevisionInfo;

public class GITMergeCustomizer
extends VCSOptionsCustomizerAdapter {
    private Map<String, GitBranch> _branches;
    private GITBranchRevisionPanel _panel;
    private final GITBranchTagValidator _validator = new GITBranchTagValidator();

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new GITBranchRevisionPanel();
        }
        return this._panel;
    }

    public Map getOptions() {
        GITBranchRevisionPanel ui = (GITBranchRevisionPanel)this.getComponent();
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("Git-use-branch", ui.getSelectedBranch());
        opts.put("Git-use-tag", ui.getSelectedTag());
        opts.put("Git-use-revision", ui.getSelectedRevision());
        opts.put("Git-use-revision-enable", ui.isUseRevision());
        opts.put("Git-local-root", ui.getRepositoryRoot());
        return opts;
    }

    public void setOptions(Map map) {
        String tag;
        URL root;
        Boolean enable;
        GitRevisionInfo revision;
        GITBranchRevisionPanel ui = (GITBranchRevisionPanel)this.getComponent();
        String branch = (String)map.get("Git-use-branch");
        if (branch == null) {
            branch = (String)map.get("Git-default-branch");
        }
        if (branch != null) {
            ui.setSelectedBranch(branch);
        }
        if ((revision = (GitRevisionInfo)map.get("Git-use-revision")) != null) {
            ui.setSelectedRevision(revision.getRevision());
        }
        if ((enable = (Boolean)map.get("Git-use-revision-enable")) != null) {
            ui.setUseRevision(enable);
        }
        if ((root = (URL)map.get("Git-local-root")) != null) {
            ui.setRepositoryRoot(root);
        }
        if ((tag = (String)map.get("Git-use-tag")) != null) {
            ui.setSelectedTag(tag);
        }
    }

    public void validateOptions() throws VCSException {
        URL root;
        String tag;
        Map opts = this.getOptions();
        String branch = (String)opts.get("Git-use-branch");
        VCSException exception = this._validator.validateBranchAndTag(branch, tag = (String)opts.get("Git-use-tag"), root = (URL)opts.get("Git-local-root"), Resource.get("MERGE_FAILED_TITLE"), this.getBranches(root));
        if (exception != null) {
            throw exception;
        }
    }

    private Map<String, GitBranch> getBranches(URL root) {
        if (this._branches == null) {
            this._branches = GITUtil.getBranches(root);
        }
        return this._branches;
    }
}

