/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.vcs.git.GITBranchComparator;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitTag;

public class GITTagSelector {
    private static final String F1_HELP_ID = "f1_git_select_tag_html";
    private Map<String, GitTag> _tags;
    private JEWTDialog _dialog;

    GITTagSelector(Map<String, GitTag> tags) {
        this._tags = tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String selectTag() throws GitException, GITProcessException {
        GITTagPanel panel = new GITTagPanel(this._tags);
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getDefaultComp(), (String)Resource.get("CHECKOUT_TAG_TITLE"), (int)7);
        this._dialog.setOKButtonEnabled(false);
        this._dialog.setName("Tag Selector");
        try {
            if (this._dialog.runDialog()) {
                String string = panel.getSelectedTag();
                return string;
            }
        }
        finally {
            this._dialog.dispose();
        }
        return null;
    }

    private void selectionMade(TagNode tNode) {
        if (tNode == null) {
            return;
        }
        if (tNode.isGitTag()) {
            this._dialog.setOKButtonEnabled(true);
        } else {
            this._dialog.setOKButtonEnabled(false);
        }
    }

    private static class TagNode {
        private String _name;
        private boolean _isGitTag;

        TagNode(String name, boolean tag) {
            this._name = name;
            this._isGitTag = tag;
        }

        public boolean isGitTag() {
            return this._isGitTag;
        }

        public String toString() {
            return this._name;
        }
    }

    private class GITTagPanel
    extends JPanel {
        private JTree _tree;

        GITTagPanel(Map<String, GitTag> tags) {
            DefaultMutableTreeNode top = new DefaultMutableTreeNode(new TagNode(Resource.get("TAG_TOP_NODE"), false));
            this.createNodes(top, tags);
            this._tree = new JTree(top);
            this._tree.getSelectionModel().setSelectionMode(1);
            DefaultTreeCellRenderer render = new DefaultTreeCellRenderer();
            render.setLeafIcon(OracleIcons.getIcon((String)"switch-action.png"));
            this._tree.setCellRenderer(render);
            this._tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                    TagNode tagNode = (TagNode)tNode.getUserObject();
                    GITTagSelector.this.selectionMade(tagNode);
                }
            });
            this.initLayout();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, GITTagSelector.F1_HELP_ID);
        }

        private Component getDefaultComp() {
            return this._tree;
        }

        private void createNodes(DefaultMutableTreeNode top, Map<String, GitTag> tags) {
            ArrayList<GitTag> sortTags = new ArrayList<GitTag>(tags.values());
            Collections.sort(sortTags, new GITBranchComparator());
            for (GitTag tag : sortTags) {
                top.add(new DefaultMutableTreeNode(new TagNode(tag.getTagName(), true), false));
            }
        }

        private String getSelectedTag() {
            DefaultMutableTreeNode path = (DefaultMutableTreeNode)this._tree.getSelectionPath().getLastPathComponent();
            return path.getUserObject().toString();
        }

        private void initLayout() {
            Insets ins = new Insets(5, 5, 5, 5);
            this.setLayout(new GridBagLayout());
            this.add((Component)new JScrollPane(this._tree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        }
    }
}

