/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilenameFilter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITCloneDestinationPanel
extends DefaultTraversablePanel {
    private static final String F1_HELP_ID = "f1_git_clone_wizard_4_html";
    private JMultiLineLabel _hintText = new JMultiLineLabel();
    private JLabel _lblDest = new JLabel();
    private FileField _fldDest = new FileField();
    private JButton _ctnBrowse = new JButton();
    private JLabel _lblClone = new JLabel();
    private JTextField _fldClone = new JTextField();
    private JLabel _lblChBranch = new JLabel();
    private JComboBox _chChBranch = new JComboBox(new BranchComboBoxModel());
    private URLFilenameFilter _filter = new GITFilenameFilter();

    public GITCloneDestinationPanel() {
        this.initRes();
        this.init();
        this.addListeners();
        this.setHelpID(F1_HELP_ID);
    }

    private void init() {
        this._fldDest.setOnlyDirectories(true);
        this._fldDest.setText(Ide.getWorkDirectory());
        Insets ins = new Insets(5, 5, 5, 5);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(this._lblDest, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this._fldDest, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(this._ctnBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add(this._lblClone, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add(this._fldClone, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(this._lblChBranch, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add(this._chChBranch, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
    }

    private void initRes() {
        this._hintText.setText(Resource.get("WZ_CLONE_DEST_HINT"));
        ResourceUtils.resLabel((JLabel)this._lblDest, (Component)this._fldDest, (String)Resource.get("WZ_CLONE_DESTINATION"));
        ResourceUtils.resButton((AbstractButton)this._ctnBrowse, (String)Resource.get("WZ_CLONE_BROWSE"));
        ResourceUtils.resLabel((JLabel)this._lblClone, (Component)this._fldClone, (String)Resource.get("WZ_CLONE_CLONE_NAME"));
        ResourceUtils.resLabel((JLabel)this._lblChBranch, (Component)this._chChBranch, (String)Resource.get("WZ_CLONE_CHECK_BRANCH"));
    }

    public void onEntry(TraversableContext dataContext) {
        if (dataContext.getDirection() == 1) {
            if (this._fldClone.getText().isEmpty()) {
                URL durl = URLFactory.newDirURL((String)this._fldDest.getText());
                this._fldClone.setText(this.defaultCloneName(durl, dataContext));
            }
            Collection branches = (Collection)dataContext.get("git.use-branches");
            ((BranchComboBoxModel)this._chChBranch.getModel()).addData(branches);
            this.setBranchSelection();
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            String destDir = this._fldDest.getText();
            if (destDir == null || destDir.isEmpty()) {
                throw new TraversalException(Resource.get("WZ_CLONE_DEST_EMPTY"));
            }
            dataContext.put("git.clone-destination-dir", (Object)destDir);
            String clName = this._fldClone.getText();
            if (clName == null || clName.isEmpty()) {
                throw new TraversalException(Resource.get("WZ_CLONE_NAME_EMPTY"));
            }
            dataContext.put("git.clone-clone-name", (Object)clName);
            StringBuilder sb = new StringBuilder(destDir);
            if (destDir.lastIndexOf(File.separatorChar) != destDir.length() - 1) {
                sb.append(File.separatorChar);
            }
            sb.append(clName);
            URL url = URLFactory.newDirURL((String)sb.toString());
            if (URLFileSystem.exists((URL)url)) {
                throw new TraversalException(Resource.format("WZ_CLONE_DEST_EXIST", sb.toString()));
            }
            URL parent = this.noGitReposInParent(url);
            if (parent != null) {
                throw new TraversalException(Resource.format("WZ_CLONE_DEST_PARENT_GIT", sb.toString(), URLFileSystem.getPlatformPathName((URL)parent)));
            }
            String chBranch = (String)this._chChBranch.getSelectedItem();
            dataContext.put("git.clone-checkout-branch", (Object)chBranch);
        }
    }

    private String defaultCloneName(URL durl, TraversableContext dataContext) {
        String remoteUrl = (String)dataContext.get("git.remote-uri");
        String[] bits = remoteUrl.split("/");
        String[] parts = bits[bits.length - 1].split("\\.");
        String name = parts[0];
        URL url = URLFactory.newURL((URL)durl, (String)name);
        int count = 1;
        while (URLFileSystem.exists((URL)url)) {
            name = parts[0] + count++;
            url = URLFactory.newURL((URL)durl, (String)name);
        }
        return name;
    }

    private void addListeners() {
        this._ctnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLChooser urlChooser = DialogUtil.newURLChooser();
                urlChooser.setSelectionScope(1);
                urlChooser.setSelectedURL(URLFactory.newDirURL((String)GITCloneDestinationPanel.this._fldDest.getText()));
                int ret = urlChooser.showOpenDialog((Component)((Object)GITCloneDestinationPanel.this), Resource.get("INIT_BROWSE_TITLE"));
                if (ret == 0) {
                    URL url = urlChooser.getSelectedURL();
                    GITCloneDestinationPanel.this._fldDest.setText(URLFileSystem.getPlatformPathName((URL)url));
                }
            }
        });
    }

    private void setBranchSelection() {
        BranchComboBoxModel model = (BranchComboBoxModel)this._chChBranch.getModel();
        for (int b = 0; b < model.getSize(); ++b) {
            if (!model.getElementAt(b).equals("master")) continue;
            this._chChBranch.setSelectedIndex(b);
            return;
        }
        this._chChBranch.setSelectedIndex(0);
    }

    private URL noGitReposInParent(URL url) {
        URL parent = URLFileSystem.getParent((URL)url);
        if (parent == null) {
            return null;
        }
        if (URLFileSystem.exists((URL)parent) && URLFileSystem.list((URL)parent, (URLFilenameFilter)this._filter).length > 0) {
            return parent;
        }
        return this.noGitReposInParent(parent);
    }

    private static class GITFilenameFilter
    implements URLFilenameFilter {
        private static String GITREPOS = ".git";

        private GITFilenameFilter() {
        }

        public boolean accept(URL url, String name) {
            return name.equals(GITREPOS);
        }
    }

    private static class BranchComboBoxModel
    extends DefaultComboBoxModel {
        private String[] _data = new String[0];

        private BranchComboBoxModel() {
        }

        public void addData(Collection<String> branches) {
            ArrayList<String> sortBranch = new ArrayList<String>();
            sortBranch.addAll(branches);
            Collections.sort(sortBranch);
            this._data = sortBranch.toArray(new String[0]);
        }

        @Override
        public int getSize() {
            return this._data.length;
        }

        @Override
        public Object getElementAt(int index) {
            if (index < this._data.length) {
                return this._data[index];
            }
            return null;
        }
    }
}

