/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ide.webbrowser.ProxySettingsPanel;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITTraversalException;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITAuthenicationPanel;
import oracle.jdevimpl.vcs.git.wiz.GITRepositoryPanel;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.progress.ProgressMonitor;

abstract class GITCommonPanel
extends DefaultTraversablePanel {
    private final String SSH = "ssh://";
    protected GITAuthenicationPanel _authPanel = new GITAuthenicationPanel();

    protected boolean addNonDuplicateItem(JComboBox combo, String item) {
        for (int c = 0; c < combo.getItemCount(); ++c) {
            if (!combo.getItemAt(c).equals(item)) continue;
            return false;
        }
        combo.addItem(item);
        return true;
    }

    protected String getDefaultGITRepo(Map<String, GitRemoteConfig> remote) {
        if (remote != null) {
            for (String key : remote.keySet()) {
                List uris = remote.get(key).getUris();
                if (uris == null || uris.size() <= 0) continue;
                return (String)uris.get(0);
            }
        }
        return null;
    }

    protected void RepositoryOnExit(TraversableContext dataContext, GitClient client, String remoteName, String remoteUrl, String fldUser, char[] pass, String keyFile, char[] passPhrase) throws TraversalException {
        if (remoteName == null || remoteName.trim().isEmpty()) {
            throw new TraversalException(Resource.get("WZ_REMOTE_EMPTY"), Resource.get("WZ_REPOS_NAME"));
        }
        if (remoteUrl == null || remoteUrl.trim().isEmpty()) {
            throw new TraversalException(Resource.get("WZ_REPOS_EMPTY"), Resource.get("WZ_REPOS_VALID"));
        }
        boolean restore = false;
        try {
            remoteUrl = remoteUrl.trim();
            restore = GITUtil.authenticator(remoteUrl);
            GITClientAdaptor.setAuthentication(client, fldUser, pass, keyFile, passPhrase);
            final IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)IdeUtil.getMainWindow(), Resource.get("WZ_REMOTE_BRANCH_PROGRESS"));
            progress.getPanel().setMessage(Resource.format("WZ_REMOTE_BRANCH_FROM", remoteUrl));
            final RemoteBranchThread rbThread = new RemoteBranchThread(client, remoteUrl, progress);
            rbThread.start();
            progress.addCancellationListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    rbThread.interrupt();
                    progress.close();
                }
            });
            progress.start();
            if (rbThread.getError() != null) {
                throw rbThread.getError();
            }
            if (progress.isCanceled()) {
                throw new TraversalException(Resource.get("WZ_OPERATION_CANCELED"), Resource.get("WZ_REMOTE_BRANCH_PROGRESS"));
            }
            this.validateBranches(remoteUrl, rbThread.getBranches());
            dataContext.put("git.remote-branches", rbThread.getBranches());
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("getBranches");
            Map localbranches = client.getBranches(false, (ProgressMonitor)monitor);
            GitBranch active = GITUtil.getActiveBranch(localbranches);
            if (active != null) {
                HashMap<String, String> useBranches = new HashMap<String, String>();
                useBranches.put(active.getName(), GITUtil.getRemoteBranchName(remoteName, active.getName()));
                dataContext.put("git.use-branches", useBranches);
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITRepositoryPanel.class.getName()).log(Level.WARNING, e.getMessage());
            if (remoteUrl.startsWith("http")) {
                throw new GITTraversalException(Resource.format("WZ_REPOS_NO_CONNECT_PROXY", remoteUrl), Resource.get("WZ_REPOS_ERR_TITLE"), (Exception)((Object)e));
            }
            throw new GITTraversalException(Resource.format("WZ_REPOS_NO_CONNECT", remoteUrl), Resource.get("WZ_REPOS_ERR_TITLE"), (Exception)((Object)e));
        }
        finally {
            GITClientAdaptor.clearAuthentication(client);
            GITUtil.authenricatorRestore(restore);
        }
        dataContext.put("git.remote-name", (Object)this.getTrueRemoteName(remoteName));
        dataContext.put("git.remote-uri", (Object)remoteUrl);
        dataContext.put("git.username", (Object)fldUser);
        dataContext.put("git.password", (Object)pass);
        dataContext.put("git.keyfile", (Object)keyFile);
        dataContext.put("git.passphrase", (Object)passPhrase);
    }

    protected void setDefaultAuthentication(String defRepo, JComboBox cmnRepository) {
        if (defRepo != null) {
            cmnRepository.setSelectedItem(defRepo);
            if (defRepo.startsWith("ssh://")) {
                this._authPanel.setAuthenticateFields(false);
            } else {
                this._authPanel.setAuthenticateFields(true);
            }
        } else {
            this._authPanel.setAuthenticateFields(true);
        }
    }

    protected void validateBranches(String remoteUrl, Map<String, GitBranch> gitBranch) throws TraversalException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean proxyPrompt() {
        ProxyOptions options = ProxyOptions.getProxyOptions();
        ProxySettingsPanel psp = new ProxySettingsPanel();
        psp.setProxyOptions(options);
        JEWTDialog jd = JEWTDialog.createDialog((Component)((Object)this), (String)Resource.get("PROXY_PROMPT_TITLE"), (int)7);
        jd.setContent((Component)psp);
        try {
            if (jd.runDialog()) {
                ProxyOptions.setProxyOptions((ProxyOptions)psp.getProxyOptions());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            jd.dispose();
        }
    }

    private String getTrueRemoteName(String remoteName) {
        if (remoteName.contains(" - ") && remoteName.contains("://")) {
            return remoteName.substring(0, remoteName.indexOf(" - ")).trim();
        }
        return remoteName.trim();
    }

    protected final class RemoteBranchThread
    extends Thread {
        private GitClient _client;
        private String _remoteUrl;
        Map<String, GitBranch> _branches;
        private GitException _exception;
        private boolean _cancel;
        private IndeterminateProgressMonitor _progress;

        RemoteBranchThread(GitClient client, String remoteUrl, IndeterminateProgressMonitor progress) {
            super("git-remote-branches");
            this._branches = new HashMap<String, GitBranch>();
            this._client = client;
            this._remoteUrl = remoteUrl;
            this._progress = progress;
        }

        public boolean isCancel() {
            return this._cancel;
        }

        public GitException getError() {
            return this._exception;
        }

        public Map<String, GitBranch> getBranches() {
            return this._branches;
        }

        @Override
        public void run() {
            try {
                this._cancel = this.getRemoteBranches();
            }
            catch (GitException.AuthorizationException e) {
                this._exception = e;
            }
            catch (GitException e) {
                this._exception = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean getRemoteBranches() throws GitException, GitException.AuthorizationException {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("listRemoteBranches");
            VCSCancellable cancellable = new VCSCancellable(){

                public boolean isCancelled() {
                    return RemoteBranchThread.this._progress.isCanceled();
                }
            };
            monitor.setCancellable(cancellable);
            try {
                this._branches.putAll(this._client.listRemoteBranches(this._remoteUrl, (ProgressMonitor)monitor));
            }
            finally {
                this._progress.finish();
            }
            return !cancellable.isCancelled();
        }
    }
}

