/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITRefSpec;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITPullBranchPanel;
import oracle.jdevimpl.vcs.git.wiz.GITPullRepositoryPanel;
import oracle.jdevimpl.vcs.git.wiz.GITPullSummaryPanel;
import oracle.jdevimpl.vcs.git.wiz.GITRemoteWizard;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitPullResult;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITPullWizard
extends GITRemoteWizard {
    private static final String F1_HELP_ID = "f1_git_pull_wizard_1_html";
    static final String MERGE_BRANCH = "git.mergebranch";
    static final String LOCAL_BRANCH = "git.localbranch";
    private Namespace ns;
    private WizardDialog wd;

    public boolean runWizard(Component parent, Context context) throws Exception {
        FSMBuilder fsmBuilder = new FSMBuilder();
        Step welcomeStep = WelcomePanel.newStep((String)Resource.get("WZ_PULL_NAME"), (String)Resource.get("WZ_PULL_HEADER"), (String)Resource.get("WZ_PULL_TEXT"), (String)"GitPullSkipNextTime", (String)F1_HELP_ID);
        fsmBuilder.newStartState(welcomeStep, (Object)"git.repository");
        Step step = new Step(Resource.get("WZ_PULL_REPOSITORY"), GITPullRepositoryPanel.class);
        fsmBuilder.newState((Object)"git.repository", step, (Object)"git.branch");
        step = new Step(Resource.get("WZ_PULL_BRANCH"), GITPullBranchPanel.class);
        fsmBuilder.newState((Object)"git.branch", step, (Object)"git.summary");
        step = new Step(Resource.get("WZ_PULL_SUMMARY"), GITPullSummaryPanel.class);
        fsmBuilder.newFinalState((Object)"git.summary", step);
        try {
            FSM stateMachine = fsmBuilder.getFSM();
            this.ns = this.populate(context);
            if (this.ns == null) {
                return false;
            }
            FSMWizard wiz = new FSMWizard(stateMachine, this.ns);
            wiz.setWelcomePageAdded(true);
            wiz.setFinishPageAdded(true);
            wiz.setWizardTitle(Resource.get("WZ_PULL_TITLE"));
            wiz.setRoadmapVisible(true);
            wiz.setHeaderGradientBackground(new Color[]{new Color(-1), new Color(-3219482)});
            this.wd = this.createWizardDialog(wiz, parent, context);
            if (WizardLauncher.runDialog((JDialog)this.wd)) {
                return true;
            }
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITPullWizard.class.getName()).log(Level.WARNING, "Failed to create fetch wizard", e);
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_PULL_ERROR"), e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Namespace populate(Context context) throws Exception {
        Namespace ns = super.populate(context);
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient((URL)ns.get("git.local-url"));
            ns.put(LOCAL_BRANCH, (Object)this.getActiveBranch(client));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return ns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean commitWizard(Context context) {
        WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        wc.show();
        try {
            final Collection<File> failures = this.runOperation();
            if (failures.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GITUtil.reportMergeFailures(failures);
                }
            });
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITPullWizard.class.getName()).log(Level.WARNING, "Failed to commit import", e);
            this.getExceptionHandler().handleException(e, (Component)VCSWindowUtils.getCurrentWindow());
        }
        finally {
            wc.hide();
        }
        return false;
    }

    private Collection<File> runOperation() throws GITProcessException {
        String remoteUrl = (String)this.ns.get("git.remote-uri");
        Map branches = (Map)this.ns.get("git.use-branches");
        String mergeBranch = (String)this.ns.get(MERGE_BRANCH);
        URL localUrl = (URL)this.ns.get("git.local-url");
        String username = (String)this.ns.get("git.username");
        char[] passwd = (char[])this.ns.get("git.password");
        String keyFile = (String)this.ns.get("git.keyfile");
        char[] passPhrase = (char[])this.ns.get("git.passphrase");
        String remoteName = (String)this.ns.get("git.remote-name");
        boolean restore = false;
        GitClient client = null;
        ArrayList<File> reloadFiles = new ArrayList<File>();
        final IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)IdeUtil.getMainWindow(), Resource.get("WZ_PULL_PROGRESS"));
        try {
            VCSCancellable cancellable = new VCSCancellable(){

                public boolean isCancelled() {
                    return progress.isCanceled();
                }
            };
            progress.getPanel().setMessage(Resource.format("WZ_PULL_FROM_REPOS", remoteUrl));
            progress.start();
            client = GITClientAdaptor.getClient(localUrl);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("pull");
            monitor.setLog(true);
            monitor.setCancellable(cancellable);
            ArrayList<String> fetchSpec = new ArrayList<String>();
            for (String branch : branches.keySet()) {
                fetchSpec.add(GITRefSpec.getFetchSpec(branch.trim(), ((String)branches.get(branch)).trim()));
                if (!cancellable.isCancelled()) continue;
                List<File> list = Collections.emptyList();
                return list;
            }
            restore = GITUtil.authenticator(remoteUrl);
            GITClientAdaptor.setAuthentication(client, username, passwd, keyFile, passPhrase);
            GitPullResult result = client.pull(remoteUrl, fetchSpec, mergeBranch, (ProgressMonitor)monitor);
            if (cancellable.isCancelled()) {
                List<File> list = Collections.emptyList();
                return list;
            }
            reloadFiles.addAll(result.getMergeResult().getConflicts());
            GITUtil.logMergeConflicts(result.getMergeResult());
            reloadFiles.addAll(result.getMergeResult().getFailures());
            GITUtil.logMergeFailures(result.getMergeResult());
            Collection collection = result.getMergeResult().getFailures();
            return collection;
        }
        catch (GitException.AuthorizationException e) {
            throw new GITProcessException(Resource.get("WZ_PULL_FAILED"), e.getMessage());
        }
        catch (GitException e) {
            throw new GITProcessException(Resource.get("WZ_PULL_FAILED"), e.getMessage());
        }
        finally {
            this.connection(remoteUrl, remoteName, username, passwd, passPhrase);
            this.postUpdate(reloadFiles);
            progress.finish();
            GITUtil.authenricatorRestore(restore);
            if (client != null) {
                client.release();
            }
        }
    }

    private String getActiveBranch(GitClient client) throws GITProcessException {
        Map branches;
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
        try {
            branches = client.getBranches(false, (ProgressMonitor)monitor);
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITPullWizard.class.getName()).log(Level.WARNING, e.getMessage());
            throw new GITProcessException(Resource.get("WZ_PULL_LOCAL_BRANCH_ERROR"), e.getMessage());
        }
        if (monitor.getError() != null) {
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_CHECKOUT_ERROR"), monitor.getError());
        }
        GitBranch activeBranch = GITUtil.getActiveBranch(branches);
        return activeBranch.getName();
    }

    private void postUpdate(Collection<File> reloadFiles) {
        if (reloadFiles.isEmpty()) {
            return;
        }
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        final ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : reloadFiles) {
            urls.add(URLFactory.newFileURL((File)file));
        }
        profile.getPolicyStatusCache().clear(urls.toArray(new URL[0]));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VCSBufferUtils.reloadBuffer((URL[])urls.toArray(new URL[0]));
            }
        });
    }
}

