/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITBranch;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;

class GITPushBranchPanel
extends DefaultTraversablePanel {
    private static final String F1_HELP_ID = "f1_git_push_wizard_3_html";
    private JMultiLineLabel _hintText = new JMultiLineLabel();
    private GenericTable _table = new GenericTable((TableModel)new BranchTableModel());

    public GITPushBranchPanel() {
        this.init();
        this.setHelpID(F1_HELP_ID);
    }

    private void init() {
        Insets ins = new Insets(5, 5, 5, 5);
        this._hintText.setText(Resource.get("WZ_PUSH_BRANCH_HINT"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(new JScrollPane((Component)this._table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEntry(TraversableContext dataContext) {
        if (dataContext.getDirection() == 1) {
            Map remoteBranches = (Map)dataContext.get("git.remote-branches");
            GitClient client = null;
            try {
                URL localRootUrl = (URL)dataContext.get("git.local-url");
                client = GITClientAdaptor.getClient(localRootUrl);
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
                Map localBranches = client.getBranches(false, (ProgressMonitor)monitor);
                Collection<GITBranch> branches = this.getBranches(localBranches, remoteBranches);
                ((BranchTableModel)this._table.getModel()).addData(branches);
                GitBranch active = GITUtil.getActiveBranch(localBranches);
                if (active != null) {
                    ((BranchTableModel)this._table.getModel()).setBranchSelect(active.getName());
                }
                this._table.setSortColumn(1, true);
            }
            catch (GitException e) {
                MessageDialog.error((Component)((Object)this), (Object)Resource.get("WZ_PUSH_NO_LOCAL_BRANCH"), (String)Resource.get("WZ_PUSH_ERROR_TITLE"), null);
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            Collection branches = ((BranchTableModel)this._table.getModel()).getIncludeBranches();
            if (branches.isEmpty()) {
                throw new TraversalException(Resource.get("WZ_PUSH_NO_BRANCH"), Resource.get("WZ_PUSH_NO_BRANCH_TITLE"));
            }
            dataContext.put("git.use-branches", (Object)branches);
        }
    }

    private Collection<GITBranch> getBranches(Map<String, GitBranch> localBranch, Map<String, GitBranch> remoteBranch) {
        ArrayList<GITBranch> branches = new ArrayList<GITBranch>();
        for (String local : localBranch.keySet()) {
            String remote = remoteBranch.containsKey(local) ? local : "";
            GITBranch branch = new GITBranch(local, remote);
            branches.add(branch);
        }
        return branches;
    }

    private static class BranchTableModel
    extends DefaultTableModel
    implements GenericTableModel {
        private String[] _columns = new String[]{Resource.get("WZ_PUSH_BRANCH_COLUMN1"), Resource.get("WZ_PUSH_BRANCH_COLUMN2"), Resource.get("WZ_PUSH_BRANCH_COLUMN3"), Resource.get("WZ_PUSH_BRANCH_COLUMN4")};
        private GITBranch[] _branches;
        private Boolean[] _include;

        private BranchTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this._columns.length;
        }

        @Override
        public String getColumnName(int col) {
            return this._columns[col];
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                this._include[row] = (Boolean)value;
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this._include[row];
            }
            if (col == 1) {
                return this._branches[row].getLocal();
            }
            if (col == 2) {
                return this._branches[row].getRemote().isEmpty() ? this._branches[row].getLocal() : this._branches[row].getRemote();
            }
            if (col == 3) {
                return this._branches[row].isUpdate() ? Resource.get("WZ_PUSH_BRANCH_UPD") : Resource.get("WZ_PUSH_BRANCH_CRE");
            }
            return new Object();
        }

        @Override
        public int getRowCount() {
            if (this._branches == null || this._branches.length == 0) {
                return 0;
            }
            return this._branches.length;
        }

        private void addData(Collection<GITBranch> branches) {
            this._branches = branches.toArray(new GITBranch[0]);
            this._include = new Boolean[branches.size()];
            for (int b = 0; b < this._include.length; ++b) {
                this._include[b] = Boolean.FALSE;
            }
        }

        private Collection<GITBranch> getIncludeBranches() {
            ArrayList<GITBranch> branches = new ArrayList<GITBranch>();
            for (int b = 0; b < this._include.length; ++b) {
                if (!this._include[b].booleanValue()) continue;
                branches.add(this._branches[b]);
            }
            return branches;
        }

        private void setBranchSelect(String branch) {
            for (int b = 0; b < this._branches.length; ++b) {
                if (!this._branches[b].getLocal().equals(branch)) continue;
                this._include[b] = Boolean.TRUE;
            }
        }

        public int getColumnAlignment(int column) {
            if (column == 0) {
                return 0;
            }
            return 2;
        }

        public boolean canHide(int column) {
            return column != 0 && column != 1;
        }
    }
}

