/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITBranch;
import oracle.jdevimpl.vcs.git.wiz.GITWizardSummary;

class GITPushSummaryPanel
extends GITWizardSummary {
    private static final String F1_HELP_ID = "f1_git_push_wizard_4_html";

    GITPushSummaryPanel() {
        this.setHelpID(F1_HELP_ID);
    }

    @Override
    protected void initRes() {
        this.getHeaderLabel().setText(Resource.get("WZ_PUSH_SUMMARY_HEAD"));
        this.getHintText().setText(Resource.get("WZ_PUSH_SUMMARY_HINT"));
    }

    @Override
    protected DefaultTreeModel buildTree(TraversableContext tc) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
        DefaultTreeModel model = new DefaultTreeModel(root);
        model.setRoot(root);
        DefaultMutableTreeNode node = this.newNode(Resource.get("WZ_PUSH_SUMMARY_REPOS"));
        String remoteUrl = (String)tc.get("git.push-remote-uri");
        node.add(this.newNode(remoteUrl));
        root.add(node);
        String username = (String)tc.get("git.username");
        if (username != null && !username.isEmpty()) {
            node = this.newNode(Resource.get("WZ_PUSH_SUMMARY_USER"));
            node.add(this.newNode(username));
            root.add(node);
        }
        node = this.newNode(Resource.get("WZ_PUSH_SUMMARY_BRANCH"));
        Collection branches = (Collection)tc.get("git.use-branches");
        ArrayList sortBranch = new ArrayList();
        sortBranch.addAll(branches);
        Collections.sort(sortBranch, new BranchComparator());
        for (GITBranch br : sortBranch) {
            StringBuilder sb = new StringBuilder();
            sb.append(br.getLocal());
            sb.append(" -> ");
            sb.append(br.getRemote().isEmpty() ? br.getLocal() : br.getRemote());
            sb.append(" : ");
            sb.append(br.isUpdate() ? Resource.get("WZ_PUSH_SUMMARY_UPDATE") : Resource.get("WZ_PUSH_SUMMARY_CREATE"));
            node.add(this.newNode(sb.toString()));
        }
        root.add(node);
        node = this.newNode(Resource.get("WZ_SUMMARY_LOCAL_REPOSITORY"));
        URL local = (URL)tc.get("git.local-url");
        node.add(this.newNode(URLFileSystem.getPlatformPathName((URL)local)));
        root.add(node);
        return model;
    }

    private class BranchComparator
    implements Comparator {
        private BranchComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof GITBranch) || !(o2 instanceof GITBranch)) {
                return 0;
            }
            return ((GITBranch)o1).getLocal().compareTo(((GITBranch)o2).getLocal());
        }
    }
}

