/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.CommitListener;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdevimpl.vcs.git.GITCancellable;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITRefSpec;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITBranch;
import oracle.jdevimpl.vcs.git.wiz.GITFetchWizard;
import oracle.jdevimpl.vcs.git.wiz.GITPushBranchPanel;
import oracle.jdevimpl.vcs.git.wiz.GITPushRepositoryPanel;
import oracle.jdevimpl.vcs.git.wiz.GITPushSummaryPanel;
import oracle.jdevimpl.vcs.git.wiz.GITRemoteWizard;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitPushResult;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITPushWizard
extends GITRemoteWizard {
    private static final String F1_HELP_ID = "f1_git_push_wizard_1_html";
    private static final String PUSH_REPOS = "git.push-repository";
    private static final String PUSH_BRANCH = "git.push-branch";
    private static final String PUSH_SUMMARY = "git.push-summary";
    static final String REMOTE_URI = "git.push-remote-uri";
    static final String REMOTE_CONFIG = "git.push-remote-config";
    private Namespace ns;
    private WizardDialog wd;

    public boolean runWizard(Component parent, Context context) throws Exception {
        FSMBuilder fsmBuilder = new FSMBuilder();
        Step welcomeStep = WelcomePanel.newStep((String)Resource.get("WZ_PUSH_NAME"), (String)Resource.get("WZ_PUSH_HEADER"), (String)Resource.get("WZ_PUSH_TEXT"), (String)"GitPushSkipNextTime", (String)F1_HELP_ID);
        fsmBuilder.newStartState(welcomeStep, (Object)PUSH_REPOS);
        Step step = new Step(Resource.get("WZ_PUSH_REPOSITORY"), GITPushRepositoryPanel.class);
        fsmBuilder.newState((Object)PUSH_REPOS, step, (Object)PUSH_BRANCH);
        step = new Step(Resource.get("WZ_PUSH_BRANCH"), GITPushBranchPanel.class);
        fsmBuilder.newState((Object)PUSH_BRANCH, step, (Object)PUSH_SUMMARY);
        step = new Step(Resource.get("WZ_PUSH_SUMMARY"), GITPushSummaryPanel.class);
        fsmBuilder.newFinalState((Object)PUSH_SUMMARY, step);
        try {
            FSM stateMachine = fsmBuilder.getFSM();
            this.ns = this.populate(context);
            if (this.ns == null) {
                return false;
            }
            FSMWizard wiz = new FSMWizard(stateMachine, this.ns);
            wiz.setWelcomePageAdded(true);
            wiz.setFinishPageAdded(true);
            wiz.setWizardTitle(Resource.get("WZ_PUSH_TITLE"));
            wiz.setRoadmapVisible(true);
            wiz.setHeaderGradientBackground(new Color[]{new Color(-1), new Color(-3219482)});
            this.wd = this.createWizardDialog(wiz, parent, context);
            if (WizardLauncher.runDialog((JDialog)this.wd)) {
                return true;
            }
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITFetchWizard.class.getName()).log(Level.WARNING, "Failed to create fetch wizard", e);
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_PUSH_ERROR"), e);
        }
        return false;
    }

    @Override
    protected CommitListener getCommitListener(WizardDialog wd, Context context) {
        return new GITRemoteWizard.GITRemoteCommitListener(this, Resource.get("WIZARD_PUSH_GIT"), wd, context);
    }

    @Override
    protected Namespace populate(Context context) throws Exception {
        Namespace ns = super.populate(context);
        URL url = this.getURLFromGitWorkTree(context);
        ns.put(REMOTE_CONFIG, this.getRemoteConfigs(url));
        return ns;
    }

    @Override
    protected boolean runOperation(final GITCancellable cancel) throws GITProcessException {
        String remoteUrl = (String)this.ns.get(REMOTE_URI);
        Collection<GITBranch> branches = (Collection<GITBranch>)this.ns.get("git.use-branches");
        URL localUrl = (URL)this.ns.get("git.local-url");
        String username = (String)this.ns.get("git.username");
        char[] passwd = (char[])this.ns.get("git.password");
        String keyFile = (String)this.ns.get("git.keyfile");
        char[] passPhrase = (char[])this.ns.get("git.passphrase");
        boolean restore = false;
        GitClient client = null;
        try {
            VCSCancellable cancellable = new VCSCancellable(){

                public boolean isCancelled() {
                    return cancel.hasCancelled();
                }
            };
            client = GITClientAdaptor.getClient(localUrl);
            if (branches == null) {
                branches = this.useActiveBranch(client);
            }
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branch");
            monitor.setCancellable(cancellable);
            Map brans = client.getBranches(false, (ProgressMonitor)monitor);
            ArrayList<String> fetchSpec = new ArrayList<String>();
            ArrayList<String> pushSpec = new ArrayList<String>();
            Iterator<GITBranch> it = branches.iterator();
            monitor.setLog(true);
            while (it.hasNext()) {
                GITBranch branch = it.next();
                pushSpec.add(GITRefSpec.getPushSpec(branch.getLocal().trim(), branch.getRemote().isEmpty() ? branch.getLocal().trim() : branch.getRemote().trim()));
                GitBranch bran = (GitBranch)brans.get(branch.getLocal().trim());
                if (bran == null || bran.getTrackedBranch() == null) continue;
                GitBranch tracked = bran.getTrackedBranch();
                StringBuilder sbf = new StringBuilder();
                sbf.append("+refs/heads/");
                sbf.append(bran.getName());
                sbf.append(":refs/remotes/");
                sbf.append(tracked.getName());
                fetchSpec.add(sbf.toString());
            }
            restore = GITUtil.authenticator(remoteUrl);
            GITClientAdaptor.setAuthentication(client, username, passwd, keyFile, passPhrase);
            GitPushResult result = client.push(remoteUrl, pushSpec, fetchSpec, (ProgressMonitor)monitor);
        }
        catch (GitException e) {
            throw new GITProcessException(Resource.get("WZ_PUSH_FAILED"), e.getMessage());
        }
        finally {
            this.connection(remoteUrl, null, username, passwd, passPhrase);
            GITUtil.authenricatorRestore(restore);
            GITClientAdaptor.clearAuthentication(client);
            if (client != null) {
                client.release();
            }
        }
        return true;
    }

    private Collection<GITBranch> useActiveBranch(GitClient client) throws GitException {
        ArrayList<GITBranch> coll = new ArrayList<GITBranch>();
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
        Map localbranches = client.getBranches(false, (ProgressMonitor)monitor);
        for (String name : localbranches.keySet()) {
            GitBranch branch = (GitBranch)localbranches.get(name);
            if (!branch.isActive()) continue;
            coll.add(new GITBranch(name, name));
        }
        return coll;
    }

    private String getUserName(String urlStr) {
        int at = urlStr.indexOf("@");
        if (at == -1) {
            return null;
        }
        int ds = urlStr.indexOf("//");
        return urlStr.substring(ds + 2, at);
    }
}

