/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseParser;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Buffer;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLFromQuery;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.BaseMetadataFieldsFetcher;
import com.adbs.metadata.BaseMetadataFieldsFetcherVariants;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.metadata.MetadataFieldsFetcherFromResultSet;
import com.adbs.querybuilder.CustomizeDatasourceCaptionEvent;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.DA;
import com.adbs.syntax.OracleQueryPropertiesDialog;
import com.adbs.syntax.OracleSQLFromQueryExtender;
import com.adbs.syntax.OracleSQLFromSourceExtender;
import com.adbs.syntax.OracleSQLSelectStatementExtender;
import com.adbs.syntax.OracleSQLSubQueryExtender;
import com.adbs.syntax.OracleServerVersion;
import com.adbs.syntax.t;
import com.adbs.syntax.v;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OracleSyntaxProvider
extends BaseSyntaxProvider {
    private static final long i = 1L;
    private OracleServerVersion d = OracleServerVersion.Oracle11;

    @Override
    public boolean isSupportNullOrdering() {
        return true;
    }

    @Override
    public boolean isSupportCrossJoin() {
        OracleSyntaxProvider a2;
        return a2.d.compareTo(OracleServerVersion.Oracle9) >= 0;
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider a2) {
        assert (a2 != null);
        SyntaxSupportsConectedServer syntaxSupportsConectedServer = LoadMetadataHelpers.isConnectedServerIsOracle(a2);
        if (syntaxSupportsConectedServer == SyntaxSupportsConectedServer.Unknown) {
            OracleSyntaxProvider a3;
            return super.isSupportConectedServer(a2);
        }
        return syntaxSupportsConectedServer;
    }

    @Override
    public void endBuildWrapperForStoredProc(SQLBuilder a2, SQLBuilderSelectFormat a3) {
        a2.writeSymbol(CustomizeDatasourceCaptionEvent.f("\u000e"));
    }

    @Override
    public Class getEditPropsFormClass(Object a2) {
        OracleSyntaxProvider a3;
        if (a2 instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (a2 instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (a2 instanceof UnionSubQuery) {
            return OracleQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(a2);
    }

    public OracleServerVersion getServerVersion() {
        OracleSyntaxProvider a2;
        return a2.d;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleSyntaxProvider() {
        OracleSyntaxProvider a2;
        try {
            OracleSyntaxProvider oracleSyntaxProvider = a2;
            a2.registerExtender(SQLFromQuery.class, OracleSQLFromQueryExtender.class);
            oracleSyntaxProvider.registerExtender(SQLFromSource.class, OracleSQLFromSourceExtender.class);
            oracleSyntaxProvider.registerExtender(SQLSubQuerySelectExpression.class, OracleSQLSubQueryExtender.class);
            a2.registerExtender(SQLSelectStatement.class, OracleSQLSelectStatementExtender.class);
            return;
        }
        catch (Exception exception) {
            Logger.getLogger(OracleSyntaxProvider.class.getName()).log(Level.SEVERE, null, exception);
            return;
        }
    }

    @Override
    public boolean isSupportCTE() {
        OracleSyntaxProvider a2;
        return a2.d.compareTo(OracleServerVersion.Oracle9) >= 0;
    }

    @Override
    public String getQueryToLoadFieldsForObject(String a2, String a3) {
        String string = Str.IsNullOrEmpty(a2) ? Buffer.f("\u000e") : a2;
        return new StringBuilder().insert(0, CustomizeDatasourceCaptionEvent.f("T\nK\nD\u001b\u0007")).append(string).append(Buffer.f("cB1K.\u0004")).append(a3).append(CustomizeDatasourceCaptionEvent.f("OFOP\u0007B\u001dBOU\u0000P\u0001R\u0002\u001b_\u0007\u000eI\u000b\u0007_\u001bQ\u0017")).toString();
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext a2, MetadataContainer a3, MetadataFilter a4, SQLQualifiedName a5) throws QueryBuilderException {
        OracleSyntaxProvider a6;
        if (a6.isDetectServerVersion()) {
            a6.doDetectServerVersion(a2.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataRelationsOracle(a2, a3, a4, a5)) {
            super.loadMetadataRelations(a2, a3, a4, a5);
        }
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList a2) {
        OracleSyntaxProvider a3;
        SQLQualifiedNameList sQLQualifiedNameList = a2;
        sQLQualifiedNameList.clear();
        sQLQualifiedNameList.addIdentifier(Buffer.f("e5C"), false);
        if (a3.d.compareTo(OracleServerVersion.Oracle9) > 0) {
            a2.addIdentifier(CustomizeDatasourceCaptionEvent.f("d\u0000K\u0003B\fS"), false);
        }
        a2.addIdentifier(Buffer.f("g,Q-P"), false);
        a2.addIdentifier(CustomizeDatasourceCaptionEvent.f("j\u000e_"), false);
        a2.addIdentifier(Buffer.f("i*J"), false);
        a2.addIdentifier(CustomizeDatasourceCaptionEvent.f("<S\u000bc\nQ"), false);
        a2.addIdentifier(Buffer.f("w6I"), false);
        a2.addIdentifier(CustomizeDatasourceCaptionEvent.f("9F\u001dN\u000eI\fB"), false);
    }

    @Override
    public void getSchemaList(BaseSQLContext a2, SQLIdentifiersCollection a3, SQLQualifiedName a4) {
        OracleSyntaxProvider a5;
        if (a5.isDetectServerVersion()) {
            a5.doDetectServerVersion(a2.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getSchemaListOracle(a2, a3, a4)) {
            super.getSchemaList(a2, a3, a4);
        }
    }

    @Override
    public void setDetectServerVersion(boolean a2) {
        OracleSyntaxProvider a3;
        super.setDetectServerVersion(a2);
    }

    @Override
    public BaseSyntaxProvider clone() {
        OracleSyntaxProvider a2;
        ((OracleSyntaxProvider)super.clone()).d = a2.d;
        return (OracleSyntaxProvider)super.clone();
    }

    @Override
    public boolean isSupportDatabases() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doDetectServerVersion(BaseMetadataProvider a2) {
        OracleSyntaxProvider a3;
        BaseMetadataProvider baseMetadataProvider = a2;
        super.doDetectServerVersion(baseMetadataProvider);
        switch (LoadMetadataHelpers.calcServerVersionOracle(baseMetadataProvider)) {
            case 7: {
                a3.setServerVersion(OracleServerVersion.Oracle7);
                return;
            }
            case 8: {
                a3.setServerVersion(OracleServerVersion.Oracle8);
                return;
            }
            case 9: {
                a3.setServerVersion(OracleServerVersion.Oracle9);
                return;
            }
            case 10: {
                a3.setServerVersion(OracleServerVersion.Oracle10);
                return;
            }
            case 11: {
                a3.setServerVersion(OracleServerVersion.Oracle11);
                return;
            }
        }
        a3.setServerVersion(OracleServerVersion.Oracle11);
    }

    @Override
    protected Class getScannerClass() {
        return t.class;
    }

    @Override
    public String getSimpleEmptyFromSubquery() {
        return Buffer.f("\f\u0010a\u000fa\u0000pcj\u0016h\u000f\u0004\u0005v\fic`\u0016e\u000f\r");
    }

    @Override
    public boolean isSupportOracleJoins() {
        return true;
    }

    @Override
    public boolean isDetectServerVersion() {
        OracleSyntaxProvider a2;
        return super.isDetectServerVersion();
    }

    @Override
    public String getDescription() {
        return CustomizeDatasourceCaptionEvent.f(" U\u000eD\u0003B");
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList a2) {
        SQLQualifiedNameList sQLQualifiedNameList = a2;
        sQLQualifiedNameList.clear();
        sQLQualifiedNameList.addIdentifier(Buffer.f("g,Q-P"), false);
    }

    @Override
    protected Class getParserClass() {
        return DA.class;
    }

    @Override
    public void getDefaultSchemaNames(BaseSQLContext a2, SQLIdentifiersCollection a3) throws QueryBuilderException {
        OracleSyntaxProvider a4;
        if (a4.isDetectServerVersion()) {
            a4.doDetectServerVersion(a2.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getDefaultSchemaNamesOracle(a2, a3)) {
            super.getDefaultSchemaNames(a2, a3);
        }
    }

    @Override
    public boolean isSupportSchemas() {
        return true;
    }

    public void getUnionOperatorList(List a2) {
        List list = a2;
        list.clear();
        list.add("Union");
        a2.add(CustomizeDatasourceCaptionEvent.f("r\u0001N\u0000IOf\u0003K"));
        a2.add(Buffer.f("m-P&V0A P"));
        a2.add(CustomizeDatasourceCaptionEvent.f("j\u0006I\u001aT"));
    }

    @Override
    public boolean isFixedSizeType(String a2) {
        return a2.compareToIgnoreCase(Buffer.f(" L\"V")) != 0 && a2.compareToIgnoreCase(CustomizeDatasourceCaptionEvent.f("I\fO\u000eU")) != 0 && a2.compareToIgnoreCase(Buffer.f("R\"V L\"V")) != 0 && a2.compareToIgnoreCase(CustomizeDatasourceCaptionEvent.f("\u0001Q\u000eU\fO\u000eU")) != 0 && a2.compareToIgnoreCase(Buffer.f("5E1G+E1\u0016")) != 0 && a2.compareToIgnoreCase(CustomizeDatasourceCaptionEvent.f("I\u0019F\u001dD\u0007F\u001d\u0015")) != 0 && a2.compareToIgnoreCase(Buffer.f("V\"S")) != 0;
    }

    @Override
    public boolean isSupportANSIJoins() {
        OracleSyntaxProvider a2;
        return a2.d.compareTo(OracleServerVersion.Oracle9) >= 0;
    }

    @Override
    public void beginBuildWrapperForStoredProc(SQLBuilder a2, SQLBuilderSelectFormat a3) {
        SQLBuilder sQLBuilder = a2;
        sQLBuilder.writeKeyword(CustomizeDatasourceCaptionEvent.f("s\u000eE\u0003B"));
        sQLBuilder.writeSymbol(Buffer.f("\f"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void setParserParams(BaseParser a2) {
        OracleSyntaxProvider a3;
        super.setParserParams(a2);
        switch (v.d[a3.d.ordinal()]) {
            case 1: {
                a2.serverVersion = 7;
                return;
            }
            case 2: {
                a2.serverVersion = 8;
                return;
            }
            case 3: {
                a2.serverVersion = 9;
                return;
            }
            case 4: {
                a2.serverVersion = 10;
                return;
            }
        }
        a2.serverVersion = 10;
    }

    public void getComparisonOperators(List a2) {
        List list = a2;
        list.clear();
        list.add(CustomizeDatasourceCaptionEvent.f("\u001a"));
        a2.add(Buffer.f("\u0018"));
        a2.add(CustomizeDatasourceCaptionEvent.f("S\u001a"));
        a2.add(Buffer.f("\u001a"));
        a2.add(CustomizeDatasourceCaptionEvent.f("Q\u001a"));
        a2.add(Buffer.f("\u007f\u001a"));
        a2.add(CustomizeDatasourceCaptionEvent.f("N\u001a"));
        a2.add(Buffer.f("b\u001a"));
        a2.add(CustomizeDatasourceCaptionEvent.f("N\u001b"));
    }

    @Override
    public boolean isFromClauseMandatory() {
        return true;
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext a2, MetadataObject a3) throws QueryBuilderException {
        OracleSyntaxProvider a4;
        assert (a2 != null);
        assert (((BaseSQLContext)a2).getMetadataProvider() != null);
        assert (((BaseSQLContext)a2).getMetadataProvider().canExecSQL());
        assert (a3 != null);
        if (a4.isDetectServerVersion()) {
            a4.doDetectServerVersion(((BaseSQLContext)a2).getMetadataProvider());
        }
        MetadataObject metadataObject = a3;
        String string = metadataObject.getName().getSimpleSQL(((BaseSQLContext)a2).getSQLBuilderExpressionForServerWithoutQuotes());
        String string2 = metadataObject.getSchema().getSimpleSQL(((BaseSQLContext)a2).getSQLBuilderExpressionForServerWithoutQuotes());
        if (((BaseSQLContext)a2).isTableExists(Buffer.f("e\u000fh\u001cp\u0002f\u001cg\fh\u0016i\rw")) && ((BaseSQLContext)a2).isTableExists(CustomizeDatasourceCaptionEvent.f("f#k0n!c0d k:j!t")) && ((BaseSQLContext)a2).isTableExists(Buffer.f("e\u000fh\u001cg\fj\u0010p\u0011e\nj\u0017w"))) {
            Disposable disposable = a2 = new MetadataFieldsFetcherFromQuery((BaseSQLContext)a2);
            Disposable disposable2 = a2;
            Disposable disposable3 = a2;
            Disposable disposable4 = a2;
            Disposable disposable5 = a2;
            Disposable disposable6 = a2;
            ((MetadataFieldsFetcherFromQuery)a2).setQuery(CustomizeDatasourceCaptionEvent.f("t*k*d;\u0007,\t,h#r\"i0i.j*\u000bOdAc.s.x;~?bC\u0007,\t,o.u0k*i(s'\u000bOdAc.s.x?u*d&t&h!\u000bOdAc.s.x<d.k*\u000bOdAi:k#f-k*\u000bOdAc.s.x+b)f:k;\u000bOt:eAd k:j!x?h<n;n iOw$\u000bOd jAd j\"b!s<\u0007,h\"j*i;tOa=h\"\u0007.k#x;f-x,h#r\"i<\u0007,\u000bO\u000f<b#b,sOd k:j!x!f\"bCd k:j!x?h<n;n iOa=h\"\u0007.k#x&i+x,h#r\"i<\u00078o*u*\u0007Gn!c*\u007f0h8i*uCn!c*\u007f0i.j*\u000eO\u001aO\u000f<b#b,sOh8i*uCn!c*\u007f0i.j*\u0007)u jOf#k0d i<s=f&i;tOp'b=bOh8i*uO\u001aO\u0000") + string2 + Buffer.f("d\u0004\u0002j\u0007\u0004") + CustomizeDatasourceCaptionEvent.f(";f-k*x!f\"bO\u001aO\u0000") + string + Buffer.f("d\u0004") + CustomizeDatasourceCaptionEvent.f("f!cOd i<s=f&i;x;~?bO\u001aO\u0000?\u0000F\u000eOt:eC\u0007") + Buffer.f("\fcw\u0006h\u0006g\u0017\u0004\u0000k\u000fq\u000ej\u001cj\u0002i\u0006\bcg\fi\u000ea\rp\u0010\u0004\u0005v\fice\u000fh\u001cg\fh\u001cg\fi\u000ea\rp\u0010\u0004") + CustomizeDatasourceCaptionEvent.f("p'b=bOh8i*uR\u0000") + string2 + Buffer.f("d\u0004\u0002j\u0007\u0004") + CustomizeDatasourceCaptionEvent.f(";f-k*x!f\"bR\u0000") + string + Buffer.f("\u0003j\u0004\u0000k\u000e\u0004") + CustomizeDatasourceCaptionEvent.f("p'b=bOdAd k:j!x!f\"bO\u001aOt:eAd k:j!x!f\"bG\fF\u0007") + Buffer.f("e\r`cgmg\fh\u0016i\r{\re\u000eac\u0019cg\fimg\fh\u0016i\r{\re\u000eak\u000fj\u0004") + CustomizeDatasourceCaptionEvent.f("f!cOdAh8i*uO\u001aO\u0000") + string2 + Buffer.f("d\u0004") + CustomizeDatasourceCaptionEvent.f(".i+\u0007,\t;f-k*x!f\"bO\u001aO\u0000") + string + Buffer.f("d\u0004") + CustomizeDatasourceCaptionEvent.f(" u+b=\u0007-~Ot:eAd k:j!x?h<n;n iCd k:j!x&c"));
            ((MetadataFieldsFetcherFromResultSet)disposable6).setNameFieldName(Buffer.f("g\fh\u0016i\r{\re\u000ea"));
            ((MetadataFieldsFetcherFromResultSet)disposable6).setServerTypeFieldName(CustomizeDatasourceCaptionEvent.f("c.s.x;~?b"));
            ((MetadataFieldsFetcherFromResultSet)disposable5).setSizeFieldName(Buffer.f("g\u000be\u0011{\u000fa\rc\u0017l"));
            ((MetadataFieldsFetcherFromResultSet)disposable5).setPrecisionFieldName(CustomizeDatasourceCaptionEvent.f("+f;f0w=b,n<n i"));
            ((MetadataFieldsFetcherFromResultSet)disposable4).setScaleFieldName(Buffer.f("\u0007e\u0017e\u001cw\u0000e\u000fa"));
            ((MetadataFieldsFetcherFromResultSet)disposable4).setDefaultValueFieldName(CustomizeDatasourceCaptionEvent.f("+f;f0c*a.r#s"));
            ((MetadataFieldsFetcherFromResultSet)disposable3).setNullableFieldName(Buffer.f("\rq\u000fh\u0002f\u000fa"));
            ((BaseMetadataFieldsFetcherVariants)disposable3).setNullableValue(CustomizeDatasourceCaptionEvent.f("~"));
            ((MetadataFieldsFetcherFromResultSet)disposable2).setPrimaryFieldName(Buffer.f("\u0013o"));
            ((BaseMetadataFieldsFetcherVariants)disposable2).setNonPrimaryValue(null);
            ((MetadataFieldsFetcherFromResultSet)disposable).setLongDescriptionFieldName(CustomizeDatasourceCaptionEvent.f(",h\"j*i;t"));
            ((BaseMetadataFieldsFetcher)disposable).loadFields(a3.getFields());
        }
    }

    @Override
    public AstTokenIdentifier getEmptySchemaName(BaseSQLContext a2) {
        return new AstTokenIdentifier(a2, Buffer.f("\u0013q\u0001h\ng"), false);
    }

    @Override
    public boolean isSupportSynonyms() {
        return true;
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList a2) {
        OracleSyntaxProvider a3;
        SQLQualifiedNameList sQLQualifiedNameList = a2;
        super.getBuiltinFunctionNames(sQLQualifiedNameList);
        sQLQualifiedNameList.addBuiltin(CustomizeDatasourceCaptionEvent.f("f\rT"));
        a2.addBuiltin(Buffer.f("\u0002g,W"));
        SQLQualifiedNameList sQLQualifiedNameList2 = a2;
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f(".t\u0006I"));
        sQLQualifiedNameList2.addBuiltin(Buffer.f("\u0002p\"J"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("f;F\u0001\u0015"));
        a2.addBuiltin(Buffer.f("\u0001M7e-@"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f(",B\u0006K"));
        a2.addBuiltin(Buffer.f("g,W"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f(",H\u001co"));
        a2.addBuiltin(Buffer.f("a;T"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("a\u0003H\u0000U"));
        a2.addBuiltin(Buffer.f("\u000fJ"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("k\u0000@"));
        a2.addBuiltin(Buffer.f("i,@"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("i\u000eI9K"));
        a2.addBuiltin(Buffer.f("t,S&V"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("u\nJ\u000eN\u0001C\nU"));
        a2.addBuiltin(Buffer.f("v,Q-@"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("<N\bI"));
        a2.addBuiltin(Buffer.f("w*J"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("<N\u0001o"));
        a2.addBuiltin(Buffer.f("\u0010U\u0011P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u000eI"));
        a2.addBuiltin(Buffer.f("\u0017E-l"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u001dR\u0001D"));
        a2.addBuiltin(Buffer.f("\u0014M'P+{\u0001Q O&P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("d\u0007U"));
        a2.addBuiltin(Buffer.f("\u0000K-G\"P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("n\u0001N\u001bd\u000eW"));
        a2.addBuiltin(Buffer.f("h,S&V"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("#w\u000eC"));
        a2.addBuiltin(Buffer.f("h\u0017V*I"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("i#t0n\u0001H\u001bd\u000eW"));
        a2.addBuiltin(Buffer.f("j\u000fw\u001ch,S&V"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("i#t<H\u001dS"));
        a2.addBuiltin(Buffer.f("j\u000fw\u001cq3T&V"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("=B\bb\u0017W0u\nW\u0003F\fB"));
        a2.addBuiltin(Buffer.f("v&C\u0006\\3{\u0010Q!w7V"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("u\nW\u0003F\fB"));
        a2.addBuiltin(Buffer.f("\u0011t\"@"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("u;U\u0006J"));
        a2.addBuiltin(Buffer.f("w,Q-@\u0006\\"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("<R\rt\u001bU"));
        a2.addBuiltin(Buffer.f("p1E-W/E7A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u001dB\u000eS"));
        a2.addBuiltin(Buffer.f("\u0017V*I"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("r\u001fW\nU"));
        a2.addBuiltin(Buffer.f("v&C\u0006\\3{\u000fM(A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("!k<x,O\u000eU\u001cB\u001bx+B\fK0k\nI"));
        a2.addBuiltin(Buffer.f("\rh\u0010{\u0000L\"V0A7{\n@"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("!k<x,O\u000eU\u001cB\u001bx!F\u0002B"));
        a2.addBuiltin(Buffer.f("e\u0010g\nm"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("n\u0001T\u001bU"));
        a2.addBuiltin(Buffer.f("\u000fA-C7L"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("=B\bb\u0017W0n\u0001T\u001bU"));
        a2.addBuiltin(Buffer.f("\"@'{\u000eK-P+W"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("d\u001aU\u001dB\u0001S0s\u0006J\nT\u001bF\u0002W"));
        a2.addBuiltin(Buffer.f("\u0007F\u0017M.A\u0019K-A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("b\u0017S\u001dF\fS"));
        a2.addBuiltin(Buffer.f("b1K.{\u0017~"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("#F\u001cS0c\u000e^"));
        a2.addBuiltin(Buffer.f("\u000fK E/p*I&W7E.T"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("\"H\u0001S\u0007T0e\nS\u0018B\nI"));
        a2.addBuiltin(Buffer.f("\rA4{\u0017M.A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("!B\u0017S0c\u000e^"));
        a2.addBuiltin(Buffer.f("j6I\u0017K\u0007w\nJ7A1R\"H"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("i\u001aJ;H6j&I\u001bB\u001dQ\u000eK"));
        a2.addBuiltin(Buffer.f("v,Q-@"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("t\nT\u001cN\u0000I;N\u0002B5H\u0001B"));
        a2.addBuiltin(Buffer.f("w:W\u001ca;P1E P\u001cq\u0017g"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("t\u0016T+F\u001bB"));
        a2.addBuiltin(Buffer.f("\u0010]0p*I&W7E.T"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u0000x,O\u000eU"));
        a2.addBuiltin(Buffer.f("\u0017K\u001cp*I&W7E.T"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u0000x;N\u0002B\u001cS\u000eJ\u001fx;}"));
        a2.addBuiltin(Buffer.f("p,{\u0007w\nJ7A1R\"H"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u0000x6j&I\u001bB\u001dQ\u000eK"));
        a2.addBuiltin(Buffer.f("p1Q-G"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s5x A\tT\nS"));
        a2.addBuiltin(Buffer.f("\u0004V&E7A0P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("k\nF\u001cS"));
        a2.addBuiltin(Buffer.f("\u0002w\u0000m\nw7V"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("-N\u0001x;H0i\u001aJ"));
        a2.addBuiltin(Buffer.f("\u0000E0P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("d\u0007F\u001ds\u0000u\u0000P&C"));
        a2.addBuiltin(Buffer.f("g,I3K0A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("d\u0000I\u0019B\u001dS"));
        a2.addBuiltin(Buffer.f("`&G,I3K0A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("'B\u0017s\u0000u\u000eP"));
        a2.addBuiltin(Buffer.f("j6I\u0017K\u0007w\nJ7A1R\"H"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("i\u001aJ;H6j&I\u001bB\u001dQ\u000eK"));
        a2.addBuiltin(Buffer.f("\u0011E4p,l&\\"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("u\u000eP;H!o\n_"));
        a2.addBuiltin(Buffer.f("v,S\n@\u0017K\u0000L\"V"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("=H\u0018n\u000bs\u0000i,O\u000eU"));
        a2.addBuiltin(Buffer.f("\u0010g\r{\u0017K\u001cp*I&W7E.T"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f(";N\u0002B\u001cS\u000eJ\u001fx;H0t,i"));
        a2.addBuiltin(Buffer.f("\u0017K\u001cf*J\"V:{\u0007K6F/A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u0000x-N\u0001F\u001d^0a\u0003H\u000eS"));
        a2.addBuiltin(Buffer.f("p,{\u0000L\"V"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u0000x,k e"));
        a2.addBuiltin(Buffer.f("p,{\u0007E7A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u0000x+t&I\u001bB\u001dQ\u000eK"));
        a2.addBuiltin(Buffer.f("\u0017K\u001ch\ff"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u0000x\"R\u0003S\u0006x-^\u001bB"));
        a2.addBuiltin(Buffer.f("\u0017K\u001cj\u0000L\"V"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f(";H0i,k e"));
        a2.addBuiltin(Buffer.f("p,{\rQ.F&V"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u0000x+t&I\u001bB\u001dQ\u000eK"));
        a2.addBuiltin(Buffer.f("\u0017K\u001cw*J$H&{\u0001]7A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f(";H0s\u0006J\nT\u001bF\u0002W"));
        a2.addBuiltin(Buffer.f("p,{\u0017M.A0P\"I3{\u0017~"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("s\u0000x6j&I\u001bB\u001dQ\u000eK"));
        a2.addBuiltin(Buffer.f("\u0016J*w7V"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("e)N\u0003B!F\u0002B"));
        a2.addBuiltin(Buffer.f("\u0006I3P:{\u0001h\ff"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("*J\u001fS\u0016x,k e"));
        a2.addBuiltin(Buffer.f("g\"V'M-E/M7]"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("d\u0000K\u0003B\fS"));
        a2.addBuiltin(Buffer.f("t,S&V\u000eQ/P*w&P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("?H\u0018B\u001dj\u001aK\u001bN<B\u001bx-^0d\u000eU\u000bN\u0001F\u0003N\u001b^"));
        a2.addBuiltin(Buffer.f("w\u0006p"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("t\u0016T0d\u0000I\u0001B\fS0e\u0016x?F\u001bO"));
        a2.addBuiltin(Buffer.f("\u0000H6W7A1{\n@"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("d\u0003R\u001cS\nU0w\u001dH\rF\rN\u0003N\u001b^"));
        a2.addBuiltin(Buffer.f("g/Q0P&V\u001cw&P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f(")B\u000eS\u001aU\nx&C"));
        a2.addBuiltin(Buffer.f("b&E7Q1A\u001cw&P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("a\nF\u001bR\u001dB0q\u000eK\u001aB"));
        a2.addBuiltin(Buffer.f("\u0013V&@*G7M,J"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("w\u001dB\u000bN\fS\u0006H\u0001x-H\u001aI\u000bT"));
        a2.addBuiltin(Buffer.f("t1A'M P*K-{\u0000K0P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("?U\nC\u0006D\u001bN\u0000I0c\nS\u000eN\u0003T"));
        a2.addBuiltin(Buffer.f("\u0013V&@*G7M,J\u001ct1K!E!M/M7]"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("?U\nC\u0006D\u001bN\u0000I0t\nS"));
        a2.addBuiltin(Buffer.f("\u0002T3A-@\u0000L*H'|\u000eh"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("c\nK\nS\n\u007f\"k"));
        a2.addBuiltin(Buffer.f("`&T7L"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("b\u0017S\u001dF\fS"));
        a2.addBuiltin(Buffer.f("\u0006\\*W7W\rK'A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("*_\u001bU\u000eD\u001bq\u000eK\u001aB"));
        a2.addBuiltin(Buffer.f("\nJ0A1P\u0000L*H'|\u000eh"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("n\u0001T\nU\u001b\u007f\"k-B\tH\u001dB"));
        a2.addBuiltin(Buffer.f("\u0013E7L"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("<^\u001cx+E:u&`\nI"));
        a2.addBuiltin(Buffer.f("\u0010]0{\u001bi\u000fe$C"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("<^\u001cx7j#`\nI"));
        a2.addBuiltin(Buffer.f("q3@\"P&|\u000eh"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("7j#f\b@"));
        a2.addBuiltin(Buffer.f("|\u000eh\u0000E0P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("7j#d+F\u001bF"));
        a2.addBuiltin(Buffer.f("\u001bi\u000fg,H\u0002P7r\"H"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("7j#d\u0000J\u0002B\u0001S"));
        a2.addBuiltin(Buffer.f("|\u000eh\u0000K-G\"P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("\u007f\"k+N\tA"));
        a2.addBuiltin(Buffer.f("\u001bi\u000fa/A.A-P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("\u007f\"k*_\u0006T\u001bT"));
        sQLQualifiedNameList2.addBuiltin(Buffer.f("|\u000eh\u0005K1A0P"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("7j#w\u000eU\u001cB"));
        a2.addBuiltin(Buffer.f("\u001bi\u000ft\"P L"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("\u007f\"k?N"));
        a2.addBuiltin(Buffer.f("\u001bi\u000fu6A1]"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("\u007f\"k=H\u0000S"));
        a2.addBuiltin(Buffer.f("|\u000eh\u0010A2Q&J A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("7j#t\nU\u0006F\u0003N\u0015B"));
        a2.addBuiltin(Buffer.f("\u001bi\u000fp\"F/A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("7j#s\u001dF\u0001T\tH\u001dJ"));
        a2.addBuiltin(Buffer.f("\u0007A K'A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("+R\u0002W"));
        a2.addBuiltin(Buffer.f("\fV\"{\u000bE0L"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("q<N\u0015B"));
        a2.addBuiltin(Buffer.f("\u0000K\"H&W A"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("k\u0001i9k"));
        a2.addBuiltin(Buffer.f("\rQ/H\nB"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("i9k"));
        a2.addBuiltin(Buffer.f("\rr\u000f\u0016"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("t\u0016T0d\u0000I\u001bB\u0017S"));
        a2.addBuiltin(Buffer.f("\u0010]0{\u0004q\n`"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("<^\u001cx;^\u001fB&C"));
        a2.addBuiltin(Buffer.f("q\n@"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f(":T\nU"));
        a2.addBuiltin(Buffer.f("q0A1a-R"));
        a2.addBuiltin(CustomizeDatasourceCaptionEvent.f("q\u000eK\u001aB"));
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext a2, MetadataContainer a3, MetadataFilter a4, SQLQualifiedName a5) throws QueryBuilderException {
        OracleSyntaxProvider a6;
        if (a6.isDetectServerVersion()) {
            a6.doDetectServerVersion(a2.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataObjectsOracle(a2, a3, a4, a5)) {
            super.loadMetadataObjects(a2, a3, a4, a5);
        }
    }

    public void setServerVersion(OracleServerVersion a2) {
        OracleSyntaxProvider a3;
        if (a3.d != a2) {
            a3.d = a2;
            a3.sendNotifications();
        }
    }

    @Override
    public boolean isSupportRecursiveCTE() {
        return false;
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList a2) {
        OracleSyntaxProvider a3;
        SQLQualifiedNameList sQLQualifiedNameList = a2;
        sQLQualifiedNameList.clear();
        sQLQualifiedNameList.addIdentifier("Grouping", false);
        if (a3.d.compareTo(OracleServerVersion.Oracle8) > 0) {
            a2.addIdentifier(Buffer.f("c1K6T*J${\n@"), false);
            a2.addIdentifier(CustomizeDatasourceCaptionEvent.f("\"B\u000bN\u000eI"), false);
        }
        if (a3.d.compareTo(OracleServerVersion.Oracle9) > 0) {
            a2.addIdentifier(Buffer.f("\u0010P\"P0{\u000eK'A"), false);
        }
        a2.addIdentifier(CustomizeDatasourceCaptionEvent.f("<S\u000bc\nQ0w\u0000W"), false);
        a2.addIdentifier(Buffer.f("w7@\u0007A5{\u0010E.T"), false);
        if (a3.d.compareTo(OracleServerVersion.Oracle10) > 0) {
            a2.addIdentifier(CustomizeDatasourceCaptionEvent.f("<^\u001cx7J\u0003f\b@"), false);
        }
        a2.addIdentifier(Buffer.f("r\"V\u001ct,T"), false);
        a2.addIdentifier(CustomizeDatasourceCaptionEvent.f("9F\u001dx<F\u0002W"), false);
        if (a3.d.compareTo(OracleServerVersion.Oracle10) > 0) {
            a2.addIdentifier(Buffer.f("\u001bI/e$C"), false);
        }
    }
}

