/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.impl;

import java.io.File;
import java.util.logging.Logger;

public class PlatformUtil {
    private static final Logger logger = Logger.getLogger(PlatformUtil.class.getName());
    private static final String FALSE = Boolean.FALSE.toString();
    private static final String OS_NAME = "os.name";
    private static final String WINDOWS_LOWER = "windows";
    private static final String LINUX_LOWER = "linux";
    private static final String MAC_LOWER = "mac";
    private static final String OSX_LOWER = "os x";
    private static final String USE_URLFS_PARAM = "adflib.useURLFileSystem";
    private Boolean windows = null;
    private Boolean linux = null;
    private Boolean macosx = null;
    private Boolean unix = null;

    public final boolean isWindows() {
        if (this.windows == null) {
            this.init();
        }
        return this.windows;
    }

    public final boolean isLinux() {
        if (this.linux == null) {
            this.init();
        }
        return this.linux;
    }

    public final boolean isMacOrOSX() {
        if (this.macosx == null) {
            this.init();
        }
        return this.macosx;
    }

    public final boolean isUnix() {
        if (this.unix == null) {
            this.init();
        }
        return this.unix;
    }

    public final boolean useURLFileSystem() {
        try {
            String useURLFS = System.getProperty(USE_URLFS_PARAM);
            if (useURLFS != null) {
                return !FALSE.equalsIgnoreCase(useURLFS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void init() {
        String osName = "unknown";
        try {
            osName = System.getProperty(OS_NAME);
            if (osName != null) {
                if ((osName = osName.toLowerCase()).contains(WINDOWS_LOWER)) {
                    this.setWindows();
                    return;
                }
                if (osName.contains(LINUX_LOWER)) {
                    this.setLinux();
                    return;
                }
                if (osName.contains(MAC_LOWER) || osName.contains(OSX_LOWER)) {
                    this.setMacosx();
                    return;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (File rt : File.listRoots()) {
            String absPath = rt.getAbsolutePath();
            if (absPath == null) continue;
            if ("/".equals(absPath)) {
                this.setUnix();
                return;
            }
            if (absPath.length() != 3 || !absPath.endsWith(":\\")) continue;
            this.setWindows();
            return;
        }
        if (File.pathSeparatorChar == ';' || File.separatorChar == '\\') {
            this.setWindows();
            return;
        }
        if (File.pathSeparatorChar == ':' || File.separatorChar == '/') {
            this.setUnix();
            return;
        }
        logger.fine("Couldn't make any associations to the platform\n   os.name=" + osName + "   roots=" + File.listRoots());
        this.windows = Boolean.FALSE;
        this.linux = Boolean.FALSE;
        this.macosx = Boolean.FALSE;
        this.unix = Boolean.FALSE;
    }

    private final void setWindows() {
        this.windows = Boolean.TRUE;
        this.linux = Boolean.FALSE;
        this.macosx = Boolean.FALSE;
        this.unix = Boolean.FALSE;
    }

    private final void setLinux() {
        this.windows = Boolean.FALSE;
        this.macosx = Boolean.FALSE;
        this.linux = Boolean.TRUE;
        this.unix = Boolean.TRUE;
    }

    private final void setMacosx() {
        this.windows = Boolean.FALSE;
        this.linux = Boolean.FALSE;
        this.macosx = Boolean.TRUE;
        this.unix = Boolean.TRUE;
    }

    private final void setUnix() {
        this.windows = Boolean.FALSE;
        this.macosx = Boolean.FALSE;
        this.linux = Boolean.FALSE;
        this.unix = Boolean.TRUE;
    }
}

