/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.impl.PlatformUtil;
import oracle.adf.share.common.rc.util.impl.URLUtil;
import oracle.adf.share.common.util.ADFJarUtil;

public class LoaderUtil {
    private static ThreadLocal<HashMap<Object, ClassLoader>> tlMap = new ThreadLocal();
    private static NewJRLClassLoader myImpl = null;
    private static final NOPEnumeration NOP_ENUM = new NOPEnumeration();
    private static final NOPParent NOP_PARENT = new NOPParent();
    private static final URLClassLoader NOP_LOADER = new URLClassLoader(new URL[0], (ClassLoader)NOP_PARENT);
    private static final boolean DISABLE_JRL = LoaderUtil.getDisableJRLBoolean();
    private static final String JRL_RESOURCE_NAME = "oracle/jdeveloper/java/util/JRLClassLoader.class";
    private static final String MY_IMPL_CLASS_NAME = "oracle.adf.share.common.rc.util.impl.LoaderUtilImpl";
    private static final boolean JRL_AVAILABLE = ClassUtils.getClassLoader(LoaderUtil.class).getResource("oracle/jdeveloper/java/util/JRLClassLoader.class") != null;

    public static ClassLoader getLoader(URL[] urls, ClassLoader parent) {
        urls = LoaderUtil.cleanURLs(urls);
        if (parent == null) {
            parent = NOP_PARENT;
            if (urls.length == 1 && LoaderUtil.isTLCacheActive()) {
                return LoaderUtil.getAndCacheLoader(urls, parent);
            }
        }
        return LoaderUtil.justGetLoader(urls, parent);
    }

    static URL[] cleanURLs(URL[] urls) {
        if (urls == null) {
            urls = new URL[]{};
        } else {
            try {
                urls = URLUtil.getURLForPath(urls);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return urls;
    }

    private static ClassLoader justGetLoader(URL[] urls, ClassLoader parent) {
        if (!(urls != null && urls.length != 0 || parent != null && parent != NOP_PARENT)) {
            return NOP_LOADER;
        }
        if (myImpl == null && (DISABLE_JRL || !JRL_AVAILABLE)) {
            return new URLClassLoader(URLUtil.stripCleanedURLs(urls), parent);
        }
        return LoaderUtil.newJRLClassLoader(urls, parent);
    }

    public static ClassLoader getAndCacheLoader(URL[] urls, ClassLoader parent) {
        if (!LoaderUtil.isTLCacheActive()) {
            throw new IllegalStateException("Must activate the TLCache first");
        }
        String mapKey = LoaderUtil.getTLCacheKey(urls, parent);
        ClassLoader ldr = tlMap.get().get(mapKey);
        if (ldr == null) {
            ldr = LoaderUtil.justGetLoader(urls, parent);
            tlMap.get().put(mapKey, ldr);
        }
        return ldr;
    }

    private static String getTLCacheKey(URL[] urls, ClassLoader parent) {
        StringBuilder mapKey = new StringBuilder();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                String k = urls[i].toString();
                int x = k.indexOf(58);
                if (x != -1) {
                    String proto = k.substring(0, x);
                    if (!ADFJarUtil.isJarProtocol(urls[i]) && !proto.equals("zip") && URLUtil.getArchiveExtension(k) != null) {
                        k = "jar:" + k + "!/";
                    }
                }
                mapKey.append("@" + k.hashCode());
            }
        }
        mapKey.append("@" + String.valueOf(parent).hashCode());
        return mapKey.toString();
    }

    public static boolean activateTLCache() {
        if (LoaderUtil.isTLCacheActive()) {
            return false;
        }
        tlMap.set(new HashMap(4));
        return true;
    }

    public static void clearTLCache() {
        tlMap.remove();
    }

    public static boolean isTLCacheActive() {
        return tlMap.get() != null;
    }

    public static void dumpClassLoaderHierarchy(ClassLoader loader, StringBuilder buf, String prefix, String incr) {
        ClassLoader sysCL;
        ClassLoader classLoader = loader != null ? loader.getSystemClassLoader() : (sysCL = null);
        while (loader != null) {
            String appe = sysCL == loader ? " (sysCL)" : "";
            buf.append(prefix + loader + appe + "\n");
            prefix = incr + prefix;
            loader = loader.getParent();
        }
    }

    public static ClassLoader getNOPParent() {
        return NOP_PARENT;
    }

    private static ClassLoader newJRLClassLoader(URL[] urls, ClassLoader parent) {
        if (myImpl == null) {
            try {
                myImpl = (NewJRLClassLoader)ClassUtils.forName(MY_IMPL_CLASS_NAME, LoaderUtil.class).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return myImpl.newJRLClassLoader(urls, parent);
    }

    private static final boolean getDisableJRLBoolean() {
        boolean jrlEnabled = false;
        boolean jrlDisabled = true;
        try {
            String disableJRL = System.getProperty("oracle.adf.share.common.rc.util.disableJRL");
            if (disableJRL != null) {
                return "true".equalsIgnoreCase(disableJRL);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        PlatformUtil pu = new PlatformUtil();
        return !pu.useURLFileSystem();
    }

    private static class NOPEnumeration
    implements Enumeration {
        private NOPEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }

    private static class NOPParent
    extends ClassLoader {
        private NOPParent() {
        }

        @Override
        protected URL findResource(String name) {
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return NOP_ENUM;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }

        @Override
        public URL getResource(String name) {
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return NOP_ENUM;
        }
    }

    public static interface NewJRLClassLoader {
        public ClassLoader newJRLClassLoader(URL[] var1, ClassLoader var2);
    }
}

