/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.rc.util.impl.LoaderUtilImpl;
import oracle.adf.share.common.util.ADFJarUtil;

public class URLUtil {
    private static Logger logger = Logger.getLogger(LoaderUtilImpl.class.getName());
    private static final boolean isFineLogging = logger.isLoggable(Level.FINE);
    private static final boolean isFinestLogging = logger.isLoggable(Level.FINEST);
    private static final String FILE = "file";
    private static final String JAR = "jar";
    private static final String ZIP = "zip";
    private static final String CS = "code-source";
    private static final char BANG = '!';
    private static final char COLON = ':';
    private static final String SLASH = "/";
    private static final String JAR_COLON = "jar:";
    private static final String JAR_FILE = "jar:file";
    private static final String DOT_JAR = ".jar";
    private static final String DOT_ZIP = ".zip";

    private URLUtil() {
    }

    public static String getArchiveExtension(String urlStr) {
        if (urlStr.endsWith(DOT_JAR)) {
            return JAR;
        }
        if (urlStr.endsWith(DOT_ZIP)) {
            return ZIP;
        }
        int x = urlStr.lastIndexOf(33);
        if (x != -1) {
            urlStr = urlStr.substring(0, x);
        }
        if ((x = urlStr.lastIndexOf(47)) == -1 || x + 1 == urlStr.length()) {
            return null;
        }
        String fn = urlStr.substring(x + 1);
        if ((x = fn.lastIndexOf(46)) == -1 || x + 1 == fn.length()) {
            return null;
        }
        String ext = fn.substring(x + 1).toLowerCase();
        return ext.equals(JAR) || ext.equals(ZIP) ? ext : null;
    }

    public static URL[] getURLForPath(URL[] urls) throws MalformedURLException {
        URL[] utmp = new URL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            utmp[i] = URLUtil.getURLForPath(urls[i]);
            if (!isFineLogging) continue;
            URL url = utmp[i];
            String proto = url.getProtocol();
            if (!ADFJarUtil.isJarProtocol(url) && !FILE.equals(proto)) {
                logger.fine(url.toString());
                continue;
            }
            if (!isFinestLogging) continue;
            logger.finest(url.toString());
        }
        return utmp;
    }

    private static boolean needsFileProto(String proto) {
        if (proto.startsWith(SLASH)) {
            return true;
        }
        return !proto.equalsIgnoreCase(FILE);
    }

    public static URL getURLForPath(URL url) throws MalformedURLException {
        return URLUtil.getURLForPath(url, true);
    }

    public static URL getURLForPath(URL url, boolean fixDirSlash) throws MalformedURLException {
        int bang;
        if (ADFJarUtil.isJarProtocol(url)) {
            return url;
        }
        String proto = url.getProtocol();
        URL ret = url;
        String urlStr = url.toString();
        int protoLen = proto.length();
        boolean needsFileProto = false;
        int colon2 = -1;
        if (!proto.equals(FILE) && (colon2 = urlStr.indexOf(58, protoLen + 1)) != -1) {
            String proto2 = urlStr.substring(protoLen + 1, colon2);
            needsFileProto = URLUtil.needsFileProto(proto2);
        }
        if ((bang = urlStr.lastIndexOf(33)) != -1) {
            if (bang == urlStr.length() - 1) {
                urlStr = urlStr + SLASH;
            }
            ret = proto.equals(CS) || proto.equals(ZIP) ? (colon2 == -1 || needsFileProto ? new URL(JAR_FILE + urlStr.substring(protoLen)) : new URL(JAR + urlStr.substring(protoLen))) : new URL(JAR_COLON + urlStr);
            return ret;
        }
        String archiveExt = URLUtil.getArchiveExtension(urlStr);
        if (archiveExt != null) {
            ret = proto.equals(CS) || proto.equals(ZIP) ? (colon2 == -1 || needsFileProto ? new URL(JAR_FILE + urlStr.substring(protoLen) + "!/") : new URL(JAR + urlStr.substring(protoLen) + "!/")) : new URL(JAR_COLON + urlStr + "!/");
            return ret;
        }
        if (proto.equals(CS) && (colon2 == -1 || needsFileProto)) {
            urlStr = FILE + urlStr.substring(protoLen);
            ret = new URL(urlStr);
        }
        if (fixDirSlash && !urlStr.endsWith(SLASH)) {
            ret = new URL(urlStr + SLASH);
        }
        return ret;
    }

    public static URL[] stripCleanedURLs(URL[] urls) {
        URL[] retUrls = new URL[urls.length];
        int i = 0;
        for (URL url : urls) {
            if (ADFJarUtil.isJarProtocol(url)) {
                String path = url.getPath();
                int x = path.lastIndexOf(33);
                if (x != -1) {
                    path = path.substring(0, x);
                }
                try {
                    retUrls[i++] = new URL(path);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            retUrls[i++] = url;
        }
        return retUrls;
    }
}

