/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.connection;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.adf.share.connection.ConnectionType;
import oracle.adf.share.connection.ConnectionTypeLoader;
import oracle.adf.share.connection.ConnectionTypeRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ManifestConnectionTypeLoader
implements ConnectionTypeLoader {
    private static final String MANIFEST_NAME = "META-INF/rc_ext.xml";
    private static final String CTYPE_ELEMENT = "connection-type";
    private static final String CTYPE_CLASS_ATTR = "class";
    private static final String CTYPE_ID_ATTR = "id";
    private static final String SOURCE_CLASS = ManifestConnectionTypeLoader.class.getName();
    private static final String PROCESS_MANIFESTS = "processManifests()";
    private static final String PROCESS_DOCUMENT = "processDocument()";
    private static final String NAMESPACE_URI = "http://xmlns.oracle.com/adf/rc/extension";
    private static final String resourceBundle = "oracle.adf.share.connection.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.connection.resources.Messages");
    private Object mLock = new Object();
    private Logger mLogger = Logger.getLogger("oracle.adf.share.connection");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadConnectionTypes(ConnectionTypeRegistry registry, ClassLoader sourceLoader) {
        Object object = this.mLock;
        synchronized (object) {
            Enumeration<URL> extensions = null;
            try {
                extensions = sourceLoader.getResources(MANIFEST_NAME);
            }
            catch (IOException ioe) {
                this.mLogger.logp(Level.SEVERE, SOURCE_CLASS, PROCESS_MANIFESTS, resBundle.getString("ERROR_LOCATING_EXTENSIONS"), ioe);
            }
            if (extensions == null) {
                this.mLogger.logp(Level.WARNING, SOURCE_CLASS, PROCESS_MANIFESTS, resBundle.getString("CONNTYPE_NOTFOUND"));
                return;
            }
            while (extensions.hasMoreElements()) {
                URL manifestUrl = null;
                try {
                    manifestUrl = extensions.nextElement();
                    InputStream is = manifestUrl.openStream();
                    Document doc = this.parse(is);
                    this.processDocument(registry, doc, sourceLoader);
                }
                catch (Exception e) {
                    this.mLogger.logp(Level.WARNING, SOURCE_CLASS, PROCESS_MANIFESTS, resBundle.getString("ERROR_PROCESSING_EXTENSION"), new Object[]{manifestUrl.getPath()});
                }
            }
        }
    }

    private Document parse(InputStream is) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = null;
        try {
            doc = db.parse(is);
        }
        catch (Exception e) {
            // empty catch block
        }
        return doc;
    }

    public void processDocument(ConnectionTypeRegistry registry, Document doc, ClassLoader sourceLoader) {
        NodeList connTypeNodes = doc.getElementsByTagNameNS(NAMESPACE_URI, CTYPE_ELEMENT);
        for (int i = 0; i < connTypeNodes.getLength(); ++i) {
            Element connTypeEl = (Element)connTypeNodes.item(i);
            String typeId = connTypeEl.getAttribute(CTYPE_ID_ATTR);
            String className = connTypeEl.getAttribute(CTYPE_CLASS_ATTR);
            try {
                Class<?> typeClass = Class.forName(className, true, sourceLoader);
                ConnectionType type = (ConnectionType)typeClass.newInstance();
                registry.register(type);
                continue;
            }
            catch (Exception e) {
                this.mLogger.logp(Level.WARNING, SOURCE_CLASS, PROCESS_DOCUMENT, MessageFormat.format(resBundle.getString("FAILED_REGISTRATION"), typeId), e);
            }
        }
    }
}

