/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.diagnostic;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.logging.ADFLoggerConstants;
import oracle.dms.context.ExecutionContext;
import sun.security.action.GetPropertyAction;

public class ConsoleFormatter
extends Formatter {
    private static String messageType = System.getProperty("oracle.adfdiagnostics.ConsoleFormatter.ShowLevel");
    private static String timeStamp = System.getProperty("oracle.adfdiagnostics.ConsoleFormatter.ShowTimeStamp");
    private static boolean showMessageType = messageType != null && messageType.toUpperCase().equals("TRUE");
    private static boolean showTimeStamp = timeStamp != null && timeStamp.toUpperCase().equals("TRUE");
    private static Object[] compKeys = ADFLoggerConstants.getADFComponents().keySet().toArray();
    private static Map<String, String> comps = ADFLoggerConstants.getADFComponents();
    ADFLogger diaglogger = ADFLogger.createADFLogger(ConsoleFormatter.class.getName());
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    ThreadLocal<RecursionCounter> m_recursionCounter = new ThreadLocal<RecursionCounter>(){

        @Override
        protected RecursionCounter initialValue() {
            return new RecursionCounter(ConsoleFormatter.this.m_maxRecursionDepth, ConsoleFormatter.this.m_maxInternalRecursionDepth);
        }
    };
    private final int m_maxRecursionDepth;
    private final int m_maxInternalRecursionDepth;

    public ConsoleFormatter() {
        this.m_maxRecursionDepth = 2;
        this.m_maxInternalRecursionDepth = 0;
    }

    private String getShortClassName(String clazz) {
        if (clazz == null) {
            return clazz;
        }
        String[] segs = clazz.split("\\.");
        return segs[segs.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String format(LogRecord rec) {
        String sbr = "";
        RecursionCounter counter = this.m_recursionCounter.get();
        if (!counter.isLoggable()) {
            if (!counter.isInternalCtx()) {
                // empty if block
            }
            StringBuffer sb = new StringBuffer();
            return this.formatNonSupplAttrLogRecord(rec, sb).toString();
        }
        try {
            counter.enter();
            sbr = this.format(rec, counter);
        }
        finally {
            counter.exit();
        }
        return sbr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(LogRecord record, RecursionCounter counter) {
        StringBuffer sb = new StringBuffer();
        String logger = record.getLoggerName();
        String component = "";
        String adfDetails = "";
        String componentName = "";
        Map execContext = null;
        boolean isInternalCtx = counter != null ? counter.enterInternalCtx() : false;
        try {
            if (!isInternalCtx) {
                ExecutionContext ctx = ExecutionContext.get((boolean)false);
                if (ctx != null) {
                    execContext = ctx.getAllValues();
                    if (execContext.containsKey("ADF_MESSAGE_STATUS") && !((String)execContext.get("ADF_MESSAGE_STATUS")).equals("end")) {
                        int compIndex;
                        if (execContext.containsKey("ADF_MESSAGE_CONTEXT_DATA") && (compIndex = (componentName = ((String)execContext.get("ADF_MESSAGE_CONTEXT_DATA")).toString()).indexOf("Component=")) != -1) {
                            if (componentName.indexOf("Component=") == 0) {
                                if (componentName.indexOf(";#;") < 0) {
                                    component = this.getADFComponentNameCase1(componentName);
                                    adfDetails = "";
                                } else {
                                    component = this.getADFComponentNameCase2(componentName);
                                    int delimiterIndex = componentName.indexOf(";#;");
                                    if (delimiterIndex == componentName.lastIndexOf(";#;")) {
                                        adfDetails = componentName.substring(delimiterIndex + 3, componentName.length() - 1);
                                    } else {
                                        Pattern pattern = Pattern.compile(";#;(.*?);#;");
                                        Matcher matcher = pattern.matcher(componentName);
                                        if (matcher.find()) {
                                            adfDetails = matcher.group(1);
                                        }
                                    }
                                }
                            } else if (componentName.indexOf("Component=") > 0) {
                                component = componentName.matches(".*;#;Component=.*;#;.*") ? this.getADFComponentNameCase2(componentName) : this.getADFComponentNameCase1(componentName);
                                adfDetails = componentName.substring(0, componentName.indexOf(";#;"));
                            }
                        }
                        if (showTimeStamp) {
                            sb = this.appendLogMessageAttribute(sb, DateFormat.getTimeInstance(1).format(new Date(record.getMillis())).toString());
                        }
                        if (showMessageType) {
                            sb = this.appendLogMessageAttribute(sb, record.getLevel().toString());
                        }
                        if (component != "") {
                            sb = this.appendLogMessageAttribute(sb, component);
                        }
                        sb = this.appendLogMessageAttribute(sb, record.getMessage());
                        if (adfDetails != "") {
                            sb = this.appendLogMessageAttribute(sb, adfDetails);
                        }
                        sb.append(this.lineSeparator);
                    } else if (execContext.containsKey("ADF_MESSAGE_STATUS") && ((String)execContext.get("ADF_MESSAGE_STATUS")).equals("end")) {
                    } else {
                        sb = this.formatNonSupplAttrLogRecord(record, sb);
                    }
                } else {
                    sb = this.formatNonSupplAttrLogRecord(record, sb);
                }
            } else {
                sb = this.formatNonSupplAttrLogRecord(record, sb);
            }
        }
        finally {
            if (counter != null) {
                counter.exitInternalCtx();
            }
        }
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private StringBuffer formatNonSupplAttrLogRecord(LogRecord record, StringBuffer sbrlr) {
        String compName;
        if (showTimeStamp) {
            sbrlr = this.appendLogMessageAttribute(sbrlr, DateFormat.getTimeInstance(1).format(new Date(record.getMillis())).toString());
        }
        if (showMessageType) {
            sbrlr = this.appendLogMessageAttribute(sbrlr, record.getLevel().toString());
        }
        sbrlr = (compName = this.getADFComponentName(record.getSourceClassName())) != null && compName != "" ? this.appendLogMessageAttribute(sbrlr, compName) : this.appendLogMessageAttribute(sbrlr, record.getSourceClassName());
        sbrlr = this.appendLogMessageAttribute(sbrlr, this.getShortClassName(record.getSourceClassName()));
        sbrlr = this.appendLogMessageAttribute(sbrlr, record.getSourceMethodName());
        sbrlr = this.appendLogMessageAttribute(sbrlr, record.getMessage());
        sbrlr.append(this.lineSeparator);
        return sbrlr;
    }

    public String formatDateTime(long timeStamp) {
        return DateFormat.getTimeInstance(1).format(new Date(timeStamp)).toString();
    }

    public StringBuffer appendLogMessageAttribute(StringBuffer buffer, String attribute) {
        return buffer.append("<").append(attribute).append("> ");
    }

    public String getADFComponentNameCase1(String contextMapString) {
        Pattern pattern = Pattern.compile("Component=(.*?)$");
        Matcher matcher = pattern.matcher(contextMapString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public String getADFComponentNameCase2(String contextMapString) {
        Pattern pattern = Pattern.compile("Component=(.*?);#;");
        Matcher matcher = pattern.matcher(contextMapString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public String getADFComponentName(String className) {
        String ADFComponent = "";
        if (className != null && className != "") {
            for (int i = 0; i < compKeys.length; ++i) {
                if (className.indexOf(compKeys[i].toString()) <= 0) continue;
                ADFComponent = comps.get(compKeys[i]);
                break;
            }
        }
        return ADFComponent;
    }

    static final class RecursionCounter {
        private int count = 0;
        private int ctxCount = 0;
        private final int m_maxRecursionDepth;
        private final int m_maxInternalRecursionDepth;

        RecursionCounter(int maxRecursionDepth, int maxInternalRecursionDepth) {
            this.m_maxRecursionDepth = maxRecursionDepth;
            this.m_maxInternalRecursionDepth = maxInternalRecursionDepth;
        }

        void enter() {
            ++this.count;
        }

        void exit() {
            --this.count;
        }

        boolean enterInternalCtx() {
            ++this.ctxCount;
            return this.ctxCount > 1;
        }

        void exitInternalCtx() {
            --this.ctxCount;
        }

        boolean isLoggable() {
            return this.count <= this.m_maxRecursionDepth && this.ctxCount <= this.m_maxInternalRecursionDepth;
        }

        boolean isInternalCtx() {
            return this.ctxCount > 0;
        }
    }
}

