/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform;

import java.lang.reflect.Method;
import java.sql.Connection;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.platform.AdfAbstractSupport;
import oracle.adf.share.platform.UnknownPlatformException;
import oracle.jrf.ApplicationIdentifier;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public abstract class AdfServerPlatformSupport
extends AdfAbstractSupport {
    public static final String CLUSTER_UNKNOWN = "cluster_unknown";
    private ADFLogger logger = ADFLogger.createADFLogger(AdfServerPlatformSupport.class);

    public String getClusterName() throws PortabilityLayerException {
        Object svrcomp = this.getConcretePlatformSupport();
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getClusterName();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10027"));
    }

    public byte[] getCheckSum(String algorithm, byte[] data) throws Exception {
        return new byte[0];
    }

    protected abstract Object getConcretePlatformSupport() throws PortabilityLayerException;

    public String getPlatformName() {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getPlatformName();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public ApplicationIdentifier getApplicationIdentifier() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getApplicationIdentifier();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public Connection getNativeDBConnection(Connection datasourceJdbcConnection, Class targetUnwrapClass) {
        try {
            ClassLoader cl = ClassUtils.getClassLoader(AdfServerPlatformSupport.class);
            Class localUnwrapClass = cl.loadClass("oracle.jdbc.OracleConnection");
            if (targetUnwrapClass != null) {
                localUnwrapClass = targetUnwrapClass;
            }
            Method meth1 = datasourceJdbcConnection.getClass().getMethod("isWrapperFor", Class.class);
            Boolean isWrappable = (Boolean)meth1.invoke((Object)datasourceJdbcConnection, localUnwrapClass);
            if (isWrappable.booleanValue()) {
                Method meth2 = datasourceJdbcConnection.getClass().getMethod("unwrap", Class.class);
                return (Connection)meth2.invoke((Object)datasourceJdbcConnection, localUnwrapClass);
            }
        }
        catch (Throwable e) {
            this.logger.warning(e);
        }
        return datasourceJdbcConnection;
    }

    public String[] getSupportedPlatformNames() {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            String[] pms = ((ServerPlatformSupport)svrcomp).getSupportedPlatformNames();
            int len = pms.length;
            String[] platforms = new String[len + 1];
            System.arraycopy(pms, 0, platforms, 0, len);
            platforms[len] = AdfAbstractSupport.PLATFORM_TYPE.GLASSFISH_PLATFORM.toString();
            return platforms;
        }
        return new String[]{AdfAbstractSupport.PLATFORM_TYPE.WEBLOGIC_PLATFORM.toString(), AdfAbstractSupport.PLATFORM_TYPE.WEBSPHERE_PLATFORM.toString(), AdfAbstractSupport.PLATFORM_TYPE.JBOSS_PLATFORM.toString(), AdfAbstractSupport.PLATFORM_TYPE.GLASSFISH_PLATFORM.toString()};
    }

    public String getAdminServerName() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getAdminServerName();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public String getServerName() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getServerName();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public String getServerLogPath() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getServerLogPath();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public boolean isAdminServer() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).isAdminServer();
        }
        return false;
    }

    public static boolean isWebLogic() {
        return System.getProperty("weblogic.Name") != null;
    }

    public static boolean isWebSphere() {
        return System.getProperty("was.install.root") != null || System.getProperty("server.root") != null;
    }

    public boolean isWebSphereND() {
        if (AdfServerPlatformSupport.isWebSphere()) {
            try {
                Class<?> clazz = Class.forName("oracle.jrf.was.WasServerPlatformSupport");
                Method method = clazz.getMethod("isND", new Class[0]);
                Boolean ret = (Boolean)method.invoke(null, new Object[0]);
                return ret;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isWebSphereAS() {
        if (AdfServerPlatformSupport.isWebSphere()) {
            try {
                return !this.isWebSphereND();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isJBoss() {
        return System.getProperty("jboss.home.dir") != null;
    }

    public static boolean isJEE() {
        boolean isjee = false;
        isjee = AdfServerPlatformSupport.isWebLogic() || AdfServerPlatformSupport.isWebSphere() || AdfServerPlatformSupport.isTomcat() || AdfServerPlatformSupport.isJBoss() || AdfServerPlatformSupport.isGlassFish();
        return isjee;
    }

    public static boolean isGlassFish() {
        return System.getProperty("glassfish.version") != null;
    }

    public static boolean isTomcat() {
        return (System.getProperty("catalina.home") != null || System.getProperty("catalina.base") != null) && System.getProperty("glassfish.version") == null;
    }

    public String getServerConfigDirectory(String domainName, String serverName) throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getServerConfigDirectory(domainName, serverName);
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public String getDomainConfigDirectory() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getDomainConfigDirectory();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public String getServerConfigDirectory() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getServerConfigDirectory();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public String getDomainName() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getDomainName();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public PortConfig getPortConfig() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getPortConfig();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public PortConfig getPortConfig(String serverId) throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getPortConfig(serverId);
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public boolean isExalogicOptimizationsEnabled() {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).isExalogicOptimizationsEnabled();
        }
        return false;
    }

    public String getCommonComponentsHome() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            this.logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getCommonComponentsHome();
        }
        throw new oracle.jrf.UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }
}

