/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ResourceBundle;
import oracle.adf.share.platform.resources.ADFPlatformMessageBundle;

public class AdfServerPlatformUtil {
    private static ResourceBundle platformRes = ResourceBundle.getBundle(ADFPlatformMessageBundle.class.getName());

    public static boolean isWebLogic() {
        return AdfServerPlatformUtil.getSystemProperty("weblogic.Name") != null;
    }

    public static boolean isWebSphere() {
        return AdfServerPlatformUtil.getSystemProperty("was.install.root") != null || AdfServerPlatformUtil.getSystemProperty("server.root") != null;
    }

    public static boolean isWebSphereND() {
        if (AdfServerPlatformUtil.isWebSphere()) {
            try {
                Class<?> clazz = Class.forName("oracle.jrf.was.WasServerPlatformSupport");
                Method method = clazz.getMethod("isND", new Class[0]);
                Boolean ret = (Boolean)method.invoke(null, new Object[0]);
                return ret;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isWebSphereAS() {
        if (AdfServerPlatformUtil.isWebSphere()) {
            try {
                return !AdfServerPlatformUtil.isWebSphereND();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isJBoss() {
        return AdfServerPlatformUtil.getSystemProperty("jboss.home.dir") != null;
    }

    public static boolean isJEE() {
        boolean isjee = false;
        isjee = AdfServerPlatformUtil.isWebLogic() || AdfServerPlatformUtil.isWebSphere() || AdfServerPlatformUtil.isTomcat() || AdfServerPlatformUtil.isJBoss() || AdfServerPlatformUtil.isGlassFish();
        return isjee;
    }

    public static boolean isGlassFish() {
        return AdfServerPlatformUtil.getSystemProperty("glassfish.version") != null;
    }

    public static boolean isTomcat() {
        return (AdfServerPlatformUtil.getSystemProperty("catalina.home") != null || AdfServerPlatformUtil.getSystemProperty("catalina.base") != null) && AdfServerPlatformUtil.getSystemProperty("glassfish.version") == null;
    }

    private static Class loadOracleChecksum(ClassLoader cl) throws Exception {
        Class<?> clazz = null;
        try {
            if (cl != null) {
                clazz = Class.forName("oracle.security.misc.Checksum", true, cl);
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            clazz = AdfServerPlatformUtil.loadOracleChecksum(cl.getParent());
        }
        return clazz;
    }

    public static byte[] getCheckSum(String algorithm, byte[] data) throws Exception {
        Class clazz;
        if (data == null) {
            return new byte[0];
        }
        if (algorithm == null) {
            algorithm = "MD5";
        }
        if ((clazz = AdfServerPlatformUtil.loadOracleChecksum(Thread.currentThread().getContextClassLoader())) == null) {
            return new byte[0];
        }
        Method checkSumMethod = null;
        if (algorithm.toUpperCase().equals("MD5")) {
            checkSumMethod = clazz.getMethod("MD5", byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, new Object[]{data, null});
            }
        } else if (algorithm.toUpperCase().equals("SHA")) {
            checkSumMethod = clazz.getMethod("SHA", byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, new Object[]{data, null});
            }
        } else if (algorithm.toUpperCase().equals("MD2")) {
            checkSumMethod = clazz.getMethod("MD2", byte[].class, byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, data, null, null);
            }
        } else if (algorithm.toUpperCase().equals("MD4")) {
            checkSumMethod = clazz.getMethod("MD4", byte[].class, byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, data, null, null);
            }
        } else {
            throw new NoSuchAlgorithmException(algorithm + " " + platformRes.getString("CHECKSUM_ALGORITHM_NOT_SUPPORTED"));
        }
        return new byte[0];
    }

    public static String getSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    public static String setSystemProperty(final String name, final String value) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.setProperty(name, value);
            }
        });
    }

    public static String clearSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.clearProperty(name);
            }
        });
    }
}

