/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform.glassfish;

import com.sun.enterprise.config.serverbeans.Domain;
import java.io.File;
import javax.naming.InitialContext;
import oracle.adf.share.common.util.ADFPropertiesUtil;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.platform.AdfAbstractSupport;
import oracle.adf.share.platform.AdfGenericPlatformSecurityUtil;
import oracle.adf.share.platform.AdfServerPlatformSupport;
import oracle.jrf.ApplicationIdentifier;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import org.glassfish.internal.api.Globals;

public class GlassFishAdfServerPlatformSupport
extends AdfServerPlatformSupport {
    private static final String GF_DOMAIN_ROOT_PATH_VAR = "com.sun.aas.domainsRoot";
    private static final String GF_SERVER_INSTANCE_PATH_VAR = "com.sun.aas.instanceRoot";
    private static final String GF_INSTALL_PATH_VAR = "com.sun.aas.installRoot";
    private static final String GF_SERVER_NAME_VAR = "com.sun.aas.instanceName";
    private static final String GF_HOST_NAME_VAR = "com.sun.aas.hostName";
    private static final String DEFAULT_ADMIN_SERVER_NAME = "server";
    private static final String DEFAULT_DOMAIN_NAME = "domain1";
    private ADFLogger logger = ADFLogger.createADFLogger(GlassFishAdfServerPlatformSupport.class);
    private static ThreadLocal<String> appNameOverride = new ThreadLocal();

    @Override
    public Object getConcretePlatformSupport() throws PortabilityLayerException {
        return null;
    }

    @Override
    public byte[] getCheckSum(String algorithm, byte[] data) throws Exception {
        return AdfGenericPlatformSecurityUtil.getCheckSum(algorithm, data);
    }

    @Override
    public String getPlatformName() {
        return AdfAbstractSupport.PLATFORM_TYPE.GLASSFISH_PLATFORM.toString();
    }

    @Override
    public String getServerName() throws PortabilityLayerException {
        String serverName = ADFPropertiesUtil.getSystemProperty(GF_SERVER_NAME_VAR);
        return serverName;
    }

    private String getApplicationName() throws PortabilityLayerException {
        String applicationName = appNameOverride.get();
        if (applicationName == null || applicationName.length() == 0) {
            try {
                applicationName = (String)new InitialContext().lookup("java:app/AppName");
            }
            catch (Exception e) {
                throw new PortabilityLayerException(e);
            }
        }
        return applicationName;
    }

    public static void setApplicationNameOverride(String appName) {
        appNameOverride.set(appName);
    }

    @Override
    public ApplicationIdentifier getApplicationIdentifier() throws PortabilityLayerException {
        String appName = this.getApplicationName();
        return new ApplicationIdentifier(appName, appName, null);
    }

    @Override
    public String getAdminServerName() throws PortabilityLayerException {
        return DEFAULT_ADMIN_SERVER_NAME;
    }

    @Override
    public String getServerLogPath() throws PortabilityLayerException {
        String serverDir = ADFPropertiesUtil.getSystemProperty(GF_SERVER_INSTANCE_PATH_VAR);
        return serverDir + File.separator + "logs";
    }

    @Override
    public boolean isAdminServer() throws PortabilityLayerException {
        return ADFPropertiesUtil.getSystemProperty(GF_SERVER_NAME_VAR).equals(DEFAULT_ADMIN_SERVER_NAME);
    }

    @Override
    public String getServerConfigDirectory(String domainName, String serverName) throws PortabilityLayerException {
        return this.getServerConfigDirectory();
    }

    @Override
    public String getDomainConfigDirectory() throws PortabilityLayerException {
        String domainRootDir = ADFPropertiesUtil.getSystemProperty(GF_DOMAIN_ROOT_PATH_VAR);
        String domainName = this.getDomainName();
        return domainRootDir + File.separator + domainName + File.separator + "config";
    }

    @Override
    public String getServerConfigDirectory() throws PortabilityLayerException {
        String serverDir = ADFPropertiesUtil.getSystemProperty(GF_SERVER_INSTANCE_PATH_VAR);
        return serverDir + File.separator + "config";
    }

    @Override
    public String getDomainName() throws PortabilityLayerException {
        Domain d = (Domain)Globals.getDefaultHabitat().getComponent(Domain.class);
        if (d != null) {
            return d.getName();
        }
        return DEFAULT_DOMAIN_NAME;
    }

    @Override
    public PortConfig getPortConfig() throws PortabilityLayerException {
        throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10027"));
    }

    @Override
    public PortConfig getPortConfig(String serverId) throws PortabilityLayerException {
        throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10027"));
    }

    @Override
    public String getCommonComponentsHome() throws PortabilityLayerException {
        throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10027"));
    }

    @Override
    public boolean isExalogicOptimizationsEnabled() {
        return false;
    }
}

