/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform.websphere;

import java.lang.reflect.Method;
import java.sql.Connection;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.platform.AdfServerPlatformSupport;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class WASAdfServerPlatformSupport
extends AdfServerPlatformSupport {
    private ADFLogger logger = ADFLogger.createADFLogger(WASAdfServerPlatformSupport.class);
    protected ServerPlatformSupport svrcomp = null;

    public WASAdfServerPlatformSupport() throws PortabilityLayerException {
        this.getConcretePlatformSupport();
    }

    @Override
    public Object getConcretePlatformSupport() throws PortabilityLayerException {
        if (this.svrcomp == null) {
            try {
                this.svrcomp = this.isWebSphereND() ? (ServerPlatformSupport)Class.forName("oracle.jrf.was.WasNDJrfInternalPlatform").newInstance() : (ServerPlatformSupport)Class.forName("oracle.jrf.was.WasASJrfInternalPlatform").newInstance();
            }
            catch (Exception ex) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10021", new String[]{ex.getMessage()}), ex);
            }
        }
        return this.svrcomp;
    }

    public WASAdfServerPlatformSupport(ServerPlatformSupport svr) {
        this.svrcomp = svr;
    }

    @Override
    public byte[] getCheckSum(String algorithm, byte[] data) throws Exception {
        return AdfServerPlatformUtil.getCheckSum(algorithm, data);
    }

    @Override
    public Connection getNativeDBConnection(Connection datasourceJdbcConnection, Class targetUnwrapClass) {
        try {
            ClassLoader cl = ClassUtils.getClassLoader(WASAdfServerPlatformSupport.class);
            Class<?> WSJdbcUtilCls = cl.loadClass("com.ibm.ws.rsadapter.jdbc.WSJdbcUtil");
            Class<?> WSJdbcConnectionCls = cl.loadClass("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection");
            if (WSJdbcConnectionCls.isAssignableFrom(datasourceJdbcConnection.getClass())) {
                Method getNativeConnection = WSJdbcUtilCls.getMethod("getNativeConnection", WSJdbcConnectionCls);
                return (Connection)getNativeConnection.invoke(null, datasourceJdbcConnection);
            }
            return datasourceJdbcConnection;
        }
        catch (Throwable e) {
            this.logger.info(e);
            return datasourceJdbcConnection;
        }
    }
}

