/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.jndi;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import oracle.ide.util.Assert;
import oracle.javatools.jndi.LocalInitialContextFactory;

public class LocalInitialContextFactoryBuilder
implements InitialContextFactoryBuilder {
    public static String INITIAL_CONTEXT_FACTORY_LOADER = "oracle.javatools.jndi.factorybuilder.loader";
    LocalInitialContextFactory ic = new LocalInitialContextFactory();

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> env) throws NamingException {
        String className;
        Object initialContextFactory = env.get("java.naming.factory.initial");
        if (LocalInitialContextFactory.class.getName().equals(initialContextFactory)) {
            return this.ic;
        }
        String string = className = env != null ? (String)env.get("java.naming.factory.initial") : null;
        if (className == null) {
            NoInitialContextException ne = new NoInitialContextException("Need to specify class name in environment or system property, or as an applet parameter, or in an application resource file:  java.naming.factory.initial");
            throw ne;
        }
        try {
            ClassLoader cl = (ClassLoader)env.get(INITIAL_CONTEXT_FACTORY_LOADER);
            if (cl == null) {
                return this.createInitialFactoryWithDefaults(className, env);
            }
            return this.createInitialFactoryWithLoader(className, cl);
        }
        catch (Throwable e) {
            this.throwNoInitialContextException(className, e);
            return null;
        }
    }

    private InitialContextFactory createInitialFactoryWithDefaults(String className, Hashtable<?, ?> env) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader tCL = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = env.get("bug13425354.threadfirst") != null ? tCL : this.getClass().getClassLoader();
        try {
            return this.createInitialFactoryWithLoader(className, cl);
        }
        catch (ClassNotFoundException cnf) {
            ClassLoader myCL = Thread.currentThread().getContextClassLoader();
            if (cl.equals(myCL)) {
                throw cnf;
            }
            InitialContextFactory instance = this.createInitialFactoryWithLoader(className, myCL);
            Assert.printStackTrace((String)"JDeveloper modules should be a registered buddy of oracle.javatools-jndi-local rather than using the context class loader");
            return instance;
        }
    }

    private InitialContextFactory createInitialFactoryWithLoader(String className, ClassLoader cl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return (InitialContextFactory)cl.loadClass(className).newInstance();
    }

    private final void throwNoInitialContextException(String className, Throwable e) throws NoInitialContextException {
        NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + className);
        if (e != null) {
            ne.setRootCause(e);
        }
        throw ne;
    }
}

