/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.demo.XMLEditorDemo;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.gui.demo.DemoXmlContext;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.FindHighlightPlugin;

public final class XMLDemoActions {
    public static final String newActionName = "new-document";
    public static final String openActionName = "open-document";
    public static final String saveActionName = "save-document";
    public static final String saveAsActionName = "saveas-document";
    public static final String undoActionName = "undo-edit";
    public static final String redoActionName = "redo-edit";
    public static final String exitActionName = "exit-program";
    public static final String findActionName = "find";
    public static final String findAgainActionName = "find-again";
    public static final String manageSchemaActionName = "manage-schemas";
    public static final String proxyActionName = "proxy";
    private XMLEditorDemo editorDemo;
    private HashMap actionMap;
    private UndoSupport _undoSupport;
    private static String searchText = "";
    private static boolean fromStart = false;
    private static boolean matchCase = false;
    private static boolean wholeWordOnly = false;
    private static boolean searchForward = true;
    private static boolean highlightAll = true;
    private static boolean wrapAround = true;

    public XMLDemoActions(XMLEditorDemo editorDemo) {
        this.editorDemo = editorDemo;
        this.actionMap = new HashMap();
        AbstractAction action = new NewAction();
        this.addAction(newActionName, action);
        action = new OpenAction();
        this.addAction(openActionName, action);
        action = new SaveAction();
        this.addAction(saveActionName, action);
        action = new SaveAsAction();
        this.addAction(saveAsActionName, action);
        action = new UndoAction();
        this.addAction(undoActionName, action);
        action = new RedoAction();
        this.addAction(redoActionName, action);
        action = new ExitAction();
        this.addAction(exitActionName, action);
        action = new InvokerAction("cut-to-clipboard");
        this.addAction("cut-to-clipboard", action);
        action = new InvokerAction("copy-to-clipboard");
        this.addAction("copy-to-clipboard", action);
        action = new InvokerAction("paste-from-clipboard");
        this.addAction("paste-from-clipboard", action);
        action = new InvokerAction("select-all");
        this.addAction("select-all", action);
        action = new FindAction(findActionName, 1);
        this.addAction(findActionName, action);
        action = new FindAction(findAgainActionName, 2);
        this.addAction(findAgainActionName, action);
        action = new ManageSchemaAction();
        this.addAction(manageSchemaActionName, action);
        action = new ProxyAction();
        this.addAction(proxyActionName, action);
        this._undoSupport = new UndoSupport();
        editorDemo.getEditorPane().addPropertyChangeListener((PropertyChangeListener)this._undoSupport);
        editorDemo.getEditorPane().getDocument().addUndoableEditListener(this._undoSupport);
    }

    public Action findAction(String actionKey) {
        return (Action)this.actionMap.get(actionKey);
    }

    public void addAction(String actionKey, Action action) {
        this.actionMap.put(actionKey, action);
    }

    void save() {
        if (!this.editorDemo.isSaved()) {
            JFileChooser fileChooser = this._createFileChooser();
            int result = fileChooser.showSaveDialog(this.getMainFrame());
            if (result == 0) {
                this.saveFile(fileChooser.getSelectedFile(), false);
            }
        } else {
            this.editorDemo.saveFile(this.editorDemo.getLastFile());
        }
    }

    void saveFile(File file, boolean saveAs) {
        boolean save = true;
        if (file.exists()) {
            String unformatedText = this.editorDemo.getResourceString("FILE_EXISTS");
            String name = null;
            try {
                name = file.getCanonicalPath();
            }
            catch (IOException ioe) {
                name = file.getName();
            }
            Object[] args = new Object[]{name};
            MessageFormat format = new MessageFormat(unformatedText);
            String message = format.format(args);
            String titleKey = saveAs ? "SAVE_ITEM" : "SAVEAS_ITEM";
            String title = this.editorDemo.getResourceString(titleKey);
            if (JOptionPane.showConfirmDialog(this.getMainFrame(), message, title, 0) == 1) {
                save = false;
            }
        }
        if (save) {
            this.editorDemo.saveFile(file);
        } else {
            this.editorDemo.setLastFile(file);
        }
    }

    boolean trySave() {
        boolean ok = true;
        BasicDocument document = (BasicDocument)this.editorDemo.getEditorPane().getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        if (textBuffer.isModified()) {
            File file = this.editorDemo.isSaved() ? this.editorDemo.getLastFile() : null;
            String unformatedText = this.editorDemo.getResourceString("SAVE_CHANGES");
            String name = null;
            try {
                name = file == null ? "untitled.xml" : file.getCanonicalPath();
            }
            catch (IOException ioe) {
                name = file.getName();
            }
            Object[] args = new Object[]{name};
            MessageFormat format = new MessageFormat(unformatedText);
            String message = format.format(args);
            int ret = JOptionPane.showConfirmDialog(this.getMainFrame(), message, null, 1);
            switch (ret) {
                case 0: {
                    this.save();
                    break;
                }
                case 2: {
                    ok = false;
                }
            }
        }
        return ok;
    }

    void updateUndoRedo() {
        Action undoAction = this.findAction(undoActionName);
        undoAction.setEnabled(this._undoSupport.canUndo());
        Action redoAction = this.findAction(redoActionName);
        redoAction.setEnabled(this._undoSupport.canRedo());
    }

    protected BasicEditorPane getEditorPane() {
        return this.editorDemo.getEditorPane();
    }

    protected JFrame getMainFrame() {
        return this.editorDemo.getMainFrame();
    }

    private JFileChooser _createFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        XMLLanguageModule module = new XMLLanguageModule();
        String[] exts = module.getSupportedFileTypes();
        String unformatedText = this.editorDemo.getResourceString("EXT_DESCRIPTION");
        MessageFormat format = new MessageFormat(unformatedText);
        for (int i = 0; i < exts.length; ++i) {
            String ext = exts[i];
            ext = "." + ext;
            Object[] args = new Object[]{ext};
            String desc = format.format(args);
            ExtFilter filter = new ExtFilter(ext, desc);
            fileChooser.addChoosableFileFilter(filter);
        }
        FileFilter[] filters = fileChooser.getChoosableFileFilters();
        fileChooser.setFileFilter(filters[1]);
        fileChooser.setSelectedFile(this.editorDemo.getLastFile());
        return fileChooser;
    }

    private class DisableTextField
    extends JTextField {
        private DisableTextField() {
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.setBackground(enabled ? UIManager.getColor("TextField.background") : UIManager.getColor("control"));
        }
    }

    private class UndoSupport
    extends UndoManager
    implements PropertyChangeListener {
        private UndoSupport() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            super.undoableEditHappened(e);
            XMLDemoActions.this.updateUndoRedo();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("document".equals(name)) {
                Document newD;
                this.discardAllEdits();
                Document old = (Document)e.getOldValue();
                if (old != null) {
                    old.removeUndoableEditListener(this);
                }
                if ((newD = (Document)e.getNewValue()) != null) {
                    newD.addUndoableEditListener(this);
                }
            }
        }
    }

    private class ExtFilter
    extends FileFilter {
        private String _ext;
        private String _desc;

        public ExtFilter(String ext, String desc) {
            this._ext = ext.indexOf(".") == -1 ? "." + ext : ext;
            this._desc = desc;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return name == null ? false : name.indexOf(this._ext) != -1;
        }

        @Override
        public String getDescription() {
            return this._desc;
        }
    }

    public class ProxyAction
    extends AbstractAction {
        public ProxyAction() {
            super(XMLDemoActions.proxyActionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String title = XMLDemoActions.this.editorDemo.getResourceString("PROXY_SERVER_TITLE");
            String proxyString = XMLDemoActions.this.editorDemo.getResourceString("PROXY_SERVER_LABEL");
            String portString = XMLDemoActions.this.editorDemo.getResourceString("PROXY_SERVER_PORT_LABEL");
            char proxyMnemonic = XMLDemoActions.this.editorDemo.getResourceMnemonic("PROXY_SERVER_LABEL_MNEMONIC");
            char portMnemonic = XMLDemoActions.this.editorDemo.getResourceMnemonic("PROXY_SERVER_PORT_MNEMONIC");
            String proxy = System.getProperty("http.proxyHost");
            String port = System.getProperty("http.proxyPort");
            JPanel panel = new JPanel(new BorderLayout(3, 3));
            JLabel proxyLabel = new JLabel(proxyString);
            proxyLabel.setDisplayedMnemonic(proxyMnemonic);
            JTextField proxyField = new JTextField(proxy, 30);
            proxyLabel.setLabelFor(proxyField);
            JPanel proxyPanel = new JPanel(new BorderLayout(3, 3));
            proxyPanel.add("North", proxyLabel);
            proxyPanel.add("Center", proxyField);
            JLabel portLabel = new JLabel(portString);
            portLabel.setDisplayedMnemonic(portMnemonic);
            JTextField portField = new JTextField(port, 5);
            portLabel.setLabelFor(portField);
            JPanel portPanel = new JPanel(new BorderLayout(3, 3));
            portPanel.add("North", portLabel);
            portPanel.add("Center", portField);
            panel.add("Center", proxyPanel);
            panel.add("East", portPanel);
            int button = JOptionPane.showOptionDialog(XMLDemoActions.this.editorDemo.getMainFrame(), panel, title, 2, -1, null, null, null);
            if (button == 0) {
                proxy = proxyField.getText();
                port = portField.getText();
                System.setProperty("http.proxyHost", proxy);
                System.setProperty("http.proxyPort", port);
            }
        }
    }

    public class ManageSchemaAction
    extends AbstractAction {
        private File _lastSchemaFile;

        public ManageSchemaAction() {
            super(XMLDemoActions.manageSchemaActionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String title = XMLDemoActions.this.editorDemo.getResourceString("MANAGE_SCHEMA_TITLE");
            String labelString = XMLDemoActions.this.editorDemo.getResourceString("MANAGE_SCHEMA_LABEL");
            String addLabel = XMLDemoActions.this.editorDemo.getResourceString("MANAGE_SCHEMA_ADD");
            JPanel panel = new JPanel(new BorderLayout(3, 3));
            JLabel label = new JLabel(labelString);
            label.setDisplayedMnemonic(XMLDemoActions.this.editorDemo.getResourceMnemonic("MANAGE_SCHEMA_LABEL_MNEMONIC"));
            panel.add("North", label);
            SchemaGrammarProvider grammarProvider = DemoXmlContext.getSharedGrammarProvider();
            ArrayList grammars = new ArrayList(grammarProvider.getGrammars());
            int rowCount = grammars.size();
            final DefaultTableModel model = new DefaultTableModel(rowCount, 2){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            for (int i = 0; i < rowCount; ++i) {
                Grammar g = (Grammar)grammars.get(i);
                model.setValueAt(g.getTargetNamespace(), i, 0);
                model.setValueAt(g.getLocation(), i, 1);
            }
            JTable table = new JTable(model);
            Dimension prefSize = new Dimension(400, (rowCount + 5) * 20);
            table.setPreferredScrollableViewportSize(prefSize);
            table.getTableHeader().setReorderingAllowed(false);
            String namespace = XMLDemoActions.this.editorDemo.getResourceString("MANAGE_SCHEMA_NAMESPACE_HEADER");
            String location = XMLDemoActions.this.editorDemo.getResourceString("MANAGE_SCHEMA_LOCATION_HEADER");
            table.getColumnModel().getColumn(0).setHeaderValue(namespace);
            table.getColumnModel().getColumn(1).setHeaderValue(location);
            table.getColumnModel().setColumnSelectionAllowed(false);
            table.setRowSelectionAllowed(true);
            JScrollPane scrollPane = new JScrollPane(table);
            label.setLabelFor(table);
            JPanel panel2 = new JPanel(new BorderLayout(3, 3));
            panel2.add("Center", scrollPane);
            JButton addButton = new JButton(addLabel);
            addButton.setMnemonic(XMLDemoActions.this.editorDemo.getResourceMnemonic("MANAGE_SCHEMA_ADD_MNEMONIC"));
            JPanel panel3 = new JPanel(new BorderLayout(3, 3));
            panel3.add("North", addButton);
            JPanel panel4 = new JPanel(new BorderLayout(3, 3));
            panel3.add("Center", panel4);
            panel2.add("East", panel3);
            panel.add("Center", panel2);
            final JOptionPane pane = new JOptionPane(panel, -1, 2, null, null, null);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Set newSchemas = ManageSchemaAction.this._showAddDialog(pane);
                    for (Grammar s : newSchemas) {
                        Object[] data = new Object[]{s.getTargetNamespace(), s.getLocation()};
                        model.addRow(data);
                    }
                }
            });
            int button = this._showOptionDialog(pane, XMLDemoActions.this.editorDemo.getMainFrame(), title);
            switch (button) {
                default: 
            }
        }

        private Set _showAddDialog(Component parentComponent) {
            String title = XMLDemoActions.this.editorDemo.getResourceString("ADD_SCHEMA_TITLE");
            String labelString = XMLDemoActions.this.editorDemo.getResourceString("ADD_SCHEMA_LABEL");
            String fileString = XMLDemoActions.this.editorDemo.getResourceString("ADD_SCHEMA_FILE_LABEL");
            String urlString = XMLDemoActions.this.editorDemo.getResourceString("ADD_SCHEMA_URL_LABEL");
            String browseString = XMLDemoActions.this.editorDemo.getResourceString("ADD_SCHEMA_BROWSE");
            final Component fileChooserParent = parentComponent;
            JPanel panel = new JPanel(new BorderLayout(3, 3));
            panel.add("North", new JLabel(labelString));
            final JRadioButton fileBox = new JRadioButton(fileString);
            fileBox.setMnemonic(XMLDemoActions.this.editorDemo.getResourceMnemonic("ADD_SCHEMA_FILE_MNEMONIC"));
            fileBox.setSelected(true);
            final DisableTextField fileField = new DisableTextField();
            fileField.setColumns(30);
            final JButton browseButton = new JButton(browseString);
            browseButton.setMnemonic(XMLDemoActions.this.editorDemo.getResourceMnemonic("ADD_SCHEMA_BROWSE_MNEMONIC"));
            browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String fileText = fileField.getText();
                    boolean emptyString = fileText == null || "".equals(fileText);
                    File f = emptyString ? ManageSchemaAction.this._lastSchemaFile : new File(fileText);
                    JFileChooser fileChooser = new JFileChooser();
                    String unformatedText = XMLDemoActions.this.editorDemo.getResourceString("EXT_DESCRIPTION");
                    MessageFormat format = new MessageFormat(unformatedText);
                    String ext = ".xsd";
                    Object[] args = new Object[]{ext};
                    String desc = format.format(args);
                    ExtFilter filter = new ExtFilter(ext, desc);
                    fileChooser.addChoosableFileFilter(filter);
                    fileChooser.setSelectedFile(f);
                    int result = fileChooser.showOpenDialog(fileChooserParent);
                    if (result == 0) {
                        f = fileChooser.getSelectedFile();
                        ManageSchemaAction.this._lastSchemaFile = f;
                        String text = null;
                        if (f != null) {
                            try {
                                text = f.getCanonicalPath();
                            }
                            catch (IOException ioe) {
                                text = null;
                            }
                        }
                        fileField.setText(text);
                    }
                }
            });
            JPanel filePanel = new JPanel(new BorderLayout(3, 3));
            filePanel.add("West", fileBox);
            filePanel.add("Center", fileField);
            filePanel.add("East", browseButton);
            panel.add("Center", filePanel);
            JRadioButton urlBox = new JRadioButton(urlString);
            urlBox.setMnemonic(XMLDemoActions.this.editorDemo.getResourceMnemonic("ADD_SCHEMA_URL_MNEMONIC"));
            urlBox.setSelected(false);
            final DisableTextField urlField = new DisableTextField();
            urlField.setColumns(29);
            ((JComponent)urlField).setEnabled(false);
            JPanel urlPanel = new JPanel(new BorderLayout(3, 3));
            urlPanel.add("West", urlBox);
            urlPanel.add("Center", urlField);
            panel.add("South", urlPanel);
            ButtonGroup group = new ButtonGroup();
            group.add(fileBox);
            group.add(urlBox);
            ChangeListener listener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean file = fileBox.isSelected();
                    urlField.setEnabled(!file);
                    fileField.setEnabled(file);
                    browseButton.setEnabled(file);
                }
            };
            fileBox.addChangeListener(listener);
            urlBox.addChangeListener(listener);
            int button = JOptionPane.showOptionDialog(parentComponent, panel, title, 2, -1, null, null, null);
            Set schemas = Collections.EMPTY_SET;
            switch (button) {
                case 0: {
                    URL url = null;
                    if (fileBox.isSelected()) {
                        if (fileField.getText() != null) {
                            File f = new File(fileField.getText());
                            try {
                                url = f.toURL();
                            }
                            catch (MalformedURLException murle) {
                                System.err.println(murle);
                            }
                        }
                    } else if (urlField.getText() != null) {
                        try {
                            url = new URL(urlField.getText());
                        }
                        catch (MalformedURLException murle) {
                            System.err.println(murle);
                        }
                    }
                    if (url == null) break;
                    try {
                        SchemaGrammarProvider gp = DemoXmlContext.getSharedGrammarProvider();
                        schemas = gp.addSchema(url);
                    }
                    catch (GrammarException se) {
                        String unformatedText = XMLDemoActions.this.editorDemo.getResourceString("ADD_SCHEMA_ERROR");
                        Object[] args = new Object[]{url.toString(), se.toString()};
                        MessageFormat format = new MessageFormat(unformatedText);
                        String message = format.format(args);
                        JOptionPane.showMessageDialog(parentComponent, message, null, 0);
                    }
                    break;
                }
            }
            return schemas;
        }

        private int _showOptionDialog(JOptionPane pane, Component parentComponent, String title) {
            JDialog dialog = pane.createDialog(parentComponent, title);
            dialog.show();
            Object selectedValue = pane.getValue();
            if (selectedValue == null) {
                return -1;
            }
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }

        private boolean _equals(Grammar s1, Grammar s2, boolean checkLocation) {
            boolean namespaceEqual;
            if (s1 == s2) {
                return true;
            }
            boolean bl = namespaceEqual = s1.getTargetNamespace() == s2.getTargetNamespace();
            if (checkLocation) {
                return namespaceEqual && s1.getLocation() == s2.getLocation();
            }
            return namespaceEqual;
        }
    }

    public class FindAction
    extends TextAction {
        public static final int FIND = 1;
        public static final int FIND_AGAIN = 2;
        private int findType;

        public FindAction(String actionName, int findType) {
            super(actionName);
            this.findType = findType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int offset;
            boolean localFromStart;
            BasicEditorPane target = (BasicEditorPane)this.getTextComponent(e);
            if (target == null) {
                return;
            }
            switch (this.findType) {
                case 1: {
                    if (!this.displayDialog(target)) {
                        return;
                    }
                    localFromStart = fromStart;
                    break;
                }
                case 2: {
                    localFromStart = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid find type: " + this.findType);
                }
            }
            if (searchText == null || searchText.length() == 0) {
                target.getToolkit().beep();
                return;
            }
            if (localFromStart) {
                offset = 0;
            } else {
                offset = target.getCaretPosition();
                if (target.getSelectionStart() != target.getSelectionEnd()) {
                    offset = target.getSelectionStart() + 1;
                }
            }
            FindHighlightPlugin findPlugin = (FindHighlightPlugin)target.getProperty("finder");
            int offsetFound = findPlugin.findText(searchText, offset, searchForward, matchCase, wrapAround, wholeWordOnly, highlightAll);
            if (offsetFound == -1) {
                JFrame mainFrame = XMLDemoActions.this.editorDemo.getMainFrame();
                String errorString = XMLDemoActions.this.editorDemo.getResourceString("FIND_DIALOG_NOT_FOUND");
                JOptionPane.showMessageDialog(mainFrame, errorString);
            } else {
                target.setCaretPositionCenter(offsetFound);
                target.moveCaretPositionCenter(offsetFound + searchText.length());
                target.requestFocus();
            }
        }

        private boolean displayDialog(BasicEditorPane editor) {
            int end;
            String initialText = "";
            int start = editor.getSelectionStart();
            if (start != (end = editor.getSelectionEnd())) {
                try {
                    initialText = editor.getDocument().getText(start, end - start);
                }
                catch (BadLocationException e) {
                    initialText = "";
                }
            } else {
                initialText = searchText;
            }
            JTextField textField = new JTextField(initialText, 15);
            textField.selectAll();
            String findLabelText = XMLDemoActions.this.editorDemo.getResourceString("FIND_DIALOG_LABEL");
            String matchCaseText = XMLDemoActions.this.editorDemo.getResourceString("FIND_DIALOG_MATCH_CASE");
            String wholeWordText = XMLDemoActions.this.editorDemo.getResourceString("FIND_DIALOG_WORD");
            String beginDocText = XMLDemoActions.this.editorDemo.getResourceString("FIND_DIALOG_BEGIN_DOC");
            String searchForwardText = XMLDemoActions.this.editorDemo.getResourceString("FIND_DIALOG_SEARCH_FORWARD");
            String highlightText = XMLDemoActions.this.editorDemo.getResourceString("FIND_DIALOG_HIGHLIGHT");
            String wrapText = XMLDemoActions.this.editorDemo.getResourceString("FIND_DIALOG_WRAP");
            JLabel findLabel = new JLabel(findLabelText);
            JCheckBox caseCheckBox = new JCheckBox(matchCaseText, matchCase);
            JCheckBox wordCheckBox = new JCheckBox(wholeWordText, wholeWordOnly);
            JCheckBox startCheckBox = new JCheckBox(beginDocText, fromStart);
            JCheckBox forwardCheckBox = new JCheckBox(searchForwardText, searchForward);
            JCheckBox highlightCheckBox = new JCheckBox(highlightText, highlightAll);
            JCheckBox wrapCheckBox = new JCheckBox(wrapText, wrapAround);
            JPanel jp1 = new JPanel();
            jp1.add(findLabel);
            jp1.add(textField);
            Box box = new Box(1);
            box.add(caseCheckBox);
            box.add(startCheckBox);
            box.add(forwardCheckBox);
            box.add(highlightCheckBox);
            box.add(wrapCheckBox);
            box.add(wordCheckBox);
            JPanel jp2 = new JPanel(new BorderLayout());
            jp2.add((Component)jp1, "Center");
            jp2.add((Component)box, "South");
            String dialogTitle = XMLDemoActions.this.editorDemo.getResourceString("FIND_DIALOG_TITLE");
            int button = JOptionPane.showOptionDialog(XMLDemoActions.this.editorDemo.getMainFrame(), jp2, dialogTitle, 2, -1, null, null, null);
            boolean result = false;
            switch (button) {
                case 0: {
                    searchText = textField.getText();
                    fromStart = startCheckBox.isSelected();
                    matchCase = caseCheckBox.isSelected();
                    wholeWordOnly = wordCheckBox.isSelected();
                    searchForward = forwardCheckBox.isSelected();
                    highlightAll = highlightCheckBox.isSelected();
                    wrapAround = wrapCheckBox.isSelected();
                    result = true;
                    break;
                }
            }
            return result;
        }
    }

    public class InvokerAction
    extends AbstractAction {
        public InvokerAction(String actionKey) {
            super(actionKey);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionInvoker invoker = XMLDemoActions.this.getEditorPane().getActionInvoker();
            invoker.invokeAction((String)this.getValue("Name"));
        }
    }

    public class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(XMLDemoActions.redoActionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                XMLDemoActions.this._undoSupport.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            XMLDemoActions.this.updateUndoRedo();
        }
    }

    public class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(XMLDemoActions.undoActionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                XMLDemoActions.this._undoSupport.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            XMLDemoActions.this.updateUndoRedo();
        }
    }

    public class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super(XMLDemoActions.exitActionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (XMLDemoActions.this.trySave()) {
                System.exit(0);
            }
        }
    }

    public class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            super(XMLDemoActions.saveAsActionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = XMLDemoActions.this._createFileChooser();
            int result = fileChooser.showSaveDialog(XMLDemoActions.this.getMainFrame());
            if (result == 0) {
                XMLDemoActions.this.saveFile(fileChooser.getSelectedFile(), true);
            }
        }
    }

    public class SaveAction
    extends AbstractAction
    implements DocumentListener,
    PropertyChangeListener {
        public SaveAction() {
            super(XMLDemoActions.saveActionName);
            XMLDemoActions.this.editorDemo.getEditorPane().addPropertyChangeListener((PropertyChangeListener)this);
            XMLDemoActions.this.editorDemo.getEditorPane().getDocument().addDocumentListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XMLDemoActions.this.save();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("document".equals(name)) {
                Document newD;
                Document old = (Document)e.getOldValue();
                if (old != null) {
                    old.removeDocumentListener(this);
                }
                if ((newD = (Document)e.getNewValue()) != null) {
                    newD.addDocumentListener(this);
                }
            }
        }

        public void update() {
            BasicDocument document = (BasicDocument)XMLDemoActions.this.editorDemo.getEditorPane().getDocument();
            TextBuffer textBuffer = document.getTextBuffer();
            this.setEnabled(textBuffer.isModified());
        }
    }

    public class OpenAction
    extends AbstractAction {
        public OpenAction() {
            super(XMLDemoActions.openActionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser;
            int result;
            if (XMLDemoActions.this.trySave() && (result = (fileChooser = XMLDemoActions.this._createFileChooser()).showOpenDialog(XMLDemoActions.this.getMainFrame())) == 0) {
                File file = fileChooser.getSelectedFile();
                XMLDemoActions.this.editorDemo.openFile(file, true);
            }
        }
    }

    public class NewAction
    extends AbstractAction {
        public NewAction() {
            super(XMLDemoActions.newActionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (XMLDemoActions.this.trySave()) {
                File newFile = new File("untitled.xml");
                XMLDemoActions.this.editorDemo.openFile(newFile, false);
            }
        }
    }
}

