/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import oracle.bali.xml.dom.buffer.DefaultDocumentScannerFactory;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.demo.XMLDemoActions;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.tooltip.XMLTooltipInsightProvider;
import oracle.bali.xml.editor.plugins.AutomaticEndTagProvider;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.gui.demo.DemoXmlContext;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.editor.plugins.StatusBarPlugin;

public final class XMLEditorDemo
implements PopupManager,
ToolTipProvider {
    public static final Color CARET_COLOR = Color.black;
    public static final Color SELECTION_TEXT_COLOR = Color.white;
    public static final Color SELECTION_COLOR = Color.blue;
    public static final String SCHEMA_SWITCH = "-schema";
    public static final String RESOURCE_FILE = "oracle.bali.xml.editor.demo.Resources";
    public static final String RESOURCE_NOT_FOUND = "<NOT FOUND>";
    public static final String UNTITLED_DOCUMENT = "untitled.xml";
    private DemoXmlContext _xmlContext = null;
    private XMLCompletionInsightProvider _insightPlugin = null;
    private XMLTooltipInsightProvider _tooltipPlugin = null;
    private JFrame mainFrame;
    private JScrollPane scrollPane;
    private JPanel mainPanel;
    private BasicEditorPane editorPane;
    private JMenuBar menuBar;
    private XMLDemoActions demoActions;
    private JPopupMenu popupMenu;
    private File _lastFile;
    private boolean _saved;
    private static ResourceBundle resources;

    public static void main(String[] args) {
        String schemaArg = null;
        String fileArg = null;
        for (int iter = 0; iter < args.length; ++iter) {
            String argument = args[iter];
            if (argument == null) continue;
            if (argument.equals(SCHEMA_SWITCH)) {
                if (iter + 1 >= args.length) continue;
                schemaArg = args[iter + 1];
                ++iter;
                continue;
            }
            fileArg = argument;
        }
        XMLEditorDemo._registerInitialSchema(schemaArg);
        new XMLEditorDemo(fileArg);
    }

    public XMLEditorDemo(String filename) {
        try {
            UIManager.setLookAndFeel("oracle.bali.ewt.olaf.OracleLookAndFeel");
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.editorPane = new BasicEditorPane();
        this.editorPane.setCaretColor(CARET_COLOR);
        this.editorPane.setSelectedTextColor(SELECTION_TEXT_COLOR);
        this.editorPane.setSelectionColor(SELECTION_COLOR);
        this.editorPane.addPopupManager((PopupManager)this);
        this.editorPane.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        FindHighlightPlugin findPlugin = new FindHighlightPlugin();
        this.editorPane.installPlugin((EditorPlugin)findPlugin);
        StatusBarPlugin statusBar = new StatusBarPlugin(this.editorPane.getFont());
        this.editorPane.installPlugin((EditorPlugin)statusBar);
        XMLLanguageModule.registerFileType("uix");
        XMLLanguageModule xmlModule = new XMLLanguageModule();
        this.editorPane.installPlugin((EditorPlugin)new AutomaticEndTagProvider());
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.END_TAG", true);
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.REQUIRED_ATTRIBUTE_INSERTION", true);
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.SMART_INDENT", true);
        this.editorPane.putProperty("finder", (Object)findPlugin);
        this.scrollPane = new JScrollPane((Component)this.editorPane);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        JViewport viewport = this.scrollPane.getViewport();
        viewport.setScrollMode(1);
        LineGutterPlugin lineGutter = new LineGutterPlugin();
        this.editorPane.installPlugin((EditorPlugin)lineGutter);
        this.scrollPane.setRowHeaderView((Component)lineGutter);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.scrollPane, "Center");
        mainPanel.add((Component)statusBar.getPanel(), "South");
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(3);
        this.mainFrame.getContentPane().add(mainPanel);
        this.demoActions = new XMLDemoActions(this);
        this.menuBar = this.createMenuBar();
        this.popupMenu = this.createPopupMenu();
        this.mainFrame.setJMenuBar(this.menuBar);
        this.mainFrame.pack();
        this.mainFrame.setSize(640, 480);
        File initialFile = null;
        initialFile = filename != null ? new File(filename) : new File(UNTITLED_DOCUMENT);
        this.openFile(initialFile, false);
        this.mainFrame.setVisible(true);
    }

    private JMenuBar createMenuBar() {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu());
        mb.add(this.createEditMenu());
        mb.add(this.createSearchMenu());
        mb.add(this.createSchemaMenu());
        return mb;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu pm = new JPopupMenu();
        DemoMenuItem cutItem = this.createMenuItem("CUT", "cut-to-clipboard");
        DemoMenuItem copyItem = this.createMenuItem("COPY", "copy-to-clipboard");
        DemoMenuItem pasteItem = this.createMenuItem("PASTE", "paste-from-clipboard");
        DemoMenuItem selectAllItem = this.createMenuItem("SELECTALL", "select-all");
        pm.add(cutItem);
        pm.add(copyItem);
        pm.add(pasteItem);
        pm.addSeparator();
        pm.add(selectAllItem);
        return pm;
    }

    private JMenu createFileMenu() {
        String menuLabel = this.getResourceString("FILE_MENU");
        char menuMnemonic = this.getResourceMnemonic("FILE_MNEMONIC");
        JMenu menu = new JMenu(menuLabel);
        if (menuMnemonic != '\u0000') {
            menu.setMnemonic(menuMnemonic);
        }
        DemoMenuItem newItem = this.createMenuItem("NEW", "new-document");
        DemoMenuItem openItem = this.createMenuItem("OPEN", "open-document");
        DemoMenuItem saveItem = this.createMenuItem("SAVE", "save-document");
        DemoMenuItem saveAsItem = this.createMenuItem("SAVEAS", "saveas-document");
        DemoMenuItem exitItem = this.createMenuItem("EXIT", "exit-program");
        menu.add(newItem);
        menu.add(openItem);
        menu.addSeparator();
        menu.add(saveItem);
        menu.add(saveAsItem);
        menu.addSeparator();
        menu.add(exitItem);
        return menu;
    }

    private JMenu createEditMenu() {
        String menuLabel = this.getResourceString("EDIT_MENU");
        char menuMnemonic = this.getResourceMnemonic("EDIT_MNEMONIC");
        JMenu menu = new JMenu(menuLabel);
        if (menuMnemonic != '\u0000') {
            menu.setMnemonic(menuMnemonic);
        }
        DemoMenuItem undoItem = this.createMenuItem("UNDO", "undo-edit");
        DemoMenuItem redoItem = this.createMenuItem("REDO", "redo-edit");
        DemoMenuItem cutItem = this.createMenuItem("CUT", "cut-to-clipboard");
        DemoMenuItem copyItem = this.createMenuItem("COPY", "copy-to-clipboard");
        DemoMenuItem pasteItem = this.createMenuItem("PASTE", "paste-from-clipboard");
        DemoMenuItem selectAllItem = this.createMenuItem("SELECTALL", "select-all");
        menu.add(undoItem);
        menu.add(redoItem);
        menu.addSeparator();
        menu.add(cutItem);
        menu.add(copyItem);
        menu.add(pasteItem);
        menu.addSeparator();
        menu.add(selectAllItem);
        return menu;
    }

    private JMenu createSearchMenu() {
        String menuLabel = this.getResourceString("SEARCH_MENU");
        char menuMnemonic = this.getResourceMnemonic("SEARCH_MNEMONIC");
        JMenu menu = new JMenu(menuLabel);
        if (menuMnemonic != '\u0000') {
            menu.setMnemonic(menuMnemonic);
        }
        DemoMenuItem findItem = this.createMenuItem("FIND", "find");
        DemoMenuItem findAgainItem = this.createMenuItem("FIND_AGAIN", "find-again");
        menu.add(findItem);
        menu.add(findAgainItem);
        return menu;
    }

    private JMenu createSchemaMenu() {
        String menuLabel = this.getResourceString("SCHEMA_MENU");
        char menuMnemonic = this.getResourceMnemonic("SCHEMA_MNEMONIC");
        JMenu menu = new JMenu(menuLabel);
        if (menuMnemonic != '\u0000') {
            menu.setMnemonic(menuMnemonic);
        }
        DemoMenuItem manageItem = this.createMenuItem("MANAGE", "manage-schemas");
        DemoMenuItem proxyItem = this.createMenuItem("PROXY", "proxy");
        menu.add(manageItem);
        menu.add(proxyItem);
        return menu;
    }

    private DemoMenuItem createMenuItem(String itemName, String actionName) {
        String itemLabel = this.getResourceString(itemName + "_ITEM");
        char itemMnemonic = this.getResourceMnemonic(itemName + "_MNEMONIC");
        KeyStroke itemKey = this.getResourceKeyStroke(itemName + "_KEYSTROKE");
        Action action = this.demoActions.findAction(actionName);
        DemoMenuItem item = new DemoMenuItem(itemLabel, action);
        if (itemMnemonic != '\u0000') {
            item.setMnemonic(itemMnemonic);
        }
        if (itemKey != null) {
            item.setAccelerator(itemKey);
        }
        return item;
    }

    protected String getResourceString(String key) {
        String str;
        try {
            str = resources.getString(key);
        }
        catch (MissingResourceException e) {
            str = RESOURCE_NOT_FOUND;
        }
        return str;
    }

    protected char getResourceMnemonic(String key) {
        String str = this.getResourceString(key);
        if (str.equals(RESOURCE_NOT_FOUND)) {
            return '\u0000';
        }
        return str.charAt(0);
    }

    private KeyStroke getResourceKeyStroke(String key) {
        String str = this.getResourceString(key);
        if (str.equals(RESOURCE_NOT_FOUND)) {
            return null;
        }
        return KeyStroke.getKeyStroke(str);
    }

    protected void setTitle(String filename) {
        if (filename == null) {
            filename = UNTITLED_DOCUMENT;
            this._saved = false;
        }
        this.mainFrame.setTitle(this.getResourceString("DEMO_NAME") + " - " + filename);
        BasicDocument document = (BasicDocument)this.editorPane.getDocument();
        document.setLanguageSupport(filename);
    }

    protected void openFile(File file, boolean mustExist) {
        if (mustExist && !file.exists()) {
            try {
                this._showOptionPane(new FileNotFoundException(file.getCanonicalPath()));
            }
            catch (IOException ioE) {
                this._showOptionPane(ioE);
            }
            return;
        }
        try {
            DemoXmlContext oldContext = this._xmlContext;
            if (this._insightPlugin != null) {
                this.editorPane.deinstallPlugin((EditorPlugin)this._insightPlugin);
            }
            if (this._tooltipPlugin != null) {
                this.editorPane.deinstallPlugin((EditorPlugin)this._tooltipPlugin);
            }
            this._xmlContext = new DemoXmlContext(file, Locale.getDefault());
            this._xmlContext.finishInitialization();
            this._xmlContext.setModel(new XmlModel());
            DefaultDocumentScannerFactory factory = new DefaultDocumentScannerFactory();
            this._insightPlugin = new XMLCompletionInsightProvider((XmlContext)this._xmlContext, (DocumentScannerFactory)factory);
            this._tooltipPlugin = new XMLTooltipInsightProvider((XmlContext)this._xmlContext, (DocumentScannerFactory)factory);
            this.editorPane.setDocument(this._xmlContext.getSourceDocument());
            this.editorPane.installPlugin((EditorPlugin)this._insightPlugin);
            this.editorPane.installPlugin((EditorPlugin)this._tooltipPlugin);
            this.setTitle(file.getCanonicalPath());
            this.setLastFile(file);
            this._updateSave();
            if (oldContext != null) {
                oldContext.dispose();
            }
        }
        catch (Exception e) {
            this._showOptionPane(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFile(File file) {
        if (file != null) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                BasicDocument document = (BasicDocument)this.editorPane.getDocument();
                TextBuffer textBuffer = document.getTextBuffer();
                textBuffer.write((Writer)writer);
                this.setTitle(file.getCanonicalPath());
                this.setLastFile(file);
                this._updateSave();
                this._saved = true;
            }
            catch (FileNotFoundException e) {
                this._showOptionPane(e);
            }
            catch (IOException e) {
                this._showOptionPane(e);
            }
            finally {
                try {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    protected BasicEditorPane getEditorPane() {
        return this.editorPane;
    }

    protected boolean isSaved() {
        return this._saved;
    }

    protected File getLastFile() {
        return this._lastFile;
    }

    protected void setLastFile(File file) {
        this._lastFile = file;
    }

    protected JFrame getMainFrame() {
        return this.mainFrame;
    }

    private static void _registerInitialSchema(String schemaArg) {
        if (schemaArg == null) {
            return;
        }
        URL schemaURL = null;
        try {
            String filename = schemaArg;
            File aFile = new File(filename);
            filename = aFile.getCanonicalPath();
            filename = filename.charAt(0) == '/' ? "file:" + filename : "file:/" + filename;
            schemaURL = new URL(filename);
        }
        catch (Exception e) {
            System.out.println("Could not locate schema file.  " + e.getMessage());
            schemaURL = null;
        }
        if (schemaURL != null) {
            try {
                SchemaGrammarProvider gp = DemoXmlContext.getSharedGrammarProvider();
                gp.addSchema(schemaURL);
            }
            catch (GrammarException sE) {
                sE.printStackTrace();
            }
        }
    }

    private void _showOptionPane(Throwable t) {
        JOptionPane.showMessageDialog(this.getMainFrame(), t.getLocalizedMessage(), t.toString(), 0);
    }

    private void _updateSave() {
        Action a = this.demoActions.findAction("save-document");
        XMLDemoActions.SaveAction action = (XMLDemoActions.SaveAction)a;
        action.update();
    }

    public void showPopup(BasicEditorPane editorPane, MouseEvent mouseEvent) {
        this.popupMenu.show((Component)editorPane, mouseEvent.getX(), mouseEvent.getY());
    }

    public void hidePopup(BasicEditorPane editorPane) {
        this.popupMenu.setVisible(false);
    }

    public String getToolTipText(BasicEditorPane editorPane, MouseEvent mouseEvent, int offset) {
        return "Offset: " + offset;
    }

    static {
        try {
            resources = ResourceBundle.getBundle(RESOURCE_FILE, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            System.err.println("Could not find Resources.properties file.");
            System.exit(1);
        }
    }

    public static final class DemoMenuItem
    extends JMenuItem
    implements PropertyChangeListener {
        private Action action;

        public DemoMenuItem(String label, Action action) {
            super(label);
            this.action = action;
            if (action != null) {
                this.setActionCommand((String)action.getValue("Name"));
                this.addActionListener(action);
                PropertyChangeListener listener = this.createActionPropertyChangeListener(action);
                action.addPropertyChangeListener(listener);
                this.setEnabled(action.isEnabled());
            }
        }

        @Override
        protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
            return this;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("enabled")) {
                Boolean enabledState = (Boolean)event.getNewValue();
                this.setEnabled(enabledState);
                this.repaint();
            }
        }
    }
}

