/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.action.PasteAction;
import oracle.bali.xml.model.datatransfer.operation.Operation;
import oracle.bali.xml.model.datatransfer.operation.OperationProcessor;
import oracle.bali.xml.share.GroupingAction;

public class PasteSpecialAction
extends AbstractAction
implements PropertyChangeListener {
    private final PasteAction _pasteAction;
    private static final Logger _LOGGER = Logger.getLogger(PasteSpecialAction.class.getName());

    public PasteSpecialAction(Action pasteAction) {
        this._pasteAction = (PasteAction)pasteAction;
        this.putValue("ActionCommandKey", "paste_special");
        this._pasteAction.addPropertyChangeListener((PropertyChangeListener)this);
        this._updateEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this._pasteAction.isEnabledImpl()) {
            try {
                this._showDialog();
            }
            catch (Exception e) {
                _LOGGER.log(Level.WARNING, "Error in paste special", e);
                SwingXmlContext context = this._context();
                String title = context.getTranslatedString("ErrorDuringPasteSpecialTitle");
                String message = context.getTranslatedString("ErrorDuringPasteSpecial");
                context.showErrorMessage(message, title, e);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            this._updateEnabled();
        }
    }

    private void _showDialog() {
        Action action;
        OperationProcessor processor = this._pasteAction.getOperationProcessor();
        ListModel listModel = this._createListModel(processor);
        if (listModel.getSize() == 0) {
            throw new IllegalStateException("empty paste special dialog yet enabled! " + processor);
        }
        JList<Object> list = new JList<Object>(listModel);
        list.setCellRenderer(new ActionListCellRenderer());
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)new JScrollPane(list), "Center");
        String title = "Paste Special";
        JEWTDialog dialog = new JEWTDialog(WindowUtils.parentFrame((Component)this._context().getRootDocumentUIComponent()), title, 7);
        dialog.setContent((Component)content);
        UIUtils.setupListDoubleClickListener(list, dialog);
        boolean ok = dialog.runDialog();
        if (ok && (action = (Action)list.getSelectedValue()) != null) {
            action.actionPerformed(new ActionEvent(this, 0, "", 0));
        }
    }

    private SwingXmlContext _context() {
        return (SwingXmlContext)this._model().getContext();
    }

    private ListModel _createListModel(OperationProcessor processor) {
        DefaultListModel list = new DefaultListModel();
        AbstractModel model = this._model();
        Iterator itor = processor.getSupportedOperations();
        while (itor.hasNext()) {
            List dataAndPositionsList;
            Operation operation = (Operation)itor.next();
            Action opAction = operation.createAsAction(model, dataAndPositionsList = processor.getListOfDataAndPositions(operation));
            if (opAction == null) continue;
            this._addToList(list, opAction);
        }
        return list;
    }

    private AbstractModel _model() {
        return this._pasteAction.getModel();
    }

    private void _addToList(DefaultListModel list, Action action) {
        if (action instanceof GroupingAction) {
            GroupingAction group = (GroupingAction)action;
            Iterator itor = group.getChildIterator();
            while (itor.hasNext()) {
                Action child = (Action)itor.next();
                this._addToList(list, child);
            }
        } else {
            list.addElement(action);
        }
    }

    private void _updateEnabled() {
        this.setEnabled(this._pasteAction.isEnabled());
    }

    private static class ActionListCellRenderer
    extends DefaultListCellRenderer {
        private ActionListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Action) {
                Object icon;
                Action act = (Action)value;
                Object name = act.getValue(Operation.FLATTENED_NAME);
                if (name == null) {
                    name = act.getValue("Name");
                }
                if (name != null) {
                    this.setText(StringUtils.stripMnemonic((String)name.toString()));
                }
                if ((icon = act.getValue("SmallIcon")) instanceof Icon) {
                    this.setIcon((Icon)icon);
                }
            }
            return this;
        }
    }
}

