/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.creator;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.swing.creator.XmlElementCreator;

public abstract class TextAreaCreator
extends XmlElementCreator {
    protected JTextArea _area;
    private boolean _isCreate;
    private boolean _inSetValue = false;

    protected abstract String getLabel();

    @Override
    protected final Component createContent(boolean create) {
        this._isCreate = create;
        JPanel c = new JPanel(new BorderLayout(0, 5));
        String labelText = this.getLabel();
        JLabel label = new JLabel(StringUtils.stripMnemonic((String)labelText));
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)labelText));
        JTextArea area = new JTextArea(10, 40);
        String text = this.getNodeText();
        area.setText(text);
        area.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextAreaCreator.this._update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextAreaCreator.this._update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextAreaCreator.this._update();
            }
        });
        label.setLabelFor(area);
        JScrollPane pane = new JScrollPane(area);
        c.add("North", label);
        c.add("Center", pane);
        this._area = area;
        return c;
    }

    protected String getNodeText() {
        return this.getNode() == null ? null : this.getNode().getNodeValue();
    }

    @Override
    protected final void updateNode() {
        String value = this.getCurrentValue();
        if (value == null || "".equals(value)) {
            this._removeNode();
        } else {
            this.getNode().setNodeValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object value) {
        this._inSetValue = true;
        try {
            if (this._area != null) {
                this._area.setText((String)value);
            }
            super.setValue(value);
        }
        finally {
            this._inSetValue = false;
        }
    }

    protected String getCurrentValue() {
        return this._area == null ? null : this._area.getText();
    }

    protected boolean isCreation() {
        return this._isCreate;
    }

    private void _update() {
        if (!this._inSetValue) {
            super.setValue(this.getCurrentValue());
            this.firePropertyChange();
        }
    }

    private void _removeNode() {
        if (this.getNode().getParentNode() != null) {
            this.getNode().getParentNode().removeChild(this.getNode());
        }
    }
}

