/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.dnd;

import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.share.MutableBoolean;
import oracle.bali.xml.share.TransactionToken;
import oracle.ide.util.Assert;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.dnd.DndUtils;

public class ModelDragHandler
implements DragGestureListener,
DragSourceListener {
    private XmlGui _gui;
    private Image _dragImage;
    private Point _imageOffset;
    private static final Image _DEFAULT_DRAG_IMAGE;
    private static final Logger _LOGGER;

    public ModelDragHandler(XmlGui gui, Image dragImage, Point imageOffset) {
        if (gui == null) {
            throw new IllegalArgumentException("No gui provided");
        }
        this._gui = gui;
        if (dragImage == null) {
            dragImage = _DEFAULT_DRAG_IMAGE;
        }
        this._dragImage = dragImage;
        if (imageOffset == null) {
            imageOffset = new Point(0, 0);
        }
        this._imageOffset = imageOffset;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (!this.shouldStartDrag(dragGestureEvent)) {
            return;
        }
        Transferable dragTransferable = this._getView().createTransferable();
        if (dragTransferable != null) {
            AugmentableTransferable betterTransferable = TransferUtils.asAugmentableTransferable((Transferable)dragTransferable);
            DndUtils.addTriggerEvent((AugmentableTransferable)betterTransferable, (InputEvent)dragGestureEvent.getTriggerEvent());
            TransactionToken token = this._gui.getGuiContext().createTransactionToken();
            if (token != null) {
                token.setOwnerIfUnset((Object)this);
                betterTransferable.augment(XmlTransferUtils.FLAVOR_TRANSACTIONTOKEN, (Object)token, 0.0f, null);
            }
            dragTransferable = betterTransferable;
            try {
                dragGestureEvent.startDrag(null, this._dragImage, this._imageOffset, dragTransferable, this);
            }
            catch (InvalidDnDOperationException idndoe) {
                Assert.printStackTrace((Throwable)idndoe);
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dropEvent) {
        DragSourceContext dragContext = dropEvent.getDragSourceContext();
        ExtendedTransferable transferable = (ExtendedTransferable)dragContext.getTransferable();
        TransactionToken token = XmlTransferUtils.getTransactionToken((Transferable)transferable);
        boolean dropSuccess = dropEvent.getDropSuccess();
        if (dropSuccess && dropEvent.getDropAction() == 2) {
            List fragData = transferable.getDataInfos(XmlTransferUtils.FLAVOR_DOCUMENTFRAGMENT);
            if (fragData.size() == 1) {
                TransferDataInfo data = (TransferDataInfo)fragData.get(0);
                MutableBoolean mb = (MutableBoolean)data.getMetadata(XmlTransferUtils.KEY_TARGET_HANDLED_MOVE);
                if (mb == null) {
                    _LOGGER.log(Level.FINER, "DragHandler found no mutableBoolean on data {0}, not handling move", data);
                } else if (mb.get()) {
                    _LOGGER.log(Level.FINER, "DragHandler not handling move of {0} since target handled it", data);
                } else {
                    _LOGGER.log(Level.FINER, "DragHandler handling move of {0} since target didn't handle it", data);
                    this._doRemoval(token, data);
                }
            } else {
                _LOGGER.log(Level.FINER, "DragHandler didn't handle move, unexpected transferable contents {0}", transferable);
            }
        }
        TransactionToken.dispatch((TransactionToken)token, (Object)this, (boolean)dropSuccess);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    protected boolean shouldStartDrag(DragGestureEvent event) {
        return true;
    }

    private void _doRemoval(TransactionToken token, TransferDataInfo data) {
        String removeNodesDescription = this._gui.getTranslatedString("DND.REMOVE_NODES_DESCRIPTION");
        try {
            XmlTransferUtils.removeOriginalNodes((String)removeNodesDescription, (TransferDataInfo)data, (DomRange)XmlTransferUtils.getOriginalRange((TransferDataInfo)data), (Collection)XmlTransferUtils.getOriginalNodes((TransferDataInfo)data), (TransactionToken)token, (boolean)true);
        }
        catch (XmlCommitException e) {
            // empty catch block
        }
    }

    private XmlView _getView() {
        return this._gui.getView();
    }

    private static boolean _sNeedsNullDragImageWorkaround() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    static {
        if (ModelDragHandler._sNeedsNullDragImageWorkaround()) {
            BufferedImage bi = new BufferedImage(1, 1, 6);
            bi.setRGB(0, 0, -16777216);
            _DEFAULT_DRAG_IMAGE = bi;
        } else {
            _DEFAULT_DRAG_IMAGE = null;
        }
        _LOGGER = Logger.getLogger(ModelDragHandler.class.getName());
    }
}

