/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector.editorFactories;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentSetup;
import oracle.bali.inspector.editor.EditorFactoryUtils;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.xml.gui.swing.inspector.editorFactories.DateFieldEditor;

public class DateFieldEditorSetup
extends EditorComponentSetup {
    public boolean canConfigure(Component inlineEditor) {
        return inlineEditor instanceof DateFieldEditor;
    }

    public void configure(PropertyEditorFactory2 propertyEditor, PropertyValueApplier applier, Component inlineEditor) {
        if (!this.canConfigure(inlineEditor)) {
            return;
        }
        DateFieldEditor dateFieldEditor = (DateFieldEditor)((Object)inlineEditor);
        this.addPropertyInspectorListeners(dateFieldEditor, propertyEditor);
        dateFieldEditor.setPropertyValueApplier(applier);
    }

    protected void addPropertyInspectorListeners(DateFieldEditor editor, PropertyEditorFactory2 propertyEditor) {
        DateFieldListener listener = new DateFieldListener(editor, propertyEditor);
        editor.addFocusListener(listener);
        editor.addKeyListener(listener);
        editor.addPropertyChangeListener("date", listener);
    }

    private static class DateFieldListener
    extends KeyAdapter
    implements FocusListener,
    PropertyChangeListener {
        private DateFieldEditor _editor;
        private PropertyEditorFactory2 _propertyEditor;

        public DateFieldListener(DateFieldEditor editor, PropertyEditorFactory2 propertyEditor) {
            this._editor = editor;
            this._propertyEditor = propertyEditor;
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            this.applyValueFromEditor();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this._editor.setDirty(true);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() != 27) {
                this._editor.setDirty(true);
                return;
            }
            String oldText = this._propertyEditor.getAsText();
            this._editor.setText(oldText);
        }

        protected void applyValueFromEditor() {
            if (!this._editor.isDirty()) {
                return;
            }
            String newValue = this._editor.getText();
            String oldValue = this._propertyEditor.getAsText();
            if (DateFieldListener.isEmpty(newValue) && DateFieldListener.isEmpty(oldValue)) {
                return;
            }
            if (newValue.equals(oldValue)) {
                return;
            }
            try {
                this._propertyEditor.setAsText(newValue);
                this._editor.getPropertyValueApplier().apply(this._propertyEditor.getValue());
            }
            catch (Exception ex) {
                try {
                    this._editor.setText(oldValue);
                    this._propertyEditor.setAsText(oldValue);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                EditorFactoryUtils.showErrorMessage((Component)this._editor.getParent(), (Exception)ex, (String)newValue);
            }
        }

        private static boolean isEmpty(String s) {
            return s == null || s.length() == 0;
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    }
}

