/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutterView;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.util.Log;

public class CodeEditorGutter
extends LineGutterPlugin {
    public static final String COLUMN_NAME_LIGHTBULB = "lightbulb";
    public static final String COLUMN_NAME_BREAKPOINT = "breakpoint";
    public static final String COLUMN_NAME_WATCHPOINT = "watchpoint";
    public static final String COLUMN_NAME_IP = "ip";
    public static final int MARK_ORDER_BREAKPOINT = 0;
    public static final int MARK_ORDER_WATCHPOINT_ZERO = 1000;
    public static final int MARK_ORDER_BOOKMARK = 2000;
    public static final int MARK_ORDER_PROFILER = 2500;
    public static final int MARK_ORDER_TODO = 5000;
    public static final int MARK_ORDER_IMPLEMENTS = 3000;
    public static final int MARK_ORDER_OVERRIDES = 4000;
    public static final int MARK_ORDER_LIGHTBULB = 6000;
    public static final int MARK_ORDER_EXECUTION = 7000;
    public static final int MARK_OPTION_CLICK_DROPS_MENU = 65536;
    private static final String GUTTER_MARK = "CodeEditorContext.GUTTER_MARK";
    private static final String LINE_NUMBER = "CodeEditorContext.LINE_NUMBER";
    private static final String DROPPING_DOWN = "CodeEditorContext.DROPPING_DOWN";
    private static ContextMenu _contextMenu;
    private DropdownState _lastDropdownState = DropdownState.OFF;
    private GutterMark _lastDropdownMark;
    private ContextMenu _lastDropdownMenu;
    private long _lastDropdownHideTime;
    private CodeEditor _codeEditor;
    private final GutterView _gutterView;
    private static final Log LOG;
    private static final int TW = 2;
    protected static Polygon _triangle;

    public static ContextMenu getGutterContextMenu() {
        if (_contextMenu == null) {
            _contextMenu = new ContextMenu(new MnemonicSolver());
            ContextMenuListenersHook hook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
            _contextMenu.addContextMenuListener(hook.getListener("gutter"));
        }
        return _contextMenu;
    }

    public void mousePressed(MouseEvent event) {
        LOG.trace("mouse pressed {0}, last time {1}", (Object)event.getWhen(), (Object)this._lastDropdownHideTime);
        if (DropdownState.HIDING == this._lastDropdownState && event.getWhen() == this._lastDropdownHideTime) {
            this._lastDropdownState = DropdownState.PRESSED;
        }
        super.mousePressed(event);
    }

    public void mouseReleased(MouseEvent event) {
        LOG.trace("mouse released {0}, last time {1}", (Object)event.getWhen(), (Object)this._lastDropdownHideTime);
        if (this._lastDropdownState == DropdownState.PRESSED) {
            this._lastDropdownState = DropdownState.RELEASED;
            this._lastDropdownHideTime = event.getWhen();
        }
        super.mouseReleased(event);
    }

    public static CodeEditorGutter getGutterFor(GutterColumn column) {
        Gutter gutter = column.getGutter();
        return (CodeEditorGutter)gutter;
    }

    public static CodeEditorGutter getGutterFor(GutterMark mark) {
        Gutter gutter = mark.getGutter();
        return (CodeEditorGutter)gutter;
    }

    public static GutterMark getMarkForContext(Context context) {
        if (context == null) {
            return null;
        }
        return (GutterMark)context.getProperty(GUTTER_MARK);
    }

    public static boolean isMarkDroppingDown(Context context) {
        if (context == null) {
            return false;
        }
        return Boolean.TRUE.equals(context.getProperty(DROPPING_DOWN));
    }

    public static int getLineForContext(Context context) {
        if (context == null) {
            return -1;
        }
        Integer line = (Integer)context.getProperty(LINE_NUMBER);
        if (line == null) {
            return -1;
        }
        return line;
    }

    CodeEditorGutter(CodeEditor codeEditor) {
        this._codeEditor = codeEditor;
        this._gutterView = new GutterView();
    }

    public Context getContext() {
        return this._gutterView.getContext();
    }

    public CodeEditor getCodeEditor() {
        return this._codeEditor;
    }

    public View getCodeEditorGutterView() {
        return this._gutterView;
    }

    protected LineGutterPlugin.Column createGutterColumnImpl(String columnName, GutterColumnListener listener) {
        return new CEColumn(columnName, listener);
    }

    public void mouseDragged(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event)) {
            return;
        }
        super.mouseDragged(event);
    }

    protected void processMousePressed(MouseEvent event, int line, GutterMark mark) {
        if (SwingUtilities.isRightMouseButton(event)) {
            ContextMenu contextMenu = this.getContextMenu();
            if (contextMenu != null) {
                contextMenu.show(this.getContext(event, line, mark, false));
            }
        } else {
            super.processMousePressed(event, line, mark);
        }
    }

    public void showMarkDropdownMenu(MouseEvent event, GutterMark mark, int line) {
        ContextMenu contextMenu = this.getContextMenu();
        this.showMarkDropdownMenu(contextMenu, event, mark, line);
    }

    public void showMarkDropdownMenu(ContextMenu contextMenu, MouseEvent event, GutterMark mark, int line) {
        long when = event.getWhen();
        LOG.trace("showing dropdown, event time {0}, last time {1}", (Object)when, (Object)this._lastDropdownHideTime);
        if (contextMenu != null) {
            if (DropdownState.RELEASED == this._lastDropdownState && mark == this._lastDropdownMark && contextMenu == this._lastDropdownMenu && when == this._lastDropdownHideTime) {
                LOG.trace("skipping show to achieve toggle");
                this._lastDropdownState = DropdownState.OFF;
                return;
            }
            Rectangle markRect = this.getRolloverRectFor(mark);
            MouseEvent eventToUse = event;
            if (markRect != null) {
                int adjustedX = markRect.x;
                int adjustedY = markRect.y + markRect.height + 1;
                eventToUse = new MouseEvent((Component)event.getSource(), event.getID(), when, event.getModifiers(), adjustedX, adjustedY, event.getClickCount(), event.isPopupTrigger(), event.getButton());
            }
            Rectangle visibleRect = this.getVisibleRect();
            LOG.trace("show geometry: mark {0}, visible {1}", (Object)markRect, (Object)visibleRect);
            if (markRect.y >= visibleRect.y && markRect.y < visibleRect.y + visibleRect.height) {
                this._lastDropdownState = DropdownState.OFF;
                this._lastDropdownMenu = contextMenu;
                this._lastDropdownMark = mark;
                this._lastDropdownHideTime = 0L;
                Context context = this.getContext(eventToUse, line, mark, true);
                LOG.trace("adding listener to {0}", (Object)context);
                contextMenu.addContextMenuListener(new ContextMenuListener(){

                    public void menuWillShow(ContextMenu contextMenu) {
                        LOG.trace("menu will show");
                    }

                    public void menuWillHide(ContextMenu contextMenu) {
                        CodeEditorGutter.this._lastDropdownState = DropdownState.HIDING;
                        CodeEditorGutter.this._lastDropdownHideTime = EventQueue.getMostRecentEventTime();
                        LOG.trace("menu will hide at {0}", CodeEditorGutter.this._lastDropdownHideTime);
                        contextMenu.removeContextMenuListener((ContextMenuListener)this);
                    }

                    public boolean handleDefaultAction(Context context) {
                        return false;
                    }
                });
                contextMenu.show(context);
            }
        }
    }

    private Context getContext(EventObject event, int line, GutterMark mark, boolean droppingDown) {
        Context context = this._gutterView.getContext(event);
        int count = this._codeEditor.getLineCount();
        boolean validLine = line > 0 && line <= count;
        Integer lineInt = validLine ? new Integer(line) : null;
        context.setProperty(LINE_NUMBER, (Object)lineInt);
        context.setProperty(GUTTER_MARK, (Object)mark);
        context.setProperty(DROPPING_DOWN, (Object)droppingDown);
        return context;
    }

    protected Rectangle paintRollover(Graphics graphics, GutterMark mark, int iconX, int columnWidth, int rowY) {
        Rectangle bounds = super.paintRollover(graphics, mark, iconX, columnWidth, rowY);
        CEColumn column = (CEColumn)mark.getGutterColumn();
        if (bounds != null && column.isOptionSet(mark, 65536)) {
            int triangleX = bounds.x + bounds.width - 4 - 2;
            int triangleY = bounds.y + 2;
            Color oldColor = graphics.getColor();
            graphics.translate(triangleX, triangleY);
            graphics.setColor(this.getForeground());
            graphics.fillPolygon(_triangle);
            graphics.drawPolygon(_triangle);
            graphics.translate(-triangleX, -triangleY);
            graphics.setColor(oldColor);
        }
        return bounds;
    }

    public String toString() {
        return "gutter " + this._codeEditor.getContext().getNode().getShortLabel();
    }

    private ContextMenu getContextMenu() {
        return this._gutterView.getContextMenu();
    }

    static {
        LOG = new Log("gutter");
        _triangle = new Polygon(new int[]{0, 2, 4}, new int[]{0, 2, 0}, 3);
    }

    @Deprecated
    public final class GutterView
    extends CodeEditorGutterView {
        public GutterView() {
            super(CodeEditorGutter.this);
        }
    }

    protected class CEColumn
    extends LineGutterPlugin.Column {
        protected CEColumn(String columnName, GutterColumnListener columnListener) {
            super((LineGutterPlugin)CodeEditorGutter.this, columnName, columnListener);
        }

        protected boolean isOptionSet(GutterMark gutterMark, int optionFlag) {
            LineGutterPlugin.Column.Mark mark = (LineGutterPlugin.Column.Mark)gutterMark;
            return mark.isOptionSet(optionFlag);
        }
    }

    private static enum DropdownState {
        OFF,
        SHOWING,
        HIDING,
        PRESSED,
        RELEASED;

    }
}

