/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorHelpableProvider;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.Node;
import oracle.ide.util.ClassUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.editor.plugins.EditorPlugin;

final class CodeEditorHook
extends HashStructureHook {
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "ceditor");
    private Collection<EditorPluginReference> pluginRefCollection = new CopyOnWriteArrayList<EditorPluginReference>();
    private Collection<CodeEditorHelpableProviderReference> codeEditorHelpableProviderRefCollection = new CopyOnWriteArrayList<CodeEditorHelpableProviderReference>();
    private Listener listener;

    CodeEditorHook() {
    }

    public static CodeEditorHook get() {
        return (CodeEditorHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    Collection<EditorPlugin> editorPlugins(String filetype, Node nodeType) {
        ArrayList<EditorPlugin> plugins = new ArrayList<EditorPlugin>();
        for (EditorPluginReference ref : this.editorPlugins()) {
            boolean nodeTypeOK;
            boolean fileTypeOK;
            block3: {
                fileTypeOK = filetype != null && ref.fileTypeList.contains(filetype) || ref.fileTypeList.isEmpty();
                boolean bl = nodeTypeOK = nodeType != null;
                if (nodeTypeOK && !ref.nodeTypeList.isEmpty()) {
                    for (String refNodeType : ref.nodeTypeList) {
                        nodeTypeOK = ClassUtils.isInstanceOf(nodeType.getClass(), (String)refNodeType);
                        if (!nodeTypeOK) continue;
                        break block3;
                    }
                    nodeTypeOK = false;
                }
            }
            if (!fileTypeOK || !nodeTypeOK) continue;
            plugins.add(ref.getEditorPlugin());
        }
        return plugins;
    }

    Collection<CodeEditorHelpableProvider> codeEditorHelpableProviders(String filetype, Node nodeType) {
        ArrayList<CodeEditorHelpableProvider> codeEditorHelpableProviders = new ArrayList<CodeEditorHelpableProvider>();
        for (CodeEditorHelpableProviderReference ref : this.codeEditorHelpableProviders()) {
            boolean nodeTypeOK;
            boolean fileTypeOK;
            block3: {
                fileTypeOK = filetype != null && ref.fileTypeList.contains(filetype) || ref.fileTypeList.isEmpty();
                boolean bl = nodeTypeOK = nodeType != null;
                if (nodeTypeOK && !ref.nodeTypeList.isEmpty()) {
                    for (String refNodeType : ref.nodeTypeList) {
                        nodeTypeOK = ClassUtils.isInstanceOf(nodeType.getClass(), (String)refNodeType);
                        if (!nodeTypeOK) continue;
                        break block3;
                    }
                    nodeTypeOK = false;
                }
            }
            if (!fileTypeOK || !nodeTypeOK) continue;
            codeEditorHelpableProviders.add(ref.getCodeEditorHelpableProvider());
        }
        return codeEditorHelpableProviders;
    }

    private Collection<EditorPluginReference> editorPlugins() {
        if (this.listener == null) {
            this.listener = new Listener();
            CodeEditorHook.get().addHashStructureHookListener(this.listener);
        }
        return this.pluginRefCollection;
    }

    private Collection<CodeEditorHelpableProviderReference> codeEditorHelpableProviders() {
        if (this.listener == null) {
            this.listener = new Listener();
            CodeEditorHook.get().addHashStructureHookListener(this.listener);
        }
        return this.codeEditorHelpableProviderRefCollection;
    }

    private static final class EditorPluginReference {
        private final MetaClass<EditorPlugin> editorPluginClass;
        private final List<String> fileTypeList;
        private final List<String> nodeTypeList;

        public EditorPluginReference(MetaClass<EditorPlugin> editorPluginClass, List<String> fileTypeList, List<String> nodeTypeList) {
            this.fileTypeList = fileTypeList;
            this.nodeTypeList = nodeTypeList;
            this.editorPluginClass = editorPluginClass;
        }

        public synchronized EditorPlugin getEditorPlugin() {
            EditorPlugin editorPlugin = null;
            try {
                editorPlugin = (EditorPlugin)this.editorPluginClass.newInstance();
            }
            catch (Exception e) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create ceditor EditorPlugin provider from class " + this.editorPluginClass.getClassName(), e);
            }
            return editorPlugin;
        }
    }

    private static final class CodeEditorHelpableProviderReference {
        private final MetaClass<CodeEditorHelpableProvider> codeEditorHelpableProviderClass;
        private final List<String> fileTypeList;
        private final List<String> nodeTypeList;

        public CodeEditorHelpableProviderReference(MetaClass<CodeEditorHelpableProvider> codeEditorHelpableProviderClass, List<String> fileTypeList, List<String> nodeTypeList) {
            this.fileTypeList = fileTypeList;
            this.nodeTypeList = nodeTypeList;
            this.codeEditorHelpableProviderClass = codeEditorHelpableProviderClass;
        }

        public synchronized CodeEditorHelpableProvider getCodeEditorHelpableProvider() {
            CodeEditorHelpableProvider codeEditorHelpableProvider = null;
            try {
                codeEditorHelpableProvider = (CodeEditorHelpableProvider)this.codeEditorHelpableProviderClass.newInstance();
            }
            catch (Exception e) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create ceditor CodeEditorHelpableProvider from class " + this.codeEditorHelpableProviderClass.getClassName(), e);
            }
            return codeEditorHelpableProvider;
        }
    }

    private class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void listenerAttached(HashStructureHookEvent e) {
            HashStructure hs = e.getCombinedHashStructure();
            if (hs == null) {
                return;
            }
            this.addCodeEditorHelpableProviders(hs);
            this.addPlugins(hs);
            this.addPluginFactories(hs);
        }

        public void elementVisited(HashStructureHookEvent e) {
            HashStructure hs = e.getNewElementHashStructure();
            if (hs == null) {
                return;
            }
            this.addCodeEditorHelpableProviders(hs);
            this.addPlugins(hs);
            this.addPluginFactories(hs);
        }

        private void addPluginFactories(HashStructure hash) {
            List pluginFactories = hash.getAsList("plugins-factory");
            if (pluginFactories == null) {
                return;
            }
            for (Object o : pluginFactories) {
                HashStructure hs = (HashStructure)o;
                MetaClass factoryMetaClass = LazyClassAdapter.getInstance((HashStructure)hs).getMetaClass("class");
                try {
                    EditorPluginsFactory factory = (EditorPluginsFactory)factoryMetaClass.newInstance();
                    CodeEditor.registerFactoryDirectly(factory);
                }
                catch (InstantiationException e) {
                    Logger.getLogger("global").log(Level.SEVERE, "Cannot Instantiate plugins-factory in " + HashStructureHook.getExtensionId((HashStructure)hs));
                }
                catch (IllegalAccessException e) {
                    Logger.getLogger("global").log(Level.SEVERE, "Cannot access class for plugins-factory in " + HashStructureHook.getExtensionId((HashStructure)hs));
                }
                catch (ClassNotFoundException e) {
                    Logger.getLogger("global").log(Level.SEVERE, "Cannot find class for plugins-factory in " + HashStructureHook.getExtensionId((HashStructure)hs));
                }
            }
        }

        private void addCodeEditorHelpableProviders(HashStructure hash) {
            List plugins = hash.getAsList("helpable-provider");
            if (plugins == null) {
                return;
            }
            for (Object o : plugins) {
                MetaClass clazz = null;
                try {
                    HashStructure hsProvider = (HashStructure)o;
                    clazz = LazyClassAdapter.getInstance((HashStructure)hsProvider).getMetaClass("class");
                    ArrayList<String> fileTypeList = new ArrayList<String>();
                    List fileTypeObjectList = hsProvider.getAsList("filetype");
                    if (fileTypeObjectList != null) {
                        for (Object fileType : fileTypeObjectList) {
                            String typeString = ((HashStructure)fileType).getString("#text");
                            fileTypeList.add(typeString);
                        }
                    }
                    ArrayList<String> nodeTypeList = new ArrayList<String>();
                    List nodeTypeObjectList = hsProvider.getAsList("node-type");
                    if (nodeTypeObjectList != null) {
                        for (Object nodeElement : nodeTypeObjectList) {
                            String nodeType = ((HashStructure)nodeElement).getString("#text");
                            nodeTypeList.add(nodeType);
                        }
                    }
                    CodeEditorHook.this.codeEditorHelpableProviderRefCollection.add(new CodeEditorHelpableProviderReference((MetaClass<CodeEditorHelpableProvider>)clazz, fileTypeList, nodeTypeList));
                }
                catch (Exception e) {
                    Logger.getLogger("IDE").log(Level.SEVERE, "CodeEditorHook: Cannot create helpable-provider " + (clazz == null ? "" : clazz.getClassName()));
                }
            }
        }

        private void addPlugins(HashStructure hash) {
            List plugins = hash.getAsList("plugin");
            if (plugins == null) {
                return;
            }
            for (Object o : plugins) {
                MetaClass clazz = null;
                try {
                    HashStructure hsProvider = (HashStructure)o;
                    clazz = LazyClassAdapter.getInstance((HashStructure)hsProvider).getMetaClass("class");
                    ArrayList<String> fileTypeList = new ArrayList<String>();
                    List fileTypeObjectList = hsProvider.getAsList("filetype");
                    if (fileTypeObjectList != null) {
                        for (Object fileType : fileTypeObjectList) {
                            String typeString = ((HashStructure)fileType).getString("#text");
                            fileTypeList.add(typeString);
                        }
                    }
                    ArrayList<String> nodeTypeList = new ArrayList<String>();
                    List nodeTypeObjectList = hsProvider.getAsList("node-type");
                    if (nodeTypeObjectList != null) {
                        for (Object nodeElement : nodeTypeObjectList) {
                            String nodeType = ((HashStructure)nodeElement).getString("#text");
                            nodeTypeList.add(nodeType);
                        }
                    }
                    CodeEditorHook.this.pluginRefCollection.add(new EditorPluginReference((MetaClass<EditorPlugin>)clazz, fileTypeList, nodeTypeList));
                }
                catch (Exception e) {
                    Logger.getLogger("IDE").log(Level.SEVERE, "CodeEditorHook: Cannot create plugin " + (clazz == null ? "" : clazz.getClassName()));
                }
            }
        }
    }
}

