/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import oracle.ide.Ide;
import oracle.ide.ceditor.CEditorArb;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.util.GhostPaletteUtil;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.ghost.GhostBuilder;
import oracle.javatools.ui.ghost.GhostPalette;

final class EditorSummary {
    private EditorSummary() {
    }

    static void showSummary(BasicEditorPane editor) {
        CodeEditor ce = CodeEditor.getCodeEditor(editor);
        GhostBuilder.GhostBuiltPalette gp = GhostBuilder.build(null, (JComponent)EditorSummary.createContent(editor), (String)(ce.getTabLabel() + " Summary"));
        gp.setOwningComponent((JComponent)editor);
        gp.pack();
        GhostPaletteUtil.show((GhostPalette)gp, (String)"ide.go.to.line", (JLayeredPane)Ide.getMainWindow().getLayeredPane(), (boolean)true);
    }

    private static JComponent createContent(BasicEditorPane editor) {
        LineMap lm = editor.getTextBuffer().getLineMap();
        int pos = editor.getCaretPosition();
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0 4 4 4, gapx 10, gapy 4"));
        String eolType = editor.getTextBuffer().getEOLType();
        String eolTypeText = "";
        eolTypeText = eolType == "\r\n" ? CEditorArb.getString(21) : (eolType == "\n" ? CEditorArb.getString(20) : CEditorArb.getString(19));
        panel.add((Component)new JLabel("Line Terminator:"), "");
        panel.add((Component)new JLabel(eolTypeText), "");
        panel.add((Component)new JLabel("Location:"), "newline");
        panel.add((Component)new JLabel("" + pos + " (of " + editor.getTextBuffer().getLength() + ")"), "");
        panel.add((Component)new JLabel("Line:"), "newline");
        panel.add((Component)new JLabel("" + (editor.getLineFromOffset(pos) + 1) + " (of " + lm.getLineCount() + ")"), "");
        panel.add((Component)new JLabel("Column:"), "newline");
        panel.add((Component)new JLabel("" + (pos - editor.getLineStartOffset(editor.getLineFromOffset(pos)) + 1)), "");
        panel.add((Component)new JLabel("Selection Length:"), "newline");
        panel.add((Component)new JLabel("" + Math.abs(editor.getSelectionEnd() - editor.getSelectionStart())), "");
        int longLine = 1;
        int chars = 0;
        for (int i = 0; i < lm.getLineCount(); ++i) {
            int lineChars = lm.getLineEndOffset(i) - lm.getLineStartOffset(i);
            if (lineChars <= chars) continue;
            chars = lineChars;
            longLine = i + 1;
        }
        panel.add((Component)new JLabel("Longest Line:"), "newline");
        panel.add((Component)new JLabel("Line " + longLine + " (" + chars + " characters)"), "");
        return panel;
    }
}

