/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.plugins.EditorPlugin;

public final class ZoomTextPlugin
implements EditorPlugin {
    private MouseWheelListener listener = new MouseWheelL();
    private BasicEditorPane editor;

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.addMouseWheelListener(this.listener);
    }

    public void deinstall(BasicEditorPane editor) {
        editor.removeMouseWheelListener(this.listener);
        this.editor = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private class MouseWheelL
    implements MouseWheelListener {
        private MouseWheelL() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isControlDown()) {
                int clicks = e.getWheelRotation();
                Rectangle rect = ZoomTextPlugin.this.editor.getVisibleRect();
                rect.setLocation(rect.x, rect.y + rect.height / 2);
                int location = ZoomTextPlugin.this.editor.getUI().viewToModel((JTextComponent)ZoomTextPlugin.this.editor, rect.getLocation());
                Font baseFont = EditorProperties.getProperties().getBaseFont();
                int fontSize = baseFont.getSize();
                fontSize = Math.min(Math.max(7, fontSize - clicks), 24);
                EditorProperties.getProperties().setBaseFont(baseFont.getFontName(), fontSize);
                FontSizeOptions.getInstance((PropertyStorage)Preferences.getPreferences()).setFontSize(fontSize);
                try {
                    Point p = ZoomTextPlugin.this.editor.getUI().modelToView((JTextComponent)ZoomTextPlugin.this.editor, location).getLocation();
                    rect.setLocation(p);
                    rect.setLocation(rect.x, rect.y - rect.height / 2);
                    ZoomTextPlugin.this.editor.scrollRectToVisible(rect);
                }
                catch (BadLocationException f) {
                    // empty catch block
                }
                e.consume();
            } else {
                ZoomTextPlugin.this.editor.getParent().dispatchEvent(e);
            }
        }
    }
}

