/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.insight;

import java.util.HashMap;
import java.util.Map;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.ceditor.insight.InsightBundle;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.popup.HtmlContentProvider;
import oracle.javatools.editor.popup.HtmlPopup;
import oracle.javatools.editor.popup.HtmlPopupView;
import oracle.javatools.editor.popup.PopupEventListener;
import oracle.javatools.editor.popup.StaticHtmlContentProvider;

public abstract class AbstractDocPopupController
implements CodeMenuConstants,
Controller {
    private Class<? extends TextNode> _nodeClass;
    private String _labelWithMnemonic;
    private static IdeAction _showDocAction = IdeAction.find((String)"AbstractDocPopupController.SHOW_DOC_POPUP_CMD");
    private static Map<String, String> _nodeClassNameToLabelMap = new HashMap<String, String>();

    public AbstractDocPopupController(Class<? extends TextNode> nodeClass, String labelWithMnemonic) {
        this._nodeClass = nodeClass;
        this._labelWithMnemonic = labelWithMnemonic;
        _nodeClassNameToLabelMap.put(this._nodeClass.getName(), this._labelWithMnemonic);
    }

    public void shutdown() {
    }

    protected abstract boolean isEnabled(Context var1);

    protected abstract HtmlContentProvider getContentProvider(Context var1) throws Exception;

    public boolean update(IdeAction action, Context context) {
        int cmdID = action.getCommandId();
        if (cmdID == _showDocAction.getCommandId()) {
            boolean enable = false;
            if (context.getProject() != null || !this.isProjectRequired()) {
                View view = context.getView();
                Node node = context.getNode();
                if (view instanceof CodeEditor && this._nodeClass.isInstance(node)) {
                    enable = this.isEnabled(context);
                    action.setEnabled(enable);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(IdeAction action, Context context) {
        View view;
        int cmdID = action.getCommandId();
        if (cmdID == _showDocAction.getCommandId() && (context.getProject() != null || !this.isProjectRequired()) && (view = context.getView()) instanceof CodeEditor && this._nodeClass.isInstance(context.getNode())) {
            CodeEditor codeEditor = (CodeEditor)view;
            BasicEditorPane editorPane = codeEditor.getFocusedEditorPane();
            WaitCursor cursor = Ide.getWaitCursor();
            try {
                HtmlPopupView htmlPopupView;
                cursor.show();
                HtmlContentProvider contentProvider = this.getContentProvider(context);
                if (contentProvider == null) {
                    String message = InsightBundle.get("POPUP_MSG_NO_DOC");
                    contentProvider = new StaticHtmlContentProvider(message);
                }
                if ((htmlPopupView = HtmlPopup.invokePopup((BasicEditorPane)editorPane, (HtmlContentProvider)contentProvider)) != null) {
                    Listener listener = new Listener(editorPane, htmlPopupView);
                    editorPane.addCaretListener((CaretListener)listener);
                    htmlPopupView.addPopupEventListener((PopupEventListener)listener);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                cursor.hide();
            }
            return true;
        }
        return false;
    }

    protected boolean isProjectRequired() {
        return true;
    }

    private static class Listener
    implements CaretListener,
    PopupEventListener {
        private BasicEditorPane _editorPane;
        private HtmlPopupView _htmlPopupView;

        private Listener(BasicEditorPane editorPane, HtmlPopupView htmlPopupView) {
            this._editorPane = editorPane;
            this._htmlPopupView = htmlPopupView;
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            HtmlPopup.cancelPopup((BasicEditorPane)this._editorPane);
        }

        public void popupCanceled() {
        }

        public void contentsChanged() {
        }

        public void popupClosed() {
            this._editorPane.removeCaretListener((CaretListener)this);
            this._htmlPopupView.removePopupEventListener((PopupEventListener)this);
        }
    }
}

