/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.adf.share.ResourceKey;
import oracle.adf.share.config.resources.Messages;

public class ADFShareException
extends RuntimeException {
    private static final long serialVersionUID = -8736629172160108623L;
    private static ResourceBundle sBundle;
    private Throwable mCause;
    private String mMessage;
    private static final String MSGID = ".MSGID";
    private ResourceKey rKey = ResourceKey.DEFAULT;

    public static void init(String baseName) throws MissingResourceException {
        sBundle = ResourceBundle.getBundle(baseName);
    }

    @Deprecated
    public ADFShareException(String message) {
        super(message);
    }

    @Deprecated
    public ADFShareException(String message, Throwable cause) {
        super(message, cause);
    }

    public ADFShareException(Throwable cause) {
        super(cause);
    }

    public ADFShareException() {
        this(ResourceKey.DEFAULT);
    }

    public ADFShareException(ResourceKey key) {
        this.rKey = key;
        this.mMessage = this.createLocalizedMessage(null);
    }

    public ADFShareException(ResourceKey key, Throwable cause) {
        this(key);
        this.mCause = cause;
    }

    public ADFShareException(ResourceKey key, Throwable cause, Object ... args) {
        this(key, cause);
        this.mMessage = this.createLocalizedMessage(args);
    }

    private String createLocalizedMessage(Object[] args) {
        String resourceKey = this.rKey.toString();
        String msg = sBundle.getString(resourceKey);
        String err = this.getErrorId();
        if (args != null) {
            MessageFormat format = new MessageFormat(msg);
            msg = format.format(args);
        }
        msg = err + ": " + msg;
        return msg;
    }

    public String getMMessage() {
        return this.mMessage;
    }

    @Override
    public Throwable getCause() {
        return this.mCause;
    }

    public String getErrorId() {
        String resourceKey = this.rKey.toString();
        String errorKey = resourceKey + MSGID;
        String err = sBundle.getString(errorKey);
        return err;
    }

    static {
        ADFShareException.init(Messages.class.getName());
    }
}

