/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.directory.Attributes;
import javax.naming.event.NamingListener;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.jndi.AdfConnectionsJndiContext;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.adf.share.jndi.ConnectionEventContext;
import oracle.adf.share.jndi.ContextImpl;
import oracle.adf.share.jndi.ContextSaveListener;
import oracle.adf.share.jndi.DOMBackingStoreListener;
import oracle.adf.share.jndi.NameParserImpl;
import oracle.adf.share.logging.ADFLogger;
import oracle.adfinternal.share.jndi.AdfConnectionsJndiContextInternal;
import org.w3c.dom.Document;

public class AdfInitialContext
extends InitialContext
implements AdfConnectionsJndiContextInternal,
ConnectionEventContext {
    private static ADFLogger logger = null;
    private AdfJndiContext mAdfCtx = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdfInitialContext newAdfInitialContext(Hashtable env, Class referenceClazz) throws NamingException {
        if (!ClassUtils.OSGI_BUDDY_MODE) {
            return new AdfInitialContext(env);
        }
        Thread curr = Thread.currentThread();
        ClassLoader prevLoader = curr.getContextClassLoader();
        try {
            curr.setContextClassLoader(referenceClazz.getClassLoader());
            AdfInitialContext adfInitialContext = new AdfInitialContext(env);
            return adfInitialContext;
        }
        finally {
            curr.setContextClassLoader(prevLoader);
        }
    }

    public AdfInitialContext(Hashtable env) throws NamingException {
        super(env);
        if (this.defaultInitCtx instanceof AdfJndiContext) {
            this.mAdfCtx = (AdfJndiContext)this.defaultInitCtx;
        }
    }

    @Override
    public void close() throws NamingException {
        super.close();
        this.mAdfCtx = null;
    }

    @Override
    public void reload() throws NamingException {
        this.checkSupported();
        this.mAdfCtx.reload();
    }

    @Override
    public void saveAs(String url) throws NamingException {
        this.checkSupported();
        this.mAdfCtx.saveAs(url);
    }

    @Override
    public void save() throws NamingException {
        this.checkSupported();
        this.mAdfCtx.save();
    }

    @Override
    public Map<String, Reference> getReferenceMap() throws NamingException {
        this.checkSupported();
        return this.mAdfCtx.getReferenceMap();
    }

    public boolean hasChanged() throws NamingException {
        this.checkSupported();
        if (this.isContextImpl()) {
            return ((ContextImpl)this.mAdfCtx).hasChanged();
        }
        throw new OperationNotSupportedException("Context not an instance of ContextImpl");
    }

    public boolean isAdfJndiContext() {
        return this.mAdfCtx != null;
    }

    public boolean isReadOnlyContext() {
        if (this.isContextImpl()) {
            return ((ContextImpl)this.mAdfCtx).isDocumentBackingStoreReadOnly();
        }
        return false;
    }

    private void checkSupported() throws OperationNotSupportedException {
        if (this.mAdfCtx == null) {
            throw new OperationNotSupportedException("Context not an instance of AdfJndiContext");
        }
    }

    private boolean isContextImpl() {
        return this.mAdfCtx instanceof ContextImpl;
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        if (!this.isContextImpl()) {
            throw new OperationNotSupportedException("Context not an instance of ContextImpl");
        }
        ((ContextImpl)this.mAdfCtx).addNamingListener(target, scope, l);
    }

    @Override
    public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        this.addNamingListener(NameParserImpl.getInstance().parse(target), scope, l);
    }

    @Override
    public void removeNamingListener(NamingListener l) throws NamingException {
        if (!this.isContextImpl()) {
            throw new OperationNotSupportedException("Context not an instance of ContextImpl");
        }
        ((ContextImpl)this.mAdfCtx).removeNamingListener(l);
    }

    @Override
    public void addContextSaveListener(ContextSaveListener l) throws NamingException {
        this.addNamingListener("", 0, (NamingListener)l);
    }

    @Override
    public void removeContextSaveListener(ContextSaveListener l) throws NamingException {
        this.removeNamingListener(l);
    }

    @Override
    public boolean targetMustExist() {
        return true;
    }

    private static ADFLogger getLogger() {
        if (logger == null) {
            logger = ADFLogger.createADFLogger((String)"oracle.adf.share.jndi.AdfInitialContext");
        }
        return logger;
    }

    public static AdfInitialContext createDOMBasedConnectionsContext(String namedContext, Document refDoc, boolean isReadOnly, DOMBackingStoreListener listener) throws NamingException {
        Hashtable<String, Object> mContextEnv = new Hashtable<String, Object>();
        mContextEnv.put("java.naming.factory.initial", "oracle.adf.share.jndi.InitialContextFactoryImpl");
        if (namedContext != null) {
            mContextEnv.put("named.adf.context", namedContext);
        }
        mContextEnv.put("oracle.adf.share.jndi.documentstore", "oracle.adf.share.jndi.DOMBackingStore");
        mContextEnv.put("java.naming.provider.url", refDoc);
        if (isReadOnly) {
            mContextEnv.put("oracle.adf.share.jndi.DocumentBackingStore.isReadOnly", isReadOnly);
        }
        if (listener != null) {
            mContextEnv.put("oracle.adf.share.jndi.DOMBackingStore.listener", listener);
        }
        if (AdfInitialContext.getLogger().isFine()) {
            AdfInitialContext.getLogger().log(Level.FINE, "Creating DOMBackingStore based Connections Context");
        }
        return new AdfInitialContext((Hashtable)mContextEnv);
    }

    @Override
    public Attributes getMetadataAttributes(String name) throws NamingException {
        this.checkSupported();
        if (this.mAdfCtx instanceof AdfConnectionsJndiContext) {
            return ((AdfConnectionsJndiContext)this.mAdfCtx).getMetadataAttributes(name);
        }
        throw new OperationNotSupportedException();
    }

    @Override
    public void setMetadataAttribute(String connName, String attrName, String val) throws NamingException {
        this.checkSupported();
        if (!(this.mAdfCtx instanceof AdfConnectionsJndiContext)) {
            throw new OperationNotSupportedException();
        }
        ((AdfConnectionsJndiContext)this.mAdfCtx).setMetadataAttribute(connName, attrName, val);
    }

    @Override
    public void clearCustomizations() throws Exception {
        this.checkSupported();
        if (!(this.mAdfCtx instanceof AdfConnectionsJndiContextInternal)) {
            throw new OperationNotSupportedException();
        }
        ((AdfConnectionsJndiContextInternal)this.mAdfCtx).clearCustomizations();
    }
}

