/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.adf.share.logging.ADFLogger;

public class ConnectionReferenceEL
extends AbstractMap {
    private Map<String, Reference> map = null;
    private AdfJndiContext ctx = null;
    private static ADFLogger logger = null;

    public ConnectionReferenceEL() {
        this.map = Collections.emptyMap();
    }

    public ConnectionReferenceEL(AdfJndiContext connCtx) {
        Map<String, Reference> mapVal = null;
        try {
            mapVal = connCtx.getReferenceMap();
        }
        catch (NamingException e) {
            logger.warning("Unable to get references fromm the connections Context", (Throwable)e);
        }
        this.ctx = connCtx;
        this.map = mapVal == null ? Collections.emptyMap() : mapVal;
    }

    @Override
    public Set entrySet() {
        MyEntrySet mes = new MyEntrySet(this.map.entrySet());
        return mes;
    }

    public ADFLogger getLogger() {
        if (logger == null) {
            logger = ADFLogger.createADFLogger(this.getClass());
        }
        return logger;
    }

    private class ELIterator
    implements Iterator {
        private Iterator itr = null;

        public ELIterator(Iterator iterator) {
            this.itr = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            final Map.Entry obj = (Map.Entry)this.itr.next();
            String key = (String)obj.getKey();
            try {
                Object conn = ConnectionReferenceEL.this.ctx.lookup(key);
                if (ConnectionReferenceEL.this.getLogger().isFinest()) {
                    ConnectionReferenceEL.this.getLogger().finest("Object corresponding to key: " + key + " is \n" + conn);
                }
                if (conn instanceof Map) {
                    Map.Entry b = new Map.Entry(){
                        private Map mapVal = null;

                        public String getKey() {
                            return (String)obj.getKey();
                        }

                        public Map getValue() {
                            return this.mapVal;
                        }

                        public Object setValue(Object value) {
                            this.mapVal = (Map)value;
                            return this.mapVal;
                        }

                        @Override
                        public boolean equals(Object obj2) {
                            return this.mapVal.equals(obj2);
                        }

                        @Override
                        public int hashCode() {
                            return this.mapVal.hashCode();
                        }
                    };
                    b.setValue(conn);
                    return b;
                }
            }
            catch (NamingException e) {
                ConnectionReferenceEL.this.getLogger().severe("Unable to iterate to the next object", (Throwable)e);
            }
            return obj;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support removal");
        }
    }

    private class MyEntrySet
    extends AbstractSet {
        Set entrySet = null;

        public MyEntrySet(Set es) {
            this.entrySet = es;
        }

        @Override
        public int size() {
            return 50;
        }

        @Override
        public Iterator iterator() {
            return new ELIterator(this.entrySet.iterator());
        }

        @Override
        public boolean contains(Object key) {
            return false;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("ConnectionReference.entrySet.remove not supported");
        }

        @Override
        public void clear() {
            ConnectionReferenceEL.this.clear();
        }
    }
}

