/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.event.NamingListener;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.connection.metadata.AttributeValues;
import oracle.adf.share.jndi.BindingsEnumerator;
import oracle.adf.share.jndi.ConnectionEventContext;
import oracle.adf.share.jndi.ConnectionReference;
import oracle.adf.share.jndi.ContextSaveListener;
import oracle.adf.share.jndi.DocumentBackingStore;
import oracle.adf.share.jndi.DocumentHelper;
import oracle.adf.share.jndi.EventContextHelper;
import oracle.adf.share.jndi.FileSystemBackingStore;
import oracle.adf.share.jndi.MetadataRefAddr;
import oracle.adf.share.jndi.NameClassEnumerator;
import oracle.adf.share.jndi.NameParserImpl;
import oracle.adf.share.jndi.ProviderProperties;
import oracle.adf.share.jndi.ReferenceStoreHelper;
import oracle.adf.share.jndi.xml.v2.ReferenceListType;
import oracle.adf.share.logging.ADFLogger;
import oracle.adfinternal.share.jndi.AdfConnectionsJndiContextInternal;
import oracle.adfinternal.share.jndi.ClientObjectCache;
import oracle.adfinternal.share.jndi.ConnectionClientObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ContextImpl
implements AdfConnectionsJndiContextInternal,
ProviderProperties,
ConnectionEventContext {
    private Hashtable mEnv = null;
    private transient DocumentBackingStore mStore = null;
    private transient Hashtable mBindings;
    private transient Object mRefStoreLock = new Object();
    private transient ReferenceStoreHelper mRefStore = new ReferenceStoreHelper();
    public static final String namespaceURI = "http://xmlns.oracle.com/adf/jndi";
    private ADFLogger mLogger = null;
    private EventContextHelper eventCtxHelper = null;
    public static final String APPLICATION_LEVEL_CACHE_KEY = "_cache_application_scope_";
    public static final String ENABLE_CONNECTIONS_CACHING = "_cache_application_scope_";
    public static final String SITE_LAYER_CONNECTIONS_CONTEXT = "SITE_LAYER_CONNECTIONS_CONTEXT";
    private transient Map referencesMap = null;
    private static final String resourceBundle = "oracle.adf.share.jndi.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.jndi.resources.Messages");
    private static final String NAME_KEY_SEP = "@$$@";

    ContextImpl(Hashtable env) throws NamingException {
        this.mEnv = env;
        this.init();
    }

    public boolean hasChanged() throws NamingException {
        boolean hasChanged = false;
        if (this.mStore != null) {
            hasChanged = this.mStore.hasChanged(this.getDocumentUrl());
        }
        return hasChanged;
    }

    private Exists[] getExists(Name name) throws NamingException {
        Exists[] ret = new Exists[2];
        String id = this.getMyComponents(name);
        int i = id.indexOf(NAME_KEY_SEP);
        String appData = (String)this.mEnv.get("__adf_share_ref_app_data__");
        if (i != -1) {
            ret[0] = new Exists(id);
            if (this.exists(id)) {
                ret[0].exists = true;
                return ret;
            }
            name = NameParserImpl.getInstance().parse(id.substring(0, i));
        } else if (appData != null && appData.length() > 0) {
            String bigId = id + NAME_KEY_SEP + appData;
            ret[0] = new Exists(bigId);
            if (this.exists(bigId)) {
                ret[0].exists = true;
                return ret;
            }
        }
        ret[1] = new Exists(id);
        ret[1].exists = this.exists(id);
        return ret;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Exists[] ide = this.getExists(name);
        if (ide[0] != null && ide[0].exists) {
            return this.findObject(NameParserImpl.getInstance().parse(ide[0].id));
        }
        return this.findObject(NameParserImpl.getInstance().parse(ide[1].id));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        long start = System.currentTimeMillis();
        String id = this.getId(name);
        name = this.getName(name);
        this.checkIfNameExists(id);
        this.bindObject(name, obj);
        Binding binding = new Binding(id, obj.getClass().getName(), obj, true);
        this.fireObjAddEvent(binding);
        long end = System.currentTimeMillis();
        this.getLogger().finest(resBundle.getString("BINDING_PERFORMANCE"), new Object[]{name.toString(), end - start});
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(NameParserImpl.getInstance().parse(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        String id = this.getId(name);
        name = this.getName(name);
        Binding oldBinding = this.getOldBinding(id, name);
        this.removeObject(name);
        this.bindObject(name, obj);
        Binding newBinding = new Binding(id, obj.getClass().getName(), obj, true);
        this.fireObjChangeEvent(oldBinding, newBinding);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(NameParserImpl.getInstance().parse(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        String id = this.getId(name);
        name = this.getName(name);
        Binding binding = this.getOldBinding(id, name);
        this.removeObject(name);
        this.fireObjRemoveEvent(binding);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(NameParserImpl.getInstance().parse(oldName), NameParserImpl.getInstance().parse(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new OperationNotSupportedException();
        }
        return new NameClassEnumerator(this);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(NameParserImpl.getInstance().parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new OperationNotSupportedException();
        }
        return new BindingsEnumerator(this);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return NameParserImpl.getInstance();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(NameParserImpl.getInstance().parse(name), NameParserImpl.getInstance().parse(prefix)).toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.mEnv.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.mEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.mEnv.clone();
    }

    @Override
    public void close() throws NamingException {
        this.saveDocument(this.getDocumentUrl());
        this.eventCtxHelper.clearAllNamingListeners();
        this.eventCtxHelper = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Attributes getMetadataAttributes(String connName) throws NamingException {
        Object conn = this.lookup(connName);
        BasicAttributes attrs = new BasicAttributes();
        Reference ref = this.getObjectReference(conn);
        Enumeration<RefAddr> enumx = ref.getAll();
        RefAddr address = null;
        while (enumx.hasMoreElements()) {
            address = enumx.nextElement();
            if (!(address instanceof MetadataRefAddr)) continue;
            attrs.put(address.getType(), address.getContent());
        }
        return attrs;
    }

    @Override
    public void setMetadataAttribute(String connName, String propertyName, String propertyValue) throws NamingException {
        Object conn = this.lookup(connName);
        if (!(conn instanceof AttributeValues)) {
            throw new OperationNotSupportedException(resBundle.getString("CONN_NO_SET_META_ATTR"));
        }
        ((AttributeValues)conn).setMetadataAttribute(propertyName, propertyValue);
        this.rebind(connName, conn);
    }

    protected void checkIfNameExists(String id) throws NamingException {
        if (this.exists(id)) {
            throw new NameAlreadyBoundException(id);
        }
    }

    protected void fireObjChangeEvent(Binding oldBinding, Binding newBinding) throws NamingException {
        this.eventCtxHelper.fireObjectChangedEvent(newBinding, oldBinding);
    }

    protected void fireObjRemoveEvent(Binding binding) throws NamingException {
        this.eventCtxHelper.fireObjectRemovedEvent(binding);
    }

    protected void fireObjAddEvent(Binding binding) throws NamingException {
        this.eventCtxHelper.fireObjectAddedEvent(binding);
    }

    protected Name getName(Name name) throws NamingException {
        String id = this.getMyComponents(name);
        if (id.indexOf(NAME_KEY_SEP) == -1) {
            String appData = (String)this.mEnv.get("__adf_share_ref_app_data__");
            if (appData != null) {
                id = id + NAME_KEY_SEP + appData;
            }
            name = this.getNameParser((Name)null).parse(id);
        }
        return name;
    }

    protected String getId(Name name) throws NamingException {
        String appData;
        String id = this.getMyComponents(name);
        if (id.indexOf(NAME_KEY_SEP) == -1 && (appData = (String)this.mEnv.get("__adf_share_ref_app_data__")) != null) {
            id = id + NAME_KEY_SEP + appData;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Binding getOldBinding(String id, Name name) throws NamingException {
        Object oldObj = null;
        Binding oldBinding = new Binding(id, (Object)null);
        if (this.exists(id)) {
            try {
                this.addToEnvironment("AdfJndiHelper_IsConnectionInitRequired", false);
                oldObj = this.lookup(name);
                oldBinding = new Binding(id, oldObj.getClass().getName(), oldObj, true);
            }
            catch (PartialResultException pre) {
                oldObj = pre.getResolvedObj();
            }
            catch (Exception e) {
                this.getLogger().fine("Failure occured trying to rebind " + id, (Throwable)e);
            }
            finally {
                this.removeFromEnvironment("AdfJndiHelper_IsConnectionInitRequired");
            }
        }
        return oldBinding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws NamingException {
        if (this.cacheEnabled()) {
            this.mBindings = new Hashtable(12);
        }
        this.initDocStoreAndEventContext();
        ADFContext prevCtx = ADFContext.hasCurrent() ? ADFContext.getCurrent() : null;
        ADFContext tmpCtx = null;
        try {
            tmpCtx = this.setupNamedContextIfNeeded(prevCtx);
            if (Boolean.TRUE.toString().equalsIgnoreCase((String)this.mEnv.get("_cache_application_scope_"))) {
                boolean scopeCache = true;
                if (this.mStore instanceof ClientObjectCache) {
                    ClientObjectCache clientObjectCache = (ClientObjectCache)((Object)this.mStore);
                    boolean bl = scopeCache = !clientObjectCache.isCaching();
                }
                if (scopeCache) {
                    Map<String, Object> map = ADFContext.getCurrent().getApplicationScope();
                    if (map.containsKey("_cache_application_scope_")) {
                        this.setReferencesMap((Map)map.get("_cache_application_scope_"));
                        this.mRefStore.init(null, this, this.mEnv);
                        return;
                    }
                } else if (this.getCachedReferencesMap() != null) {
                    this.mRefStore.init(null, this, this.mEnv);
                    this.setReferencesMap(this.getCachedReferencesMap());
                    return;
                }
            }
            this.load();
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
        finally {
            if (prevCtx != null) {
                prevCtx.setAsCurrent();
            } else if (tmpCtx != null) {
                tmpCtx.removeAsCurrent();
            }
        }
    }

    private void initDocStoreAndEventContext() throws NamingException {
        String url = this.getDocumentUrl();
        this.mStore = this.createDocumentBackingStore();
        this.eventCtxHelper = new EventContextHelper(this);
        try {
            this.mStore.initialize(this.mEnv, url);
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    boolean isDocumentBackingStoreReadOnly() {
        return this.mStore.isReadOnly();
    }

    protected DocumentBackingStore createDocumentBackingStore() throws NamingException {
        this.mEnv.put("oracle.adf.share.jndi.context", this);
        this.mEnv.put("oracle.adf.share.jndi.ClientObjectFactory", "oracle.adfinternal.share.jndi.ConnectionClientObjectFactory");
        String storeClassName = (String)this.mEnv.get("oracle.adf.share.jndi.documentstore");
        if (this.getLogger().isFine()) {
            this.getLogger().log(Level.FINE, "Backing Store :" + storeClassName);
        }
        if (storeClassName != null && storeClassName.length() > 0) {
            try {
                Class cls = ClassUtils.forName((String)storeClassName, ContextImpl.class);
                if (!DocumentBackingStore.class.isAssignableFrom(cls)) {
                    throw new NamingException(MessageFormat.format(resBundle.getString("NOT_ASSIGNABLE_DOC"), storeClassName, DocumentBackingStore.class.getName()));
                }
                return (DocumentBackingStore)cls.newInstance();
            }
            catch (InstantiationException ex) {
                this.throwNamingException(ex);
            }
            catch (IllegalAccessException ex) {
                this.throwNamingException(ex);
            }
            catch (ClassNotFoundException ex) {
                this.throwNamingException(ex);
            }
        }
        return new FileSystemBackingStore();
    }

    public ADFLogger getLogger() {
        if (this.mLogger == null) {
            this.mLogger = ADFLogger.createADFLogger(this.getClass());
        }
        return this.mLogger;
    }

    @Override
    public Map<String, Reference> getReferenceMap() throws NamingException {
        Map references = this.getReferencesMap();
        if (references == null) {
            references = this.mRefStore.getReferencesMap();
            this.setReferencesMap(references);
        }
        return references;
    }

    private void setReferencesMap(Map references) {
        this.referencesMap = references;
    }

    private Map getCachedReferencesMap() throws NamingException {
        return this.getReferencesMap(false, false);
    }

    private Map getUpdatableReferencesMap() throws NamingException {
        return this.getReferencesMap(true, true);
    }

    private Map getReferencesMap() throws NamingException {
        return this.getReferencesMap(false, true);
    }

    private Map getReferencesMap(boolean update, boolean create) throws NamingException {
        Map<String, Reference> references = this.referencesMap;
        if (this.mEnv.get("_cache_application_scope_") != null && this.mStore instanceof ClientObjectCache) {
            try {
                ClientObjectCache clientObjectCache = (ClientObjectCache)((Object)this.mStore);
                if (clientObjectCache.isCaching()) {
                    String url = this.getDocumentUrl();
                    Object cached = null;
                    cached = create ? (update ? clientObjectCache.getUpdatableClientObject(url, references) : clientObjectCache.getClientObject(url, references)) : clientObjectCache.getCachedClientObject(url);
                    if (cached instanceof ConnectionClientObject) {
                        ConnectionClientObject connectionClientObject = (ConnectionClientObject)cached;
                        references = connectionClientObject.getReferencesMap();
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().fine(e.getLocalizedMessage(), (Throwable)e);
                this.throwNamingException(e);
            }
        }
        return references;
    }

    private void throwNamingException(Exception ex) throws NamingException {
        NamingException nex;
        if (ex instanceof NamingException) {
            nex = (NamingException)ex;
        } else {
            nex = new NamingException(ex.getMessage());
            nex.setRootCause(ex);
        }
        throw nex;
    }

    private String getDocumentUrl() throws NamingException {
        Object providerURL = this.mEnv.get("java.naming.provider.url");
        String url = null;
        if (providerURL instanceof String) {
            url = (String)providerURL;
        }
        if (providerURL == null) {
            throw new NamingException(resBundle.getString("MISSING_URL"));
        }
        this.getLogger().finest(resBundle.getString("PROVIDER_URL"), (Object)url);
        return url;
    }

    private String getMyComponents(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException(MessageFormat.format(resBundle.getString("EXTRA_NAME_COMPONENTS"), name.toString()));
            }
            return name.get(0);
        }
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object findObject(Name name) throws NamingException {
        Object refObj;
        String id = this.getMyComponents(name);
        Object bound = null;
        if (this.cacheEnabled() && (bound = (Object)this.mBindings.get(id)) != null) {
            return bound;
        }
        Reference ref = null;
        Map references = this.getReferencesMap();
        if (references != null) {
            refObj = references.get(id);
            if (refObj instanceof Throwable) {
                NamingException ne = new NamingException(((Throwable)refObj).getMessage());
                ne.setRootCause((Throwable)refObj);
                throw ne;
            }
            ref = (Reference)refObj;
        }
        refObj = this.mRefStoreLock;
        synchronized (refObj) {
            ADFContext prevCtx = ADFContext.hasCurrent() ? ADFContext.getCurrent() : null;
            ADFContext tmpCtx = null;
            try {
                tmpCtx = this.setupNamedContextIfNeeded(prevCtx);
                bound = this.mRefStore.getObjectForReference(id, ref, true);
            }
            catch (Exception e) {
                this.throwNamingException(e);
            }
            finally {
                if (prevCtx != null) {
                    prevCtx.setAsCurrent();
                } else if (tmpCtx != null) {
                    tmpCtx.removeAsCurrent();
                }
            }
        }
        if (bound == null) {
            NameNotFoundException nnfe = new NameNotFoundException();
            nnfe.setRemainingName(name);
            throw nnfe;
        }
        if (bound instanceof ConnectionReference && ((ConnectionReference)bound).isPartial()) {
            PartialResultException pre = new PartialResultException(resBundle.getString("INCOMPLETE_RESULTS"));
            pre.setResolvedObj(bound);
            throw pre;
        }
        if (this.cacheEnabled()) {
            this.mBindings.put(id, bound);
        }
        return bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindObject(Name name, Object obj) throws NamingException {
        if (this.mStore == null || this.mStore.isReadOnly()) {
            throw new NamingException(resBundle.getString("READ_ONLY_STORE"));
        }
        Reference reference = this.getObjectReference(obj);
        String id = this.getMyComponents(name);
        Object object = this.mRefStoreLock;
        synchronized (object) {
            this.mRefStore.addReference(id, reference);
            this.getUpdatableReferencesMap().put(id, reference);
        }
    }

    private Reference getObjectReference(Object obj) throws OperationNotSupportedException, NamingException {
        Reference reference = null;
        if (obj instanceof Reference) {
            reference = (Reference)obj;
        } else if (obj instanceof Referenceable) {
            reference = ((Referenceable)obj).getReference();
        } else {
            throw new OperationNotSupportedException(resBundle.getString("INVALID_OBJECT_TYPE"));
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeObject(Name name) throws NamingException {
        if (this.mStore == null || this.mStore.isReadOnly()) {
            throw new NamingException("READ_ONLY_STORE");
        }
        String id = this.getMyComponents(name);
        if (this.cacheEnabled()) {
            this.mBindings.remove(id);
        }
        Object object = this.mRefStoreLock;
        synchronized (object) {
            this.mRefStore.removeReference(id);
            this.getUpdatableReferencesMap().remove(id);
        }
    }

    private boolean exists(Name name) throws NamingException {
        String id = this.getMyComponents(name);
        return this.exists(id);
    }

    private boolean exists(String id) throws NamingException {
        Object bound;
        if (this.cacheEnabled() && (bound = this.mBindings.get(id)) != null) {
            return true;
        }
        Map references = this.getReferencesMap();
        if (references != null) {
            return references.containsKey(id);
        }
        return this.mRefStore.exists(id);
    }

    private ReferenceListType createReferenceListType(Document doc) {
        Element element = doc.getDocumentElement();
        NodeList childNodes = element.getChildNodes();
        if (childNodes.getLength() <= 0) {
            return null;
        }
        ReferenceListType references = new ReferenceListType();
        references.getReference().addAll(DocumentHelper.getReference(childNodes));
        return references;
    }

    private void initReferencesFromDocument(String url) throws Exception {
        Document doc = this.mStore.readDocument(url);
        this.mRefStore.init(this.createReferenceListType(doc), this, this.mEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws NamingException {
        ADFContext prevCtx = ADFContext.hasCurrent() ? ADFContext.getCurrent() : null;
        ADFContext tmpCtx = null;
        try {
            tmpCtx = this.setupNamedContextIfNeeded(prevCtx);
            String url = this.getDocumentUrl();
            if (this.mStore != null && this.mStore.documentExists(url)) {
                this.initReferencesFromDocument(url);
            } else {
                this.mRefStore.init(null, this, this.mEnv);
            }
            Map references = this.mRefStore.getReferencesMapEx(true);
            this.setReferencesMap(references);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
        finally {
            if (prevCtx != null) {
                prevCtx.setAsCurrent();
            } else if (tmpCtx != null) {
                tmpCtx.removeAsCurrent();
            }
        }
    }

    private ADFContext setupNamedContextIfNeeded(ADFContext prevCtx) throws Exception {
        ADFContext tmpCtx = null;
        String ctxName = (String)this.mEnv.get("named.adf.context");
        if (ctxName != null && ctxName.length() > 0 && ADFContext.isNamedContextRegistered(ctxName) && (tmpCtx = ADFContext.get(ctxName)) != prevCtx) {
            tmpCtx.setAsCurrent();
        }
        return tmpCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocument(String url) throws NamingException {
        ReferenceListType saveableReferences;
        if (!this.mStore.isReadOnly() && (saveableReferences = this.mRefStore.getSaveableReferences()) != null) {
            try {
                this.mRefStore.saveCredentials();
                Document doc = this.mStore.createDocument(url);
                if (doc != null) {
                    DocumentHelper.buildConnectionsDocument(doc, saveableReferences);
                }
                this.mStore.writeDocument(doc, url);
                this.mStore.closeDocument(url);
                this.eventCtxHelper.fireContextSavedEvent();
            }
            catch (Exception ex) {
                this.throwNamingException(ex);
            }
            finally {
                saveableReferences = null;
            }
        }
    }

    @Override
    public void reload() throws NamingException {
        this.load();
    }

    @Override
    public void save() throws NamingException {
        this.saveDocument(this.getDocumentUrl());
    }

    @Override
    public void saveAs(String url) throws NamingException {
        this.saveDocument(url);
    }

    ReferenceStoreHelper getReferenceStoreHelper() {
        return this.mRefStore;
    }

    private boolean cacheEnabled() {
        return false;
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        this.eventCtxHelper.addNamingListener(target, scope, l);
    }

    @Override
    public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        this.addNamingListener(NameParserImpl.getInstance().parse(target), scope, l);
    }

    @Override
    public void removeNamingListener(NamingListener l) throws NamingException {
        this.eventCtxHelper.removeNamingListener(l);
    }

    @Override
    public void addContextSaveListener(ContextSaveListener l) throws NamingException {
        this.addNamingListener("", 0, (NamingListener)l);
    }

    @Override
    public void removeContextSaveListener(ContextSaveListener l) throws NamingException {
        this.removeNamingListener(l);
    }

    @Override
    public boolean targetMustExist() {
        return true;
    }

    @Override
    public void clearCustomizations() throws Exception {
        if (this.mStore == null || this.mStore.isReadOnly()) {
            throw new NamingException("READ_ONLY_STORE");
        }
        Class storeCls = null;
        storeCls = ClassUtils.forName((String)"oracle.adf.share.jndi.MDSBackingStore", this.getClass());
        if (this.mStore == null || !storeCls.isInstance(this.mStore)) {
            throw new OperationNotSupportedException();
        }
        Method clrSess = storeCls.getMethod("clearSession", null);
        clrSess.invoke((Object)this.mStore, new Object[0]);
        Method clrCust = storeCls.getMethod("clearCustomizations", null);
        clrCust.invoke((Object)this.mStore, new Object[0]);
    }

    private static class Exists {
        String id = null;
        boolean exists = false;

        public Exists(String id) {
            this.id = id;
        }

        public final boolean isNull() {
            return this.id == null;
        }

        public Name getName() throws NamingException {
            return NameParserImpl.getInstance().parse(this.id);
        }
    }
}

