/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.adf.share.jndi.ConnectionException;
import oracle.adf.share.jndi.ConnectionReference;
import oracle.adf.share.jndi.MetadataRefAddr;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.adf.share.jndi.XmlRefAddr;
import oracle.adf.share.jndi.xml.v2.AnyXmlType;
import oracle.adf.share.jndi.xml.v2.MetadataRefAddrType;
import oracle.adf.share.jndi.xml.v2.PropertyType;
import oracle.adf.share.jndi.xml.v2.RefAddrType;
import oracle.adf.share.jndi.xml.v2.RefAddressListType;
import oracle.adf.share.jndi.xml.v2.ReferenceFactoryType;
import oracle.adf.share.jndi.xml.v2.ReferenceListType;
import oracle.adf.share.jndi.xml.v2.ReferenceType;
import oracle.adf.share.jndi.xml.v2.SecureRefAddrType;
import oracle.adf.share.jndi.xml.v2.StringRefAddrType;
import oracle.adf.share.jndi.xml.v2.XmlRefAddrType;
import oracle.adf.share.logging.ADFLogger;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.schemavalidator.XSDValidator;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DocumentHelper {
    protected List reference;
    public static final String NAMESPACE_ADF_JNDI = "http://xmlns.oracle.com/adf/jndi";
    public static String REFERENCES = "References";
    static String REFERENCE = "Reference";
    private static String STRING_REFADDR = "StringRefAddr";
    private static String SECURE_REFADDR = "SecureRefAddr";
    private static String XML_REFADDR = "XmlRefAddr";
    private static String METADATA_REFADDR = "MetadataRefAddr";
    private static String ADDR_TYPE = "addrType";
    private static String REFADDRESSES = "RefAddresses";
    private static String NAME = "name";
    private static String CLASSNAME = "className";
    private static String CREDSTOREKEY = "credentialStoreKey";
    private static String ADF_CREDSTOREMAP = "adfCredentialStoreMapName";
    private static String ADF_CREDSTOREKEY = "adfCredentialStoreKey";
    private static String PARTIAL = "partial";
    private static String DEPLOYABLE = "deployable";
    private static String MANAGE_IN_ORA_EM = "manageInOracleEnterpriseManager";
    private static String FACTORY = "Factory";
    private static String CONTENTS = "Contents";
    private static String PROPERTY = "Property";
    private static String VALUE = "Value";
    private static final String resourceBundle = "oracle.adf.share.jndi.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.jndi.resources.Messages");
    private static ADFLogger mLogger = null;
    private static XSDValidator xsdValidator = null;
    private static XSDBuilder builder = null;

    private DocumentHelper() {
    }

    public static List getReference(NodeList nl) {
        ArrayList<ReferenceType> reference = new ArrayList<ReferenceType>();
        int size = nl.getLength();
        for (int i = 0; i < size; ++i) {
            Node mgmNode;
            Node deployNode;
            Node partialNode;
            Node credStoreKeyNode;
            Node adfCredStoreMapNode;
            Element node = null;
            if (!(nl.item(i) instanceof Element)) continue;
            node = (Element)nl.item(i);
            ReferenceType refType = new ReferenceType();
            NamedNodeMap attrMap = node.getAttributes();
            Node connNode = attrMap.getNamedItem(NAME);
            String connectionName = connNode.getNodeValue();
            Node classNameNode = attrMap.getNamedItem(CLASSNAME);
            String className = classNameNode.getNodeValue();
            refType.setName(connectionName);
            refType.setClassName(className);
            Node adfCredStoreKeyNode = attrMap.getNamedItem(ADF_CREDSTOREKEY);
            if (adfCredStoreKeyNode != null) {
                refType.setAdfCredentialStoreKey(adfCredStoreKeyNode.getNodeValue());
            }
            if ((adfCredStoreMapNode = attrMap.getNamedItem(ADF_CREDSTOREMAP)) != null) {
                refType.setAdfCredentialStoreMapName(adfCredStoreMapNode.getNodeValue());
            }
            if ((credStoreKeyNode = attrMap.getNamedItem(CREDSTOREKEY)) != null) {
                refType.setCredentialStoreKey(credStoreKeyNode.getNodeValue());
            }
            if ((partialNode = attrMap.getNamedItem(PARTIAL)) != null) {
                refType.setPartial(Boolean.parseBoolean(partialNode.getNodeValue()));
            }
            if ((deployNode = attrMap.getNamedItem(DEPLOYABLE)) != null) {
                refType.setDeployable(Boolean.parseBoolean(deployNode.getNodeValue()));
            }
            if ((mgmNode = attrMap.getNamedItem(MANAGE_IN_ORA_EM)) != null) {
                refType.setManageInOracleEnterpriseManager(Boolean.parseBoolean(mgmNode.getNodeValue()));
            }
            NodeList fl = node.getChildNodes();
            Element flElement = null;
            for (int l = 0; l < fl.getLength(); ++l) {
                Node flNode = fl.item(l);
                if (!(flNode instanceof Element)) continue;
                flElement = (Element)flNode;
                String flElementName = flElement.getNodeName();
                if (flElementName.equals(FACTORY)) {
                    Element factory = flElement;
                    ReferenceFactoryType rft = new ReferenceFactoryType();
                    rft.setClassName(factory.getAttribute(CLASSNAME));
                    NodeList pl = factory.getElementsByTagName(PROPERTY);
                    for (int j = 0; j < pl.getLength(); ++j) {
                        Node pValueNode;
                        PropertyType pt = new PropertyType();
                        Node pNode = pl.item(j);
                        NamedNodeMap pAttrMap = pNode.getAttributes();
                        Node pNameNode = pAttrMap.getNamedItem(NAME);
                        if (pNameNode != null) {
                            pt.setName(pNameNode.getNodeValue());
                        }
                        if ((pValueNode = pAttrMap.getNamedItem(VALUE)) != null) {
                            pt.setValue(pValueNode.getNodeValue());
                        }
                        rft.getProperty().add(pt);
                    }
                    refType.setFactory(rft);
                    continue;
                }
                if (!flElementName.equals(REFADDRESSES)) continue;
                RefAddressListType refAddrListType = new RefAddressListType();
                refType.setRefAddresses(refAddrListType);
                Element refAddresses = flElement;
                NodeList refAddrList = refAddresses.getChildNodes();
                Element refAddrEle = null;
                for (int k = 0; k < refAddrList.getLength(); ++k) {
                    Node refAddrListNode = refAddrList.item(k);
                    if (!(refAddrListNode instanceof Element)) continue;
                    refAddrEle = (Element)refAddrListNode;
                    String refAddrName = refAddrEle.getNodeName();
                    String addrType = refAddrEle.getAttribute(ADDR_TYPE);
                    if (STRING_REFADDR.equals(refAddrName) || METADATA_REFADDR.equals(refAddrName)) {
                        DocumentHelper.createStringOrMetaDataRefAddrType(refAddrEle, refAddrListType, refAddrName, addrType);
                        continue;
                    }
                    if (SECURE_REFADDR.equals(refAddrName)) {
                        SecureRefAddrType secRefAddr = new SecureRefAddrType();
                        secRefAddr.setAddrType(addrType);
                        refAddrListType.getReferenceAddrGroup().add(secRefAddr);
                        continue;
                    }
                    if (!XML_REFADDR.equals(refAddrName)) continue;
                    XmlRefAddrType xmlRefAddr = DocumentHelper.createXmlRefAddrTypeObject(refAddrEle, addrType);
                    refAddrListType.getReferenceAddrGroup().add(xmlRefAddr);
                }
            }
            reference.add(refType);
        }
        return reference;
    }

    private static void createStringOrMetaDataRefAddrType(Element refAddrEle, RefAddressListType refAddrListType, String refAddrName, String addrType) {
        NodeList contentsList = refAddrEle.getElementsByTagName(CONTENTS);
        if (contentsList.getLength() == 1) {
            Element contents = (Element)contentsList.item(0);
            NodeList contentChildList = contents.getChildNodes();
            StringBuilder buf = new StringBuilder();
            for (int m = 0; m < contentChildList.getLength(); ++m) {
                if (!(contentChildList.item(m) instanceof Text)) continue;
                buf.append(((Text)contentChildList.item(m)).getData());
            }
            if (STRING_REFADDR.equals(refAddrName)) {
                StringRefAddrType strRefAddr = new StringRefAddrType();
                strRefAddr.setAddrType(addrType);
                strRefAddr.setContents(buf.toString());
                refAddrListType.getReferenceAddrGroup().add(strRefAddr);
            } else if (METADATA_REFADDR.equals(refAddrName)) {
                MetadataRefAddrType mtRefAddr = new MetadataRefAddrType();
                mtRefAddr.setAddrType(addrType);
                mtRefAddr.setContents(buf.toString());
                refAddrListType.getReferenceAddrGroup().add(mtRefAddr);
            }
        }
    }

    private static XmlRefAddrType createXmlRefAddrTypeObject(Element refAddrEle, String addrType) {
        XmlRefAddrType xmlRefAddr = new XmlRefAddrType();
        Node contentsNode = refAddrEle.getElementsByTagName("Contents").item(0);
        xmlRefAddr.setAddrType(addrType);
        AnyXmlType anyXmlType = new AnyXmlType();
        NodeList contentsList = contentsNode.getChildNodes();
        for (int n = 0; n < contentsList.getLength(); ++n) {
            Node nodeCl = contentsList.item(n);
            if (!(nodeCl instanceof Element)) continue;
            anyXmlType.getAny().add(nodeCl);
        }
        xmlRefAddr.setContents(anyXmlType);
        return xmlRefAddr;
    }

    private static Element createReferenceElement(Document doc, ReferenceType refType) {
        Element element = doc.createElement(REFERENCE);
        element.setAttribute(NAME, refType.getName());
        element.setAttribute(CLASSNAME, refType.getClassName());
        if (refType.getCredentialStoreKey() != null) {
            element.setAttribute(CREDSTOREKEY, refType.getCredentialStoreKey());
        }
        if (refType.getAdfCredentialStoreKey() != null) {
            element.setAttribute(ADF_CREDSTOREKEY, refType.getAdfCredentialStoreKey());
        }
        if (refType.getAdfCredentialStoreMapName() != null) {
            element.setAttribute(ADF_CREDSTOREMAP, refType.getAdfCredentialStoreMapName());
        }
        if (refType.isPartial() != null) {
            element.setAttribute(PARTIAL, refType.isPartial().toString());
        }
        if (refType.isManageInOracleEnterpriseManager() != null) {
            element.setAttribute(MANAGE_IN_ORA_EM, refType.isManageInOracleEnterpriseManager().toString());
        }
        if (refType.isDeployable() != null) {
            element.setAttribute(DEPLOYABLE, refType.isDeployable().toString());
        }
        Element factoryElement = doc.createElement(FACTORY);
        DocumentHelper.buildFactoryElement(factoryElement, refType);
        element.appendChild(factoryElement);
        DocumentHelper.buildRefAddressElement(element, refType);
        return element;
    }

    public static Element createReferenceElement(Document doc, String name, Reference ref) {
        Element element = doc.createElementNS("", REFERENCE);
        element.setAttribute(NAME, name);
        element.setAttribute(CLASSNAME, ref.getClassName());
        if (ref instanceof ConnectionReference) {
            String adfCredStoreKey;
            String adfCredMapName;
            ConnectionReference connRef = (ConnectionReference)ref;
            if (connRef.isPartial()) {
                String isPartial = Boolean.toString(connRef.isPartial());
                element.setAttribute(PARTIAL, isPartial);
            }
            if (connRef.isDeployable() != null) {
                String isDeployable = Boolean.toString(connRef.isDeployable());
                element.setAttribute(DEPLOYABLE, isDeployable);
            }
            if (connRef.isManageInOracleEnterpriseManager() != null) {
                String isMgmEM = Boolean.toString(connRef.isManageInOracleEnterpriseManager());
                element.setAttribute(MANAGE_IN_ORA_EM, isMgmEM);
            }
            if (connRef.getAdfCredentialStoreMapName() != null && (adfCredMapName = connRef.getAdfCredentialStoreMapName()) != null) {
                element.setAttribute(ADF_CREDSTOREMAP, adfCredMapName);
            }
            if (connRef.getAdfCredentialStoreMapName() != null && (adfCredStoreKey = connRef.getAdfCredentialStoreKey()) != null) {
                element.setAttribute(ADF_CREDSTOREKEY, adfCredStoreKey);
            }
        }
        Element factoryElement = doc.createElement(FACTORY);
        DocumentHelper.buildFactoryElement(factoryElement, ref);
        element.appendChild(factoryElement);
        DocumentHelper.buildRefAddressElement(element, ref);
        return element;
    }

    public static Element createRefAddrElement(Document doc, RefAddr refAddr) {
        Element elem = null;
        if (refAddr instanceof StringRefAddr) {
            elem = doc.createElement(STRING_REFADDR);
            String contents = (String)refAddr.getContent();
            Text txtNode = doc.createTextNode(contents);
            Element contentElem = doc.createElement(CONTENTS);
            contentElem.appendChild(txtNode);
            elem.appendChild(contentElem);
        } else if (refAddr instanceof SecureRefAddr) {
            elem = doc.createElement(SECURE_REFADDR);
        } else if (refAddr instanceof XmlRefAddr) {
            elem = doc.createElement(XML_REFADDR);
            Element contentElem = doc.createElement(CONTENTS);
            DocumentFragment contents = (DocumentFragment)refAddr.getContent();
            Node xmlRefAdderContent = doc.importNode(contents, true);
            contentElem.appendChild(xmlRefAdderContent);
            elem.appendChild(contentElem);
        } else if (refAddr instanceof MetadataRefAddr) {
            elem = doc.createElement(METADATA_REFADDR);
            String contents = (String)refAddr.getContent();
            Text txtNode = doc.createTextNode(contents);
            Element contentElem = doc.createElement(CONTENTS);
            contentElem.appendChild(txtNode);
            elem.appendChild(contentElem);
        }
        elem.setAttribute(ADDR_TYPE, refAddr.getType());
        return elem;
    }

    public static void updateRefAddrElement(Element elem, RefAddr refAddr) {
        Document doc = elem.getOwnerDocument();
        if (refAddr instanceof StringRefAddr) {
            String contents = (String)refAddr.getContent();
            Element contentsElem = (Element)elem.getElementsByTagName("Contents").item(0);
            NodeList contentChildnodeList = contentsElem.getChildNodes();
            for (int i = 0; i < contentChildnodeList.getLength(); ++i) {
                contentsElem.removeChild(contentChildnodeList.item(i));
            }
            Text txtNode = doc.createTextNode(contents);
            contentsElem.appendChild(txtNode);
            elem.appendChild(contentsElem);
        } else if (refAddr instanceof XmlRefAddr) {
            Element contentElem = doc.createElement(CONTENTS);
            Element contentsElem = (Element)elem.getElementsByTagName("Contents").item(0);
            DocumentFragment contents = (DocumentFragment)refAddr.getContent();
            NodeList contentChildnodeList = contentsElem.getChildNodes();
            for (int i = 0; i < contentChildnodeList.getLength(); ++i) {
                contentsElem.removeChild(contentChildnodeList.item(i));
            }
            Node xmlRefAdderContent = doc.importNode(contents, true);
            contentElem.appendChild(xmlRefAdderContent);
            elem.appendChild(contentElem);
        } else if (refAddr instanceof MetadataRefAddr) {
            String contents = (String)refAddr.getContent();
            Element contentsElem = (Element)elem.getElementsByTagName("Contents").item(0);
            NodeList contentChildnodeList = contentsElem.getChildNodes();
            for (int i = 0; i < contentChildnodeList.getLength(); ++i) {
                contentsElem.removeChild(contentChildnodeList.item(i));
            }
            Text txtNode = doc.createTextNode(contents);
            contentsElem.appendChild(txtNode);
            elem.appendChild(contentsElem);
        }
        elem.setAttribute(ADDR_TYPE, refAddr.getType());
    }

    public static Document createConnectionsDocument(ReferenceListType refListType) throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element rfs = doc.createElementNS(NAMESPACE_ADF_JNDI, REFERENCES);
        doc.appendChild(rfs);
        List<ReferenceType> referenceList = refListType.getReference();
        if (referenceList.size() <= 0) {
            return doc;
        }
        for (ReferenceType refType : referenceList) {
            Element el = DocumentHelper.createReferenceElement(doc, refType);
            rfs.appendChild(el);
        }
        return doc;
    }

    private static Document createDocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().newDocument();
    }

    private static void buildFactoryElement(Element element, Reference ref) {
        element.setAttribute(CLASSNAME, ref.getFactoryClassName());
    }

    private static void buildRefAddressElement(Element element, Reference ref) {
        Document doc = element.getOwnerDocument();
        Element refAddresses = doc.createElement(REFADDRESSES);
        Enumeration<RefAddr> e = ref.getAll();
        boolean containsSecRefAddr = false;
        while (e.hasMoreElements()) {
            Element contentEl;
            String contents;
            RefAddr refAddr = e.nextElement();
            Element refAddrElm = null;
            if (refAddr instanceof StringRefAddr) {
                refAddrElm = doc.createElement(STRING_REFADDR);
                contents = (String)refAddr.getContent();
                contentEl = doc.createElement(CONTENTS);
                contentEl.appendChild(doc.createTextNode(contents));
                refAddrElm.appendChild(contentEl);
            } else if (refAddr instanceof SecureRefAddr) {
                refAddrElm = doc.createElement(SECURE_REFADDR);
                containsSecRefAddr = true;
            } else if (refAddr instanceof XmlRefAddr) {
                refAddrElm = doc.createElement(XML_REFADDR);
                Element contentEl2 = doc.createElement(CONTENTS);
                refAddrElm.appendChild(contentEl2);
                DocumentFragment df = ((XmlRefAddr)refAddr).getDocumentFragment();
                Node importedNode = refAddrElm.getOwnerDocument().importNode(df, true);
                contentEl2.appendChild(importedNode);
            } else if (refAddr instanceof MetadataRefAddr) {
                refAddrElm = doc.createElement(METADATA_REFADDR);
                contents = (String)refAddr.getContent();
                contentEl = doc.createElement(CONTENTS);
                contentEl.appendChild(doc.createTextNode(contents));
                refAddrElm.appendChild(contentEl);
            }
            refAddrElm.setAttribute(ADDR_TYPE, refAddr.getType());
            refAddresses.appendChild(refAddrElm);
        }
        element.appendChild(refAddresses);
        if (containsSecRefAddr) {
            String name = element.getAttribute(NAME);
            element.setAttribute(CREDSTOREKEY, name);
        }
    }

    private static void buildRefAddressElement(Element element, ReferenceType refType) {
        Document doc = element.getOwnerDocument();
        RefAddressListType refAddrListType = refType.getRefAddresses();
        if (refAddrListType == null) {
            return;
        }
        List<RefAddrType> refAddrTypeList = refAddrListType.getReferenceAddrGroup();
        int size = refAddrTypeList.size();
        if (size <= 0) {
            return;
        }
        Element refAddresses = doc.createElement(REFADDRESSES);
        for (RefAddrType refAddrType : refAddrTypeList) {
            Element contentEl;
            String contents;
            Element refAddr = null;
            if (refAddrType instanceof StringRefAddrType) {
                refAddr = doc.createElement(STRING_REFADDR);
                contents = ((StringRefAddrType)refAddrType).getContents();
                contentEl = doc.createElement(CONTENTS);
                contentEl.appendChild(doc.createTextNode(contents));
                refAddr.appendChild(contentEl);
            } else if (refAddrType instanceof SecureRefAddrType) {
                refAddr = doc.createElement(SECURE_REFADDR);
            } else if (refAddrType instanceof XmlRefAddrType) {
                refAddr = doc.createElement(XML_REFADDR);
                Element contentEl2 = doc.createElement(CONTENTS);
                refAddr.appendChild(contentEl2);
                AnyXmlType anyXmlType = ((XmlRefAddrType)refAddrType).getContents();
                List<Object> list = anyXmlType.getAny();
                for (Object el : list) {
                    if (!(el instanceof Node)) continue;
                    Node importedNode = refAddr.getOwnerDocument().importNode((Node)el, true);
                    contentEl2.appendChild(importedNode);
                }
            } else if (refAddrType instanceof MetadataRefAddrType) {
                refAddr = doc.createElement(METADATA_REFADDR);
                contents = ((MetadataRefAddrType)refAddrType).getContents();
                contentEl = doc.createElement(CONTENTS);
                contentEl.appendChild(doc.createTextNode(contents));
                refAddr.appendChild(contentEl);
            }
            refAddr.setAttribute(ADDR_TYPE, refAddrType.getAddrType());
            refAddresses.appendChild(refAddr);
        }
        element.appendChild(refAddresses);
    }

    private static void buildFactoryElement(Element element, ReferenceType refType) {
        ReferenceFactoryType refFacType = refType.getFactory();
        element.setAttribute(CLASSNAME, refFacType.getClassName());
        List<PropertyType> propList = refFacType.getProperty();
        for (PropertyType pType : propList) {
            Element pEle = element.getOwnerDocument().createElement(PROPERTY);
            if (pType.getName() != null) {
                pEle.setAttribute(NAME, pType.getName());
            }
            if (pType.getValue() == null) continue;
            pEle.setAttribute(NAME, pType.getValue());
        }
    }

    static void buildConnectionsDocument(Document doc, ReferenceListType refListType) {
        List<ReferenceType> referenceList;
        Element rfs = doc.getDocumentElement();
        if (rfs == null) {
            rfs = doc.createElementNS(NAMESPACE_ADF_JNDI, REFERENCES);
            doc.appendChild(rfs);
        }
        if ((referenceList = refListType.getReference()).size() <= 0) {
            return;
        }
        for (ReferenceType refType : referenceList) {
            Element el = DocumentHelper.createReferenceElement(doc, refType);
            rfs.appendChild(el);
        }
    }

    private static XSDValidator getValidator() throws Exception {
        if (xsdValidator == null) {
            xsdValidator = new XSDValidator();
        }
        return xsdValidator;
    }

    private static XSDBuilder getXSDBuilder() throws Exception {
        if (builder == null) {
            builder = new XSDBuilder();
        }
        return builder;
    }

    static boolean validateConnectionsDocument(URL url, URL XmlDocumentUrl) {
        try {
            DocumentHelper.getValidator();
            DocumentHelper.getXSDBuilder();
            XMLSchema schemadoc = builder.build(url);
            xsdValidator.setSchema(schemadoc);
            Validator handler = new Validator();
            XMLError xmlError = new XMLError();
            xmlError.setErrorHandler((ErrorHandler)handler);
            xsdValidator.setError(xmlError);
            xsdValidator.validate(XmlDocumentUrl);
            if (handler.validationError) {
                DocumentHelper.getLogger().severe(resBundle.getString("XML_VALID_ERR"), new Object[]{XmlDocumentUrl.getPath(), handler.saxParseException.getMessage()});
                throw new ConnectionException(handler.saxParseException);
            }
            DocumentHelper.getLogger().finest(resBundle.getString("XML_VALID"), new Object[]{XmlDocumentUrl.getPath()});
        }
        catch (Exception ioe) {
            DocumentHelper.getLogger().severe((Throwable)ioe);
            throw new ConnectionException(ioe);
        }
        return true;
    }

    private static ADFLogger getLogger() {
        if (mLogger == null) {
            mLogger = ADFLogger.createADFLogger((String)"oracle.adf.share.jndi.DocumentHelper");
        }
        return mLogger;
    }

    private static class Validator
    extends DefaultHandler {
        public boolean validationError = false;
        public SAXParseException saxParseException = null;

        private Validator() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

