/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;

class NameParserImpl
implements NameParser {
    public static final String DIRECTION = "left_to_right";
    public static final String SEPARATOR = "/";
    public static final boolean IGNORE_CASE = false;
    public static final String ESCAPE = "\\";
    public static final String BEGIN_QUOTE = "'";
    private static final Properties syntax = new Properties();
    private static final NameParserImpl mInstance;

    private NameParserImpl() {
    }

    static NameParserImpl getInstance() {
        return mInstance;
    }

    @Override
    public Name parse(String name) throws NamingException {
        return this.createCompoundName(name);
    }

    CompoundName createCompoundName(String name) throws NamingException {
        return new CompoundName(name, syntax);
    }

    static {
        syntax.put("jndi.syntax.direction", DIRECTION);
        syntax.put("jndi.syntax.separator", SEPARATOR);
        syntax.put("jndi.syntax.ignorecase", (Object)false);
        syntax.put("jndi.syntax.escape", ESCAPE);
        syntax.put("jndi.syntax.beginquote", BEGIN_QUOTE);
        mInstance = new NameParserImpl();
    }
}

